/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;

public class ElkClassInclusionReflexivePropertyRange
extends AbstractElkInference {
    public static final String NAME = "Reflexive Property Range";
    private final ElkClassExpression subClass_;
    private final ElkClassExpression range_;
    private final ElkObjectPropertyExpression property_;

    ElkClassInclusionReflexivePropertyRange(ElkClassExpression subClass, ElkObjectPropertyExpression property, ElkClassExpression range) {
        this.subClass_ = subClass;
        this.property_ = property;
        this.range_ = range;
    }

    public ElkClassExpression getSubClass() {
        return this.subClass_;
    }

    public ElkObjectPropertyExpression getProperty() {
        return this.property_;
    }

    public ElkClassExpression getRange() {
        return this.range_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 2;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        switch (index) {
            case 0: {
                return this.getFirstPremise(factory);
            }
            case 1: {
                return this.getSecondPremise(factory);
            }
        }
        return (ElkAxiom)ElkClassInclusionReflexivePropertyRange.failGetPremise(index);
    }

    public ElkSubClassOfAxiom getFirstPremise(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom(this.subClass_, (ElkClassExpression)factory.getObjectHasSelf(this.property_));
    }

    public ElkObjectPropertyRangeAxiom getSecondPremise(ElkObject.Factory factory) {
        return factory.getObjectPropertyRangeAxiom(this.property_, this.range_);
    }

    public ElkSubClassOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubClassOfAxiom(this.subClass_, this.range_);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkClassInclusionReflexivePropertyRange var1);
    }

    public static interface Factory {
        public ElkClassInclusionReflexivePropertyRange getElkClassInclusionReflexivePropertyRange(ElkClassExpression var1, ElkObjectPropertyExpression var2, ElkClassExpression var3);
    }
}

