/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;

public class ElkDifferentIndividualsOfDisjointClasses
extends AbstractElkInference {
    public static final String NAME = "Different Individuals Introduction";
    private final List<? extends ElkIndividual> different_;

    ElkDifferentIndividualsOfDisjointClasses(List<? extends ElkIndividual> different) {
        this.different_ = different;
    }

    public List<? extends ElkIndividual> getDifferent() {
        return this.different_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 1;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        if (index == 0) {
            return this.getPremise(factory);
        }
        return (ElkAxiom)ElkDifferentIndividualsOfDisjointClasses.failGetPremise(index);
    }

    public ElkDisjointClassesAxiom getPremise(ElkObject.Factory factory) {
        ArrayList<ElkObjectOneOf> disjoint = new ArrayList<ElkObjectOneOf>(this.different_.size());
        for (ElkIndividual elkIndividual : this.different_) {
            disjoint.add(factory.getObjectOneOf(Collections.singletonList(elkIndividual)));
        }
        return factory.getDisjointClassesAxiom(disjoint);
    }

    public ElkDifferentIndividualsAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getDifferentIndividualsAxiom(this.different_);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkDifferentIndividualsOfDisjointClasses var1);
    }

    public static interface Factory {
        public ElkDifferentIndividualsOfDisjointClasses getElkDifferentIndividualsOfDisjointClasses(List<? extends ElkIndividual> var1);
    }
}

