/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointUnionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;

public class ElkDisjointClassesOfDisjointUnion
extends AbstractElkInference {
    public static final String NAME = "Disjoint Union to Disjoint Classes";
    private final ElkClass defined_;
    private final List<? extends ElkClassExpression> disjoint_;

    ElkDisjointClassesOfDisjointUnion(ElkClass defined, List<? extends ElkClassExpression> disjoint) {
        this.defined_ = defined;
        this.disjoint_ = disjoint;
    }

    public ElkClass getDefined() {
        return this.defined_;
    }

    public List<? extends ElkClassExpression> getDisjoint() {
        return this.disjoint_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 1;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        if (index == 0) {
            return this.getPremise(factory);
        }
        return (ElkAxiom)ElkDisjointClassesOfDisjointUnion.failGetPremise(index);
    }

    public ElkDisjointUnionAxiom getPremise(ElkObject.Factory factory) {
        return factory.getDisjointUnionAxiom(this.defined_, this.disjoint_);
    }

    public ElkDisjointClassesAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getDisjointClassesAxiom(this.disjoint_);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkDisjointClassesOfDisjointUnion var1);
    }

    public static interface Factory {
        public ElkDisjointClassesOfDisjointUnion getElkDisjointClassesOfDisjointUnion(ElkClass var1, List<? extends ElkClassExpression> var2);
    }
}

