/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.semanticweb.elk.owl.implementation.ElkObjectBaseFactory;
import org.semanticweb.elk.owl.inferences.ElkClassInclusionExistentialComposition;
import org.semanticweb.elk.owl.inferences.ElkClassInclusionExistentialRange;
import org.semanticweb.elk.owl.inferences.ElkClassInclusionExistentialTransitivity;
import org.semanticweb.elk.owl.inferences.ElkClassInclusionHierarchy;
import org.semanticweb.elk.owl.inferences.ElkInferenceProducer;
import org.semanticweb.elk.owl.inferences.ElkInferenceProducingFactory;
import org.semanticweb.elk.owl.inferences.ElkPropertyInclusionHierarchy;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;

public class ElkInferenceOptimizedProducingFactory
extends ElkInferenceProducingFactory {
    private final ElkObject.Factory elkFactory_;

    public ElkInferenceOptimizedProducingFactory(ElkInferenceProducer inferenceProducer) {
        this(inferenceProducer, (ElkObject.Factory)new ElkObjectBaseFactory());
    }

    public ElkInferenceOptimizedProducingFactory(ElkInferenceProducer inferenceProducer, ElkObject.Factory elkFactory) {
        super(inferenceProducer);
        this.elkFactory_ = elkFactory;
    }

    @Override
    public ElkClassInclusionExistentialComposition getElkClassInclusionExistentialComposition(List<? extends ElkClassExpression> classExpressions, List<? extends ElkObjectPropertyExpression> subChain, ElkObjectPropertyExpression superProperty) {
        switch (subChain.size()) {
            case 0: {
                throw new IllegalArgumentException(subChain.toString() + " should not be empty");
            }
            case 1: {
                ElkObjectPropertyExpression subProperty = subChain.get(0);
                ElkClassExpression subClass = classExpressions.get(0);
                ElkClassExpression filler = classExpressions.get(1);
                super.getElkClassInclusionExistentialPropertyExpansion(subProperty, superProperty, filler);
                super.getElkClassInclusionHierarchy(new ElkClassExpression[]{subClass, this.elkFactory_.getObjectSomeValuesFrom(subProperty, filler), this.elkFactory_.getObjectSomeValuesFrom(superProperty, filler)});
                return null;
            }
        }
        super.getElkClassInclusionExistentialComposition(classExpressions, subChain, superProperty);
        return null;
    }

    @Override
    public ElkClassInclusionExistentialTransitivity getElkClassInclusionExistentialTransitivity(ElkObjectPropertyExpression transitiveProperty, ElkClassExpression ... classExpressions) {
        return this.getElkClassInclusionExistentialTransitivity(transitiveProperty, Arrays.asList(classExpressions));
    }

    @Override
    public ElkClassInclusionExistentialTransitivity getElkClassInclusionExistentialTransitivity(ElkObjectPropertyExpression transitiveProperty, List<? extends ElkClassExpression> classExpressions) {
        if ((classExpressions = this.removeRepetitions(classExpressions)).size() > 2) {
            super.getElkClassInclusionExistentialTransitivity(transitiveProperty, classExpressions);
        }
        return null;
    }

    @Override
    public ElkClassInclusionHierarchy getElkClassInclusionHierarchy(ElkClassExpression ... expressions) {
        return this.getElkClassInclusionHierarchy(Arrays.asList(expressions));
    }

    @Override
    public ElkClassInclusionHierarchy getElkClassInclusionHierarchy(List<? extends ElkClassExpression> expressions) {
        if ((expressions = this.removeRepetitions(expressions)).size() > 2) {
            super.getElkClassInclusionHierarchy(expressions);
        }
        return null;
    }

    @Override
    public ElkPropertyInclusionHierarchy getElkPropertyInclusionHierarchy(ElkSubObjectPropertyExpression subExpression, ElkObjectPropertyExpression ... expressions) {
        return this.getElkPropertyInclusionHierarchy(subExpression, Arrays.asList(expressions));
    }

    @Override
    public ElkPropertyInclusionHierarchy getElkPropertyInclusionHierarchy(ElkSubObjectPropertyExpression subExpression, List<? extends ElkObjectPropertyExpression> expressions) {
        if ((expressions = this.removeRepetitions(expressions)).size() > 1) {
            super.getElkPropertyInclusionHierarchy(subExpression, expressions);
        }
        return null;
    }

    @Override
    public ElkClassInclusionExistentialRange getElkClassInclusionExistentialRange(ElkObjectPropertyExpression property, ElkClassExpression filler, List<? extends ElkClassExpression> ranges) {
        if (ranges.isEmpty()) {
            return null;
        }
        super.getElkClassInclusionExistentialRange(property, filler, ranges);
        return null;
    }

    <E> List<? extends E> removeRepetitions(List<? extends E> input) {
        HashMap<E, Integer> lastPositions = new HashMap<E, Integer>(input.size());
        for (int pos = 0; pos < input.size(); ++pos) {
            lastPositions.put(input.get(pos), pos);
        }
        int uniqueCount = lastPositions.size();
        if (input.size() == uniqueCount) {
            return input;
        }
        ArrayList<E> result = new ArrayList<E>(uniqueCount);
        int nextPos = 0;
        for (int pos = 0; pos < input.size(); ++pos) {
            if (pos < nextPos) continue;
            E e = input.get(pos);
            result.add(e);
            nextPos = (Integer)lastPositions.get(e) + 1;
        }
        return result;
    }
}

