/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.liveontologies.puli.Proof;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.matching.Matcher;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDifferentIndividualsAxiom;
import org.semanticweb.elk.owl.interfaces.ElkDisjointClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectHasValue;
import org.semanticweb.elk.owl.interfaces.ElkObjectIntersectionOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyAssertionAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyDomainAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.visitors.DummyElkAxiomVisitor;
import org.semanticweb.elk.owl.visitors.ElkAxiomVisitor;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.entailments.model.DerivedClassInclusionEntailsClassAssertionAxiom;
import org.semanticweb.elk.reasoner.entailments.model.DerivedClassInclusionEntailsObjectPropertyAssertionAxiom;
import org.semanticweb.elk.reasoner.entailments.model.DerivedClassInclusionEntailsObjectPropertyDomainAxiom;
import org.semanticweb.elk.reasoner.entailments.model.DerivedClassInclusionEntailsSubClassOfAxiom;
import org.semanticweb.elk.reasoner.entailments.model.DisjointClassesAxiomEntailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailedClassInclusionCycleEntailsEquivalentClassesAxiom;
import org.semanticweb.elk.reasoner.entailments.model.EntailedDisjointClassesEntailsDifferentIndividualsAxiom;
import org.semanticweb.elk.reasoner.entailments.model.EntailedEquivalentClassesEntailsSameIndividualAxiom;
import org.semanticweb.elk.reasoner.entailments.model.EntailedIntersectionInconsistencyEntailsDisjointClassesAxiom;
import org.semanticweb.elk.reasoner.entailments.model.Entailment;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.entailments.model.EquivalentClassesAxiomEntailment;
import org.semanticweb.elk.reasoner.entailments.model.IndividualInconsistencyEntailsOntologyInconsistency;
import org.semanticweb.elk.reasoner.entailments.model.OntologyInconsistency;
import org.semanticweb.elk.reasoner.entailments.model.OntologyInconsistencyEntailsAnyAxiom;
import org.semanticweb.elk.reasoner.entailments.model.OwlThingInconsistencyEntailsOntologyInconsistency;
import org.semanticweb.elk.reasoner.entailments.model.SubClassInconsistencyEntailsSubClassOfAxiom;
import org.semanticweb.elk.reasoner.entailments.model.SubClassOfAxiomEntailment;
import org.semanticweb.elk.reasoner.entailments.model.TopObjectPropertyInBottomEntailsOntologyInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.ClassInconsistency;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubClassInclusionComposed;
import org.semanticweb.elk.reasoner.saturation.conclusions.model.SubPropertyChain;

public class ElkProofGenerator
implements EntailmentInference.Visitor<Void> {
    private final Proof<? extends EntailmentInference> evidence_;
    private final Reasoner reasoner_;
    private final ElkObject.Factory elkFactory_;
    private final ElkInference.Factory inferenceFactory_;

    public ElkProofGenerator(Proof<? extends EntailmentInference> evidence, Reasoner reasoner, ElkObject.Factory elkFactory, ElkInference.Factory inferenceFactory) {
        this.evidence_ = evidence;
        this.reasoner_ = reasoner;
        this.elkFactory_ = elkFactory;
        this.inferenceFactory_ = inferenceFactory;
    }

    public ElkProofGenerator(Proof<? extends EntailmentInference> evidence, Reasoner reasoner, ElkInference.Factory inferenceFactory) {
        this(evidence, reasoner, reasoner.getElkFactory(), inferenceFactory);
    }

    public void generate(Entailment goalEntailment) throws ElkException {
        block3: {
            try {
                for (EntailmentInference inf : this.evidence_.getInferences((Object)goalEntailment)) {
                    inf.accept((EntailmentInference.Visitor)this);
                }
            }
            catch (TunnelingException e) {
                ElkException elkException = e.getElkException();
                if (elkException == null) break block3;
                throw e.getElkException();
            }
        }
    }

    public Void visit(DerivedClassInclusionEntailsClassAssertionAxiom entailmentInference) {
        SubClassInclusionComposed conclusion = (SubClassInclusionComposed)entailmentInference.getReason();
        ElkIndividual instance = ((ElkClassAssertionAxiom)entailmentInference.getConclusion().getAxiom()).getIndividual();
        ElkObjectOneOf nominal = this.elkFactory_.getObjectOneOf(instance, new ElkIndividual[0]);
        ElkClassExpression type = ((ElkClassAssertionAxiom)entailmentInference.getConclusion().getAxiom()).getClassExpression();
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, (ElkClassExpression)nominal, type);
        this.inferenceFactory_.getElkClassAssertionOfClassInclusion(instance, type);
        return null;
    }

    public Void visit(DerivedClassInclusionEntailsObjectPropertyAssertionAxiom entailmentInference) {
        SubClassInclusionComposed conclusion = (SubClassInclusionComposed)entailmentInference.getReason();
        ElkIndividual subject = (ElkIndividual)((ElkObjectPropertyAssertionAxiom)entailmentInference.getConclusion().getAxiom()).getSubject();
        ElkObjectPropertyExpression property = (ElkObjectPropertyExpression)((ElkObjectPropertyAssertionAxiom)entailmentInference.getConclusion().getAxiom()).getProperty();
        ElkIndividual object = (ElkIndividual)((ElkObjectPropertyAssertionAxiom)entailmentInference.getConclusion().getAxiom()).getObject();
        ElkObjectOneOf subClass = this.elkFactory_.getObjectOneOf(subject, new ElkIndividual[0]);
        ElkObjectSomeValuesFrom superClass = this.elkFactory_.getObjectSomeValuesFrom(property, (ElkClassExpression)this.elkFactory_.getObjectOneOf(object, new ElkIndividual[0]));
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, (ElkClassExpression)subClass, (ElkClassExpression)superClass);
        this.inferenceFactory_.getElkObjectPropertyAssertionOfClassInclusion(subject, property, object);
        return null;
    }

    public Void visit(DerivedClassInclusionEntailsObjectPropertyDomainAxiom entailmentInference) {
        SubClassInclusionComposed conclusion = (SubClassInclusionComposed)entailmentInference.getReason();
        ElkObjectPropertyExpression property = (ElkObjectPropertyExpression)((ElkObjectPropertyDomainAxiom)entailmentInference.getConclusion().getAxiom()).getProperty();
        ElkClassExpression domain = (ElkClassExpression)((ElkObjectPropertyDomainAxiom)entailmentInference.getConclusion().getAxiom()).getDomain();
        ElkObjectSomeValuesFrom subClass = this.elkFactory_.getObjectSomeValuesFrom(property, (ElkClassExpression)this.elkFactory_.getOwlThing());
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, (ElkClassExpression)subClass, domain);
        this.inferenceFactory_.getElkObjectPropertyDomainOfClassInclusion(property, domain);
        return null;
    }

    public Void visit(DerivedClassInclusionEntailsSubClassOfAxiom entailmentInference) {
        SubClassInclusionComposed conclusion = (SubClassInclusionComposed)entailmentInference.getReason();
        ElkClassExpression subClass = ((ElkSubClassOfAxiom)entailmentInference.getConclusion().getAxiom()).getSubClassExpression();
        ElkClassExpression superClass = ((ElkSubClassOfAxiom)entailmentInference.getConclusion().getAxiom()).getSuperClassExpression();
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, subClass, superClass);
        return null;
    }

    public Void visit(EntailedClassInclusionCycleEntailsEquivalentClassesAxiom entailmentInference) {
        for (SubClassOfAxiomEntailment premise : entailmentInference.getPremises()) {
            for (EntailmentInference inf : this.evidence_.getInferences((Object)premise)) {
                inf.accept((EntailmentInference.Visitor)this);
            }
        }
        this.inferenceFactory_.getElkEquivalentClassesCycle(((ElkEquivalentClassesAxiom)entailmentInference.getConclusion().getAxiom()).getClassExpressions());
        return null;
    }

    public Void visit(EntailedDisjointClassesEntailsDifferentIndividualsAxiom entailmentInference) {
        for (DisjointClassesAxiomEntailment premise : entailmentInference.getPremises()) {
            for (EntailmentInference inf : this.evidence_.getInferences((Object)premise)) {
                inf.accept((EntailmentInference.Visitor)this);
            }
        }
        this.inferenceFactory_.getElkDifferentIndividualsOfDisjointClasses(((ElkDifferentIndividualsAxiom)entailmentInference.getConclusion().getAxiom()).getIndividuals());
        return null;
    }

    public Void visit(EntailedEquivalentClassesEntailsSameIndividualAxiom entailmentInference) {
        for (EquivalentClassesAxiomEntailment premise : entailmentInference.getPremises()) {
            for (EntailmentInference inf : this.evidence_.getInferences((Object)premise)) {
                inf.accept((EntailmentInference.Visitor)this);
            }
        }
        this.inferenceFactory_.getElkSameIndividualOfEquivalentClasses(((ElkSameIndividualAxiom)entailmentInference.getConclusion().getAxiom()).getIndividuals());
        return null;
    }

    public Void visit(EntailedIntersectionInconsistencyEntailsDisjointClassesAxiom entailmentInference) {
        for (SubClassOfAxiomEntailment premise : entailmentInference.getPremises()) {
            for (EntailmentInference inf : this.evidence_.getInferences((Object)premise)) {
                inf.accept((EntailmentInference.Visitor)this);
            }
        }
        this.inferenceFactory_.getElkDisjointClassesIntersectionInconsistencies(((ElkDisjointClassesAxiom)entailmentInference.getConclusion().getAxiom()).getClassExpressions());
        return null;
    }

    public Void visit(IndividualInconsistencyEntailsOntologyInconsistency entailmentInference) {
        ClassInconsistency conclusion = (ClassInconsistency)entailmentInference.getReason();
        ElkIndividual entity = entailmentInference.getIndividual();
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, entity);
        this.inferenceFactory_.getElkClassInclusionTopObjectHasValue(entity);
        this.inferenceFactory_.getElkEquivalentClassesObjectHasValue((ElkObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty(), entity);
        ElkObjectHasValue hasValue = this.elkFactory_.getObjectHasValue((ElkObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty(), entity);
        ElkObjectOneOf nominal = this.elkFactory_.getObjectOneOf(entity, new ElkIndividual[0]);
        ElkObjectSomeValuesFrom existential = this.elkFactory_.getObjectSomeValuesFrom((ElkObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty(), (ElkClassExpression)nominal);
        this.inferenceFactory_.getElkClassInclusionOfEquivaletClasses((ElkClassExpression)hasValue, (ElkClassExpression)existential, true);
        this.inferenceFactory_.getElkClassInclusionExistentialFillerExpansion((ElkObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty(), (ElkClassExpression)nominal, (ElkClassExpression)this.elkFactory_.getOwlNothing());
        this.inferenceFactory_.getElkClassInclusionExistentialOwlNothing((ElkObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty());
        this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{this.elkFactory_.getOwlThing(), hasValue, existential, this.elkFactory_.getObjectSomeValuesFrom((ElkObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty(), (ElkClassExpression)this.elkFactory_.getOwlNothing()), this.elkFactory_.getOwlNothing()});
        return null;
    }

    public Void visit(OntologyInconsistencyEntailsAnyAxiom entailmentInference) {
        for (OntologyInconsistency premise : entailmentInference.getPremises()) {
            for (EntailmentInference inf : this.evidence_.getInferences((Object)premise)) {
                inf.accept((EntailmentInference.Visitor)this);
            }
        }
        DummyElkAxiomVisitor<Void> axiomVisitor = new DummyElkAxiomVisitor<Void>(){

            public Void defaultVisit(ElkAxiom axiom) {
                throw new ElkRuntimeException("Cannot generate proof for " + String.valueOf(axiom));
            }

            public Void visit(ElkClassAssertionAxiom axiom) {
                ElkIndividual instance = axiom.getIndividual();
                ElkObjectOneOf nominal = ElkProofGenerator.this.elkFactory_.getObjectOneOf(instance, new ElkIndividual[0]);
                ElkClassExpression type = axiom.getClassExpression();
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlThing((ElkClassExpression)nominal);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlNothing(type);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{nominal, ElkProofGenerator.this.elkFactory_.getOwlThing(), ElkProofGenerator.this.elkFactory_.getOwlNothing(), type});
                ElkProofGenerator.this.inferenceFactory_.getElkClassAssertionOfClassInclusion(instance, type);
                return null;
            }

            public Void visit(ElkDifferentIndividualsAxiom axiom) {
                List individuals = axiom.getIndividuals();
                ArrayList<ElkObjectOneOf> nominals = new ArrayList<ElkObjectOneOf>(individuals.size());
                for (ElkIndividual individual : individuals) {
                    nominals.add(ElkProofGenerator.this.elkFactory_.getObjectOneOf(individual, new ElkIndividual[0]));
                }
                ElkProofGenerator.this.elkFactory_.getDisjointClassesAxiom(nominals).accept((ElkAxiomVisitor)this);
                ElkProofGenerator.this.inferenceFactory_.getElkDifferentIndividualsOfDisjointClasses(individuals);
                return null;
            }

            public Void visit(ElkDisjointClassesAxiom axiom) {
                List disjoint = axiom.getClassExpressions();
                int size = disjoint.size();
                for (int first = 0; first < size - 1; ++first) {
                    for (int second = first + 1; second < size; ++second) {
                        ElkObjectIntersectionOf intersection = ElkProofGenerator.this.elkFactory_.getObjectIntersectionOf((ElkClassExpression)disjoint.get(first), (ElkClassExpression)disjoint.get(second), new ElkClassExpression[0]);
                        ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlThing((ElkClassExpression)intersection);
                        ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{intersection, ElkProofGenerator.this.elkFactory_.getOwlThing(), ElkProofGenerator.this.elkFactory_.getOwlNothing()});
                    }
                }
                ElkProofGenerator.this.inferenceFactory_.getElkDisjointClassesIntersectionInconsistencies(disjoint);
                return null;
            }

            public Void visit(ElkEquivalentClassesAxiom axiom) {
                List equivalent = axiom.getClassExpressions();
                ElkClassExpression subClass = (ElkClassExpression)equivalent.get(equivalent.size() - 1);
                for (ElkClassExpression superClass : equivalent) {
                    ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlThing(subClass);
                    ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlNothing(superClass);
                    ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{subClass, ElkProofGenerator.this.elkFactory_.getOwlThing(), ElkProofGenerator.this.elkFactory_.getOwlNothing(), superClass});
                    subClass = superClass;
                }
                ElkProofGenerator.this.inferenceFactory_.getElkEquivalentClassesCycle(equivalent);
                return null;
            }

            public Void visit(ElkObjectPropertyAssertionAxiom axiom) {
                ElkIndividual subject = (ElkIndividual)axiom.getSubject();
                ElkObjectPropertyExpression property = (ElkObjectPropertyExpression)axiom.getProperty();
                ElkIndividual object = (ElkIndividual)axiom.getObject();
                ElkObjectOneOf subClass = ElkProofGenerator.this.elkFactory_.getObjectOneOf(subject, new ElkIndividual[0]);
                ElkObjectSomeValuesFrom superClass = ElkProofGenerator.this.elkFactory_.getObjectSomeValuesFrom(property, (ElkClassExpression)ElkProofGenerator.this.elkFactory_.getObjectOneOf(object, new ElkIndividual[0]));
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlThing((ElkClassExpression)subClass);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlNothing((ElkClassExpression)superClass);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{subClass, ElkProofGenerator.this.elkFactory_.getOwlThing(), ElkProofGenerator.this.elkFactory_.getOwlNothing(), superClass});
                ElkProofGenerator.this.inferenceFactory_.getElkObjectPropertyAssertionOfClassInclusion(subject, property, object);
                return null;
            }

            public Void visit(ElkObjectPropertyDomainAxiom axiom) {
                ElkObjectPropertyExpression property = (ElkObjectPropertyExpression)axiom.getProperty();
                ElkClassExpression domain = (ElkClassExpression)axiom.getDomain();
                ElkObjectSomeValuesFrom subClass = ElkProofGenerator.this.elkFactory_.getObjectSomeValuesFrom(property, (ElkClassExpression)ElkProofGenerator.this.elkFactory_.getOwlThing());
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlThing((ElkClassExpression)subClass);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlNothing(domain);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{subClass, ElkProofGenerator.this.elkFactory_.getOwlThing(), ElkProofGenerator.this.elkFactory_.getOwlNothing(), domain});
                ElkProofGenerator.this.inferenceFactory_.getElkObjectPropertyDomainOfClassInclusion(property, domain);
                return null;
            }

            public Void visit(ElkSameIndividualAxiom axiom) {
                List individuals = axiom.getIndividuals();
                ArrayList<ElkObjectOneOf> nominals = new ArrayList<ElkObjectOneOf>(individuals.size());
                for (ElkIndividual individual : individuals) {
                    nominals.add(ElkProofGenerator.this.elkFactory_.getObjectOneOf(individual, new ElkIndividual[0]));
                }
                ElkProofGenerator.this.elkFactory_.getEquivalentClassesAxiom(nominals).accept((ElkAxiomVisitor)this);
                ElkProofGenerator.this.inferenceFactory_.getElkSameIndividualOfEquivalentClasses(individuals);
                return null;
            }

            public Void visit(ElkSubClassOfAxiom axiom) {
                ElkClassExpression subClass = axiom.getSubClassExpression();
                ElkClassExpression superClass = axiom.getSuperClassExpression();
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlThing(subClass);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionOwlNothing(superClass);
                ElkProofGenerator.this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{subClass, ElkProofGenerator.this.elkFactory_.getOwlThing(), ElkProofGenerator.this.elkFactory_.getOwlNothing(), superClass});
                return null;
            }
        };
        entailmentInference.getConclusion().getAxiom().accept((ElkAxiomVisitor)axiomVisitor);
        return null;
    }

    public Void visit(OwlThingInconsistencyEntailsOntologyInconsistency entailmentInference) {
        ClassInconsistency conclusion = (ClassInconsistency)entailmentInference.getReason();
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, (ElkClassExpression)this.elkFactory_.getOwlThing());
        this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{this.elkFactory_.getOwlThing(), this.elkFactory_.getOwlNothing()});
        return null;
    }

    public Void visit(SubClassInconsistencyEntailsSubClassOfAxiom entailmentInference) {
        ClassInconsistency conclusion = (ClassInconsistency)entailmentInference.getReason();
        ElkClassExpression subClass = ((ElkSubClassOfAxiom)entailmentInference.getConclusion().getAxiom()).getSubClassExpression();
        ElkClassExpression superClass = ((ElkSubClassOfAxiom)entailmentInference.getConclusion().getAxiom()).getSuperClassExpression();
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, subClass);
        this.inferenceFactory_.getElkClassInclusionOwlNothing(superClass);
        this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{subClass, this.elkFactory_.getOwlNothing(), superClass});
        return null;
    }

    public Void visit(TopObjectPropertyInBottomEntailsOntologyInconsistency entailmentInference) {
        SubPropertyChain conclusion = (SubPropertyChain)entailmentInference.getReason();
        Matcher matcher = new Matcher(this.reasoner_.getProof(), this.elkFactory_, this.inferenceFactory_);
        matcher.trace(conclusion, (ElkSubObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty(), (ElkSubObjectPropertyExpression)this.elkFactory_.getOwlBottomObjectProperty());
        this.inferenceFactory_.getElkClassInclusionOwlTopObjectProperty();
        this.inferenceFactory_.getElkClassInclusionExistentialOfObjectHasSelf((ElkClassExpression)this.elkFactory_.getOwlThing(), (ElkObjectPropertyExpression)this.elkFactory_.getOwlTopObjectProperty());
        this.inferenceFactory_.getElkClassInclusionExistentialComposition(Arrays.asList(this.elkFactory_.getOwlThing(), this.elkFactory_.getOwlThing()), Arrays.asList(this.elkFactory_.getOwlTopObjectProperty()), (ElkObjectPropertyExpression)this.elkFactory_.getOwlBottomObjectProperty());
        this.inferenceFactory_.getElkClassInclusionOwlBottomObjectProperty();
        this.inferenceFactory_.getElkClassInclusionHierarchy(new ElkClassExpression[]{this.elkFactory_.getOwlThing(), this.elkFactory_.getObjectSomeValuesFrom((ElkObjectPropertyExpression)this.elkFactory_.getOwlBottomObjectProperty(), (ElkClassExpression)this.elkFactory_.getOwlThing()), this.elkFactory_.getOwlNothing()});
        return null;
    }

    public static class TunnelingException
    extends RuntimeException {
        private static final long serialVersionUID = -4095792570657375629L;
        private final ElkException elkException_;

        public TunnelingException(ElkException cause) {
            super((Throwable)cause);
            this.elkException_ = cause;
        }

        public ElkException getElkException() {
            return this.elkException_;
        }
    }
}

