/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentObjectPropertiesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;

public class ElkPropertyInclusionOfEquivalence
extends AbstractElkInference {
    public static final String NAME = "Equivalent Properties Decomposition";
    private final List<? extends ElkObjectPropertyExpression> expressions_;
    private final int subPos_;
    private final int superPos_;

    ElkPropertyInclusionOfEquivalence(List<? extends ElkObjectPropertyExpression> expressions, int subPos, int superPos) {
        this.expressions_ = expressions;
        this.subPos_ = subPos;
        this.superPos_ = superPos;
    }

    ElkPropertyInclusionOfEquivalence(ElkObjectPropertyExpression first, ElkObjectPropertyExpression second, boolean sameOrder) {
        ArrayList<? extends ElkObjectPropertyExpression> expressions = new ArrayList<ElkObjectPropertyExpression>(2);
        expressions.add(first);
        expressions.add(second);
        this.expressions_ = expressions;
        if (sameOrder) {
            this.subPos_ = 0;
            this.superPos_ = 1;
        } else {
            this.subPos_ = 1;
            this.superPos_ = 0;
        }
    }

    public List<? extends ElkObjectPropertyExpression> getExpressions() {
        return this.expressions_;
    }

    public int getSubPos() {
        return this.subPos_;
    }

    public int getSuperPos() {
        return this.superPos_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 1;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        if (index == 0) {
            return this.getPremise(factory);
        }
        return (ElkAxiom)ElkPropertyInclusionOfEquivalence.failGetPremise(index);
    }

    public ElkEquivalentObjectPropertiesAxiom getPremise(ElkObject.Factory factory) {
        return factory.getEquivalentObjectPropertiesAxiom(this.expressions_);
    }

    public ElkSubObjectPropertyOfAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)this.expressions_.get(this.subPos_), this.expressions_.get(this.superPos_));
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkPropertyInclusionOfEquivalence var1);
    }

    public static interface Factory {
        public ElkPropertyInclusionOfEquivalence getElkPropertyInclusionOfEquivalence(List<? extends ElkObjectPropertyExpression> var1, int var2, int var3);

        public ElkPropertyInclusionOfEquivalence getElkPropertyInclusionOfEquivalence(ElkObjectPropertyExpression var1, ElkObjectPropertyExpression var2, boolean var3);
    }
}

