/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyRangeAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyOfAxiom;

public class ElkPropertyRangePropertyExpansion
extends AbstractElkInference {
    public static final String NAME = "Property Range Expansion";
    private final ElkObjectPropertyExpression subProperty_;
    private final ElkObjectPropertyExpression superProperty_;
    private final ElkClassExpression range_;

    ElkPropertyRangePropertyExpansion(ElkObjectPropertyExpression subProperty, ElkObjectPropertyExpression superProperty, ElkClassExpression range) {
        this.superProperty_ = superProperty;
        this.range_ = range;
        this.subProperty_ = subProperty;
    }

    public ElkObjectPropertyExpression getSubProperty() {
        return this.subProperty_;
    }

    public ElkObjectPropertyExpression getSuperProperty() {
        return this.superProperty_;
    }

    public ElkClassExpression getRange() {
        return this.range_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 2;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        switch (index) {
            case 0: {
                return this.getFirstPremise(factory);
            }
            case 1: {
                return this.getSecondPremise(factory);
            }
        }
        return (ElkAxiom)ElkPropertyRangePropertyExpansion.failGetPremise(index);
    }

    public ElkSubObjectPropertyOfAxiom getFirstPremise(ElkObject.Factory factory) {
        return factory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)this.subProperty_, this.superProperty_);
    }

    public ElkObjectPropertyRangeAxiom getSecondPremise(ElkObject.Factory factory) {
        return factory.getObjectPropertyRangeAxiom(this.superProperty_, this.range_);
    }

    public ElkObjectPropertyRangeAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getObjectPropertyRangeAxiom(this.subProperty_, this.range_);
    }

    public <O> O accept(Visitor<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkPropertyRangePropertyExpansion var1);
    }

    public static interface Factory {
        public ElkPropertyRangePropertyExpansion getElkPropertyRangePropertyExpansion(ElkObjectPropertyExpression var1, ElkObjectPropertyExpression var2, ElkClassExpression var3);
    }
}

