/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.elk.owl.inferences.AbstractElkInference;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectOneOf;
import org.semanticweb.elk.owl.interfaces.ElkSameIndividualAxiom;

public class ElkSameIndividualOfEquivalentClasses
extends AbstractElkInference {
    public static final String NAME = "Same Individual Introduction";
    private final List<? extends ElkIndividual> same_;

    ElkSameIndividualOfEquivalentClasses(List<? extends ElkIndividual> same) {
        this.same_ = same;
    }

    public List<? extends ElkIndividual> getSame() {
        return this.same_;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getPremiseCount() {
        return 1;
    }

    @Override
    public ElkAxiom getPremise(int index, ElkObject.Factory factory) {
        if (index == 0) {
            return this.getPremise(factory);
        }
        return (ElkAxiom)ElkSameIndividualOfEquivalentClasses.failGetPremise(index);
    }

    public ElkEquivalentClassesAxiom getPremise(ElkObject.Factory factory) {
        ArrayList<ElkObjectOneOf> equivalent = new ArrayList<ElkObjectOneOf>(this.same_.size());
        for (ElkIndividual elkIndividual : this.same_) {
            equivalent.add(factory.getObjectOneOf(Collections.singletonList(elkIndividual)));
        }
        return factory.getEquivalentClassesAxiom(equivalent);
    }

    public ElkSameIndividualAxiom getConclusion(ElkObject.Factory factory) {
        return factory.getSameIndividualAxiom(this.same_);
    }

    @Override
    public <O> O accept(ElkInference.Visitor<O> visitor) {
        return visitor.visit(this);
    }

    static interface Visitor<O> {
        public O visit(ElkSameIndividualOfEquivalentClasses var1);
    }

    public static interface Factory {
        public ElkSameIndividualOfEquivalentClasses getElkSameIndividualOfEquivalentClasses(List<? extends ElkIndividual> var1);
    }
}

