/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.owl.inferences;

import org.liveontologies.puli.ChronologicalProof;
import org.liveontologies.puli.DynamicProof;
import org.liveontologies.puli.Proof;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.owl.inferences.ElkInference;
import org.semanticweb.elk.owl.inferences.ElkInferenceOptimizedProducingFactory;
import org.semanticweb.elk.owl.inferences.ElkProofGenerator;
import org.semanticweb.elk.owl.inferences.ModifiableElkProof;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.entailments.model.EntailmentInference;
import org.semanticweb.elk.reasoner.query.VerifiableQueryResult;

public class ReasonerElkProof
extends ChronologicalProof<ElkInference>
implements ModifiableElkProof {
    private final Reasoner reasoner_;
    private final ElkInference.Factory inferenceFactory_;

    private ReasonerElkProof(Reasoner reasoner, ElkAxiom goal, ElkObject.Factory elkFactory) throws ElkException {
        this.reasoner_ = reasoner;
        this.inferenceFactory_ = new ElkInferenceOptimizedProducingFactory(this, elkFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicProof<ElkInference> create(Reasoner reasoner, ElkAxiom goal, ElkObject.Factory elkFactory) throws ElkException {
        ReasonerElkProof proof;
        ReasonerElkProof reasonerElkProof = proof = new ReasonerElkProof(reasoner, goal, elkFactory);
        synchronized (reasonerElkProof) {
            proof.generateInferences(goal);
        }
        return proof;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateInferences(ElkAxiom goal) throws ElkException {
        VerifiableQueryResult result = this.reasoner_.checkEntailment(goal);
        try {
            Proof evidence = result.getEvidence(false);
            new ElkProofGenerator((Proof<? extends EntailmentInference>)evidence, this.reasoner_, this.inferenceFactory_).generate(result.getEntailment());
        }
        finally {
            result.unlock();
        }
    }
}

