/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.owlapix.model;

import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChange;
import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChangeListener;
import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChangeProgressListener;
import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkEquivalentClassesAxiom;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyChain;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkObjectSomeValuesFrom;
import org.semanticweb.elk.owl.interfaces.ElkReflexiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubClassOfAxiom;
import org.semanticweb.elk.owl.interfaces.ElkSubObjectPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkTransitiveObjectPropertyAxiom;
import org.semanticweb.elk.owl.iris.ElkAbbreviatedIri;
import org.semanticweb.elk.owl.iris.ElkFullIri;
import org.semanticweb.elk.owl.iris.ElkIri;
import org.semanticweb.elk.owl.iris.ElkPrefix;
import org.semanticweb.elk.owl.iris.ElkPrefixImpl;
import org.semanticweb.elk.owl.managers.ElkObjectEntityRecyclingFactory;

public class OwlxOntology
implements OwlxOntologyManager {
    private ElkObjectEntityRecyclingFactory objectFactory;
    private ElkPrefixImpl prefix;
    private HashMap<String, ElkClass> elkClasses = new HashMap();
    private HashMap<String, ElkObjectProperty> elkObjectProperties = new HashMap();
    private HashSet<ElkAxiom> axioms = new HashSet();
    private HashSet<OwlxOntologyChangeListener> change_listeners = new HashSet();

    public ElkObject.Factory getObjectFactory() {
        return this.objectFactory;
    }

    public Set<ElkAxiom> getAxioms() {
        return this.axioms;
    }

    public boolean addAxiom(ElkAxiom axiom) {
        boolean ret = this.axioms.add(axiom);
        OwlxOntologyChange change = OwlxOntologyChange.createAdded(this, axiom);
        for (OwlxOntologyChangeListener listener : this.change_listeners) {
            try {
                listener.ontologiesChanged(List.of(change));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return ret;
    }

    public boolean removeAxiom(ElkAxiom axiom) {
        boolean ret = this.axioms.remove(axiom);
        OwlxOntologyChange change = OwlxOntologyChange.createRemoved(this, axiom);
        for (OwlxOntologyChangeListener listener : this.change_listeners) {
            try {
                listener.ontologiesChanged(List.of(change));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return ret;
    }

    public OwlxOntology() {
        this.objectFactory = new ElkObjectEntityRecyclingFactory();
        this.prefix = new ElkPrefixImpl(":", new ElkFullIri(""));
    }

    public ElkClass getOwlThing() {
        return this.objectFactory.getOwlThing();
    }

    public ElkClass getOwlNothing() {
        return this.objectFactory.getOwlNothing();
    }

    private ElkAbbreviatedIri getIri(String name) {
        return new ElkAbbreviatedIri((ElkPrefix)this.prefix, name);
    }

    public ElkClass getElkClass(String name) {
        return this.elkClasses.computeIfAbsent(name, k -> this.objectFactory.getClass((ElkIri)this.getIri(name)));
    }

    public ElkObjectProperty getElkObjectProperty(String name) {
        return this.elkObjectProperties.computeIfAbsent(name, key -> this.objectFactory.getObjectProperty((ElkIri)this.getIri(name)));
    }

    public ElkAxiom getElkSubObjectPropertyOfAxiom(String sub, String sup) {
        return this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)this.getElkObjectProperty(sub), (ElkObjectPropertyExpression)this.getElkObjectProperty(sup));
    }

    public ElkTransitiveObjectPropertyAxiom getElkTransitiveObjectPropertyAxiom(String name) {
        return this.objectFactory.getTransitiveObjectPropertyAxiom((ElkObjectPropertyExpression)this.getElkObjectProperty(name));
    }

    public ElkAxiom getElkSubObjectPropertyChainOfAxiom(String name, String chain) {
        ElkObjectPropertyChain ch = this.objectFactory.getObjectPropertyChain(List.of(this.getElkObjectProperty(name), this.getElkObjectProperty(chain)));
        return this.objectFactory.getSubObjectPropertyOfAxiom((ElkSubObjectPropertyExpression)ch, (ElkObjectPropertyExpression)this.getElkObjectProperty(name));
    }

    public ElkReflexiveObjectPropertyAxiom getElkReflexiveObjectPropertyAxiom(String name) {
        return this.objectFactory.getReflexiveObjectPropertyAxiom((ElkObjectPropertyExpression)this.getElkObjectProperty(name));
    }

    public ElkObjectSomeValuesFrom getElkObjectSomeValuesFrom(String prop, String filler) {
        return this.getElkObjectSomeValuesFrom(prop, (ElkClassExpression)this.getElkClass(filler));
    }

    public ElkObjectSomeValuesFrom getElkObjectSomeValuesFrom(String prop, ElkClassExpression expr) {
        return this.objectFactory.getObjectSomeValuesFrom((ElkObjectPropertyExpression)this.getElkObjectProperty(prop), expr);
    }

    public ElkEquivalentClassesAxiom getEquivalentClassesAxiom(String name, ElkClassExpression expr) {
        return this.objectFactory.getEquivalentClassesAxiom((ElkClassExpression)this.getElkClass(name), expr, new ElkClassExpression[0]);
    }

    public ElkSubClassOfAxiom getSubClassOfAxiom(String name, ElkClassExpression expr) {
        return this.objectFactory.getSubClassOfAxiom((ElkClassExpression)this.getElkClass(name), expr);
    }

    public ElkAxiom getSubClassOfAxiom(ElkClassExpression expr, String name) {
        return this.objectFactory.getSubClassOfAxiom(expr, (ElkClassExpression)this.getElkClass(name));
    }

    public OwlxOntologyManager getOWLOntologyManager() {
        return this;
    }

    public Set<OwlxOntology> getImportsClosure() {
        return Set.of(this);
    }

    @Override
    public void addOntologyChangeListener(OwlxOntologyChangeListener ontologyChangeListener_) {
        this.change_listeners.add(ontologyChangeListener_);
    }

    @Override
    public void addOntologyChangeProgessListener(OwlxOntologyChangeProgressListener ontologyChangeProgressListener_) {
    }

    @Override
    public void removeOntologyChangeListener(OwlxOntologyChangeListener ontologyChangeListener_) {
        this.change_listeners.remove(ontologyChangeListener_);
    }

    @Override
    public void removeOntologyChangeProgessListener(OwlxOntologyChangeProgressListener ontologyChangeProgressListener_) {
    }
}

