/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.owlapix.model;

import dev.ikm.elk.snomed.owlapix.model.OwlxOntology;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;

public class OwlxOntologyChange
implements Serializable {
    private static final long serialVersionUID = 40000L;
    private final OwlxOntology ontology;
    private ElkAxiom addedAxiom;
    private ElkAxiom removedAxiom;

    private OwlxOntologyChange(OwlxOntology ontology) {
        Objects.requireNonNull(ontology);
        this.ontology = ontology;
    }

    public static OwlxOntologyChange createAdded(OwlxOntology ont, ElkAxiom axiom) {
        OwlxOntologyChange change = new OwlxOntologyChange(ont);
        Objects.requireNonNull(axiom);
        change.addedAxiom = axiom;
        return change;
    }

    public static OwlxOntologyChange createRemoved(OwlxOntology ont, ElkAxiom axiom) {
        OwlxOntologyChange change = new OwlxOntologyChange(ont);
        Objects.requireNonNull(axiom);
        change.removedAxiom = axiom;
        return change;
    }

    public Optional<ElkAxiom> getAddedAxiom() {
        return Optional.ofNullable(this.addedAxiom);
    }

    public Optional<ElkAxiom> getRemovedAxiom() {
        return Optional.ofNullable(this.removedAxiom);
    }

    public boolean isAxiomChange() {
        return true;
    }

    public boolean isAddAxiom() {
        return this.addedAxiom != null;
    }

    public boolean isRemoveAxiom() {
        return this.removedAxiom != null;
    }

    public ElkAxiom getAxiom() {
        if (this.addedAxiom != null) {
            return this.addedAxiom;
        }
        if (this.removedAxiom != null) {
            return this.removedAxiom;
        }
        throw new IllegalStateException();
    }

    public OwlxOntology getOntology() {
        return this.ontology;
    }
}

