/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.reasoner;

import dev.ikm.elk.snomed.owlapix.model.OwlxOntology;
import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChange;
import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChangeListener;
import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChangeProgressListener;
import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyManager;
import dev.ikm.elk.snomed.owlapix.reasoner.AxiomNotInProfileException;
import dev.ikm.elk.snomed.owlapix.reasoner.BufferingMode;
import dev.ikm.elk.snomed.owlapix.reasoner.ClassExpressionNotInProfileException;
import dev.ikm.elk.snomed.owlapix.reasoner.FreshEntitiesException;
import dev.ikm.elk.snomed.owlapix.reasoner.FreshEntityPolicy;
import dev.ikm.elk.snomed.owlapix.reasoner.InconsistentOntologyException;
import dev.ikm.elk.snomed.owlapix.reasoner.IndividualNodeSetPolicy;
import dev.ikm.elk.snomed.owlapix.reasoner.InferenceType;
import dev.ikm.elk.snomed.owlapix.reasoner.ReasonerInternalException;
import dev.ikm.elk.snomed.owlapix.reasoner.ReasonerInterruptedException;
import dev.ikm.elk.snomed.owlapix.reasoner.TimeOutException;
import dev.ikm.elk.snomed.owlapix.reasoner.UnsupportedEntailmentTypeException;
import dev.ikm.elk.snomed.reasoner.ElkConverter;
import dev.ikm.elk.snomed.reasoner.ElkReasonerConfiguration;
import dev.ikm.elk.snomed.reasoner.ElkReasonerProgressMonitor;
import dev.ikm.elk.snomed.reasoner.OwlChangesLoaderFactory;
import dev.ikm.elk.snomed.reasoner.OwlOntologyLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.elk.exceptions.ElkException;
import org.semanticweb.elk.exceptions.ElkRuntimeException;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.interfaces.ElkClass;
import org.semanticweb.elk.owl.interfaces.ElkClassExpression;
import org.semanticweb.elk.owl.interfaces.ElkDataProperty;
import org.semanticweb.elk.owl.interfaces.ElkDataPropertyExpression;
import org.semanticweb.elk.owl.interfaces.ElkLiteral;
import org.semanticweb.elk.owl.interfaces.ElkNamedIndividual;
import org.semanticweb.elk.owl.interfaces.ElkObject;
import org.semanticweb.elk.owl.interfaces.ElkObjectProperty;
import org.semanticweb.elk.owl.interfaces.ElkObjectPropertyExpression;
import org.semanticweb.elk.reasoner.DummyProgressMonitor;
import org.semanticweb.elk.reasoner.ElkUnsupportedReasoningTaskException;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.reasoner.Reasoner;
import org.semanticweb.elk.reasoner.ReasonerFactory;
import org.semanticweb.elk.reasoner.completeness.IncompleteResult;
import org.semanticweb.elk.reasoner.completeness.Incompleteness;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;
import org.semanticweb.elk.reasoner.query.EntailmentQueryConverter;
import org.semanticweb.elk.reasoner.query.QueryResult;
import org.semanticweb.elk.reasoner.query.VerifiableQueryResult;
import org.semanticweb.elk.reasoner.stages.ElkInterruptedException;
import org.semanticweb.elk.reasoner.taxonomy.model.Node;
import org.semanticweb.elk.reasoner.taxonomy.model.TaxonomyNode;
import org.semanticweb.elk.util.logging.LogLevel;
import org.semanticweb.elk.util.logging.LoggerWrap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class ElkReasoner {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ElkReasoner.class);
    private static final Marker MARKER_UNSUPPORTED_METHOD_ = MarkerFactory.getMarker((String)"owlapi.unsupportedMethod");
    private final OwlxOntology owlOntology_;
    private final OwlxOntologyManager owlOntologymanager_;
    private final ProgressMonitor mainProgressMonitor_;
    private final ProgressMonitor secondaryProgressMonitor_;
    private final boolean isBufferingMode_;
    private final OntologyChangeListener ontologyChangeListener_;
    private final OntologyChangeProgressListener ontologyChangeProgressListener_;
    private final ElkObject.Factory objectFactory_;
    private final ElkConverter elkConverter_;
    private volatile OwlChangesLoaderFactory bufferedChangesLoader_;
    private ReasonerConfiguration config_;
    private final boolean isAllowFreshEntities;
    private Reasoner reasoner_;
    private final List<ChangeListener> changeListeners_ = new ArrayList<ChangeListener>();
    private boolean loadBeforeChanges_ = true;
    private boolean ontologyReloadRequired_;

    ElkReasoner(OwlxOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig, Reasoner internalReasoner) {
        this.owlOntology_ = ontology;
        this.owlOntologymanager_ = ontology.getOWLOntologyManager();
        this.mainProgressMonitor_ = elkConfig.getProgressMonitor() == null ? new DummyProgressMonitor() : new ElkReasonerProgressMonitor(elkConfig.getProgressMonitor());
        this.secondaryProgressMonitor_ = new DummyProgressMonitor();
        this.isBufferingMode_ = isBufferingMode;
        this.ontologyChangeListener_ = new OntologyChangeListener();
        this.owlOntologymanager_.addOntologyChangeListener(this.ontologyChangeListener_);
        this.ontologyChangeProgressListener_ = new OntologyChangeProgressListener();
        this.owlOntologymanager_.addOntologyChangeProgessListener(this.ontologyChangeProgressListener_);
        this.objectFactory_ = internalReasoner.getElkFactory();
        this.elkConverter_ = ElkConverter.getInstance();
        this.config_ = elkConfig.getElkConfiguration();
        this.isAllowFreshEntities = elkConfig.getFreshEntityPolicy() == FreshEntityPolicy.ALLOW;
        this.initReasoner(internalReasoner);
        this.bufferedChangesLoader_ = new OwlChangesLoaderFactory(this.mainProgressMonitor_);
        if (!this.isBufferingMode_) {
            this.reasoner_.registerAxiomLoader((AxiomLoader.Factory)this.bufferedChangesLoader_);
        }
        this.ontologyReloadRequired_ = false;
    }

    ElkReasoner(OwlxOntology ontology, boolean isBufferingMode, ElkReasonerConfiguration elkConfig) {
        this(ontology, isBufferingMode, elkConfig, new ReasonerFactory().createReasoner(ontology.getObjectFactory(), elkConfig.getElkConfiguration()));
    }

    OwlxOntology getOWLOntology() {
        return this.owlOntology_;
    }

    ElkObject.Factory getElkObjectFactory() {
        return this.objectFactory_;
    }

    private void initReasoner(Reasoner reasoner) {
        this.reasoner_ = reasoner;
        this.reasoner_.registerAxiomLoader((AxiomLoader.Factory)new OwlOntologyLoader.Factory(this.owlOntology_, this.mainProgressMonitor_));
        this.reasoner_.setAllowFreshEntities(this.isAllowFreshEntities);
        this.reasoner_.setProgressMonitor(this.secondaryProgressMonitor_);
    }

    public Reasoner getInternalReasoner() {
        return this.reasoner_;
    }

    public ReasonerConfiguration getConfigurationOptions() {
        return this.config_;
    }

    public void setConfigurationOptions(ReasonerConfiguration config) {
        this.config_ = config;
        this.reasoner_.setConfigurationOptions(config);
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method) {
        String message = "OWL API reasoner method is not implemented: " + method + ".";
        LoggerWrap.log((Logger)LOGGER_, (LogLevel)LogLevel.WARN, (Marker)MARKER_UNSUPPORTED_METHOD_, (String)message);
        return new UnsupportedOperationException(message);
    }

    private static UnsupportedOperationException unsupportedOwlApiMethod(String method, String reason) {
        String message = "OWL API reasoner method is not fully implemented: " + method + ": " + reason;
        LoggerWrap.log((Logger)LOGGER_, (LogLevel)LogLevel.WARN, (Marker)MARKER_UNSUPPORTED_METHOD_, (String)message);
        return new UnsupportedOperationException(message);
    }

    private IncompleteResult<? extends Node<ElkClass>> getClassNode(ElkClass elkClass) throws FreshEntitiesException, InconsistentOntologyException, ElkException {
        try {
            return this.reasoner_.getEquivalentClasses((ElkClassExpression)elkClass);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    private IncompleteResult<? extends TaxonomyNode<ElkObjectProperty>> getObjectPropertyNode(ElkObjectProperty elkClass) throws FreshEntitiesException, InconsistentOntologyException, ElkException {
        try {
            return this.reasoner_.getObjectPropertyNode(elkClass);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    private void checkInterrupted() throws ReasonerInterruptedException {
        try {
            this.reasoner_.checkInterrupt();
        }
        catch (ElkInterruptedException e) {
            throw new ReasonerInterruptedException(e);
        }
    }

    public void dispose() {
        LOGGER_.trace("dispose()");
        this.owlOntologymanager_.removeOntologyChangeListener(this.ontologyChangeListener_);
        this.owlOntologymanager_.removeOntologyChangeProgessListener(this.ontologyChangeProgressListener_);
        try {
            while (true) {
                try {
                    if (!this.reasoner_.shutdown()) {
                        throw new ReasonerInternalException("Failed to shut down ELK!");
                    }
                }
                catch (InterruptedException e) {
                    continue;
                }
                break;
            }
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public void flush() {
        LOGGER_.trace("flush()");
        try {
            if (this.ontologyReloadRequired_) {
                this.initReasoner(new ReasonerFactory().createReasoner(this.reasoner_, this.objectFactory_, this.config_));
                this.bufferedChangesLoader_ = new OwlChangesLoaderFactory(this.secondaryProgressMonitor_);
                this.ontologyReloadRequired_ = false;
            } else {
                if (this.bufferedChangesLoader_.isLoadingFinished()) {
                    return;
                }
                if (this.isBufferingMode_) {
                    this.reasoner_.registerAxiomLoader((AxiomLoader.Factory)this.bufferedChangesLoader_);
                    this.bufferedChangesLoader_ = new OwlChangesLoaderFactory(this.secondaryProgressMonitor_);
                }
            }
            for (ChangeListener listener : this.changeListeners_) {
                listener.ontologyChanged();
            }
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public IncompleteResult<? extends Node<ElkClass>> computeBottomClassNode() {
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<ElkClass> getBottomClassNode() {
        LOGGER_.trace("getBottomClassNode()");
        this.checkInterrupted();
        try {
            return (Node)Incompleteness.getValue(this.computeBottomClassNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getBottomClassNode()", e.getMessage());
        }
    }

    public Node<ElkDataProperty> getBottomDataPropertyNode() {
        LOGGER_.trace("getBottomDataPropertyNode()");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getBottomDataPropertyNode()");
    }

    public IncompleteResult<? extends TaxonomyNode<ElkObjectProperty>> computeBottomObjectPropertyNode() {
        this.checkInterrupted();
        try {
            return this.getObjectPropertyNode(this.objectFactory_.getOwlBottomObjectProperty());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public TaxonomyNode<ElkObjectProperty> getBottomObjectPropertyNode() {
        LOGGER_.trace("getBottomObjectPropertyNode()");
        try {
            return (TaxonomyNode)Incompleteness.getValue(this.computeBottomObjectPropertyNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getBottomObjectPropertyNode()", e.getMessage());
        }
    }

    public BufferingMode getBufferingMode() {
        LOGGER_.trace("getBufferingMode()");
        return this.isBufferingMode_ ? BufferingMode.BUFFERING : BufferingMode.NON_BUFFERING;
    }

    public Set<ElkClass> getDataPropertyDomains(ElkDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDataPropertyDomains(ElkDataProperty, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyDomains(ElkDataProperty, boolean)");
    }

    public Set<ElkLiteral> getDataPropertyValues(ElkNamedIndividual arg0, ElkDataProperty arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDataPropertyValues(ElkNamedIndividual, ElkDataProperty)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDataPropertyValues(ElkNamedIndividual, ElkDataProperty)");
    }

    public Set<ElkNamedIndividual> getDifferentIndividuals(ElkNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDifferentIndividuals(ElkNamedIndividual)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDifferentIndividuals(ElkNamedIndividual)");
    }

    public Set<ElkClass> getDisjointClasses(ElkClassExpression arg0) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("getDisjointClasses(ElkClassExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointClasses(ElkClassExpression)");
    }

    public Set<ElkDataProperty> getDisjointDataProperties(ElkDataPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDisjointDataProperties(ElkDataPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointDataProperties(ElkDataPropertyExpression)");
    }

    public Set<ElkObjectPropertyExpression> getDisjointObjectProperties(ElkObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getDisjointObjectProperties(ElkObjectPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getDisjointObjectProperties(ElkObjectPropertyExpression)");
    }

    public IncompleteResult<? extends Node<ElkClass>> computeEquivalentClasses(ElkClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getEquivalentClasses(ce);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<ElkClass> getEquivalentClasses(ElkClassExpression ce) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentClasses(ElkClassExpression)");
        try {
            return (Node)Incompleteness.getValue(this.computeEquivalentClasses(ce));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentClasses(ElkClassExpression)", e.getMessage());
        }
    }

    public Node<ElkDataProperty> getEquivalentDataProperties(ElkDataProperty arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentDataProperties(ElkDataProperty)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentDataProperties(ElkDataProperty)");
    }

    public IncompleteResult<? extends TaxonomyNode<ElkObjectProperty>> computeEquivalentObjectProperties(ElkObjectProperty pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentObjectProperties(ElkObjectPropertyExpression)");
        this.checkInterrupted();
        try {
            return this.reasoner_.getObjectPropertyNode(pe);
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(ElkObjectPropertyExpression)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public TaxonomyNode<ElkObjectProperty> getEquivalentObjectProperties(ElkObjectPropertyExpression pe) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getEquivalentObjectProperties(ElkObjectPropertyExpression)");
        if (pe instanceof ElkObjectProperty) {
            try {
                return (TaxonomyNode)Incompleteness.getValue(this.computeEquivalentObjectProperties((ElkObjectProperty)pe));
            }
            catch (ElkUnsupportedReasoningTaskException e) {
                throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(ElkObjectPropertyExpression)", e.getMessage());
            }
        }
        throw ElkReasoner.unsupportedOwlApiMethod("getEquivalentObjectProperties(ElkObjectPropertyExpression)");
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        LOGGER_.trace("getFreshEntityPolicy()");
        return this.reasoner_.getAllowFreshEntities() ? FreshEntityPolicy.ALLOW : FreshEntityPolicy.DISALLOW;
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        LOGGER_.trace("getIndividualNodeSetPolicy()");
        return IndividualNodeSetPolicy.BY_NAME;
    }

    public IncompleteResult<? extends Set<? extends Node<ElkNamedIndividual>>> computeInstances(ElkClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getInstances(ce, direct);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Set<? extends Node<ElkNamedIndividual>> getInstances(ElkClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getInstances(ElkClassExpression, boolean)");
        this.checkInterrupted();
        try {
            return (Set)Incompleteness.getValue(this.computeInstances(ce, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getInstances(ElkClassExpression, boolean)", e.getMessage());
        }
    }

    public Node<ElkObjectPropertyExpression> getInverseObjectProperties(ElkObjectPropertyExpression arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getInverseObjectProperties(ElkObjectPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getInverseObjectProperties(ElkObjectPropertyExpression)");
    }

    public Set<ElkClass> getObjectPropertyDomains(ElkObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getObjectPropertyDomains(ElkObjectPropertyExpression, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyDomains(ElkObjectPropertyExpression, boolean)");
    }

    public Set<ElkClass> getObjectPropertyRanges(ElkObjectPropertyExpression arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getObjectPropertyRanges(ElkObjectPropertyExpression, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyRanges(ElkObjectPropertyExpression, boolean)");
    }

    public Set<ElkNamedIndividual> getObjectPropertyValues(ElkNamedIndividual arg0, ElkObjectPropertyExpression arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getObjectPropertyValues(ElkNamedIndividual, ElkObjectPropertyExpression)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getObjectPropertyValues(ElkNamedIndividual, ElkObjectPropertyExpression)");
    }

    public Set<ElkAxiom> getPendingAxiomAdditions() {
        LOGGER_.trace("getPendingAxiomAdditions()");
        return this.bufferedChangesLoader_.getPendingAxiomAdditions();
    }

    public Set<ElkAxiom> getPendingAxiomRemovals() {
        LOGGER_.trace("getPendingAxiomRemovals()");
        return this.bufferedChangesLoader_.getPendingAxiomRemovals();
    }

    public List<OwlxOntologyChange> getPendingChanges() {
        LOGGER_.trace("getPendingChanges()");
        return this.bufferedChangesLoader_.getPendingChanges();
    }

    public Set<InferenceType> getPrecomputableInferenceTypes() {
        LOGGER_.trace("getPrecomputableInferenceTypes()");
        return new HashSet<InferenceType>(Arrays.asList(InferenceType.CLASS_ASSERTIONS, InferenceType.CLASS_HIERARCHY, InferenceType.OBJECT_PROPERTY_HIERARCHY));
    }

    public String getReasonerName() {
        LOGGER_.trace("getReasonerName()");
        return ElkReasoner.class.getPackage().getImplementationTitle();
    }

    public String getReasonerVersion() {
        LOGGER_.trace("getReasonerVersion()");
        String versionString = ElkReasoner.class.getPackage().getImplementationVersion();
        return versionString;
    }

    public OwlxOntology getRootOntology() {
        LOGGER_.trace("getRootOntology()");
        return this.owlOntology_;
    }

    public ElkNamedIndividual getSameIndividuals(ElkNamedIndividual arg0) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSameIndividuals(ElkNamedIndividual)");
        this.checkInterrupted();
        return arg0;
    }

    public IncompleteResult<? extends Set<? extends Node<ElkClass>>> computeSubClasses(ElkClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSubClasses(ce, direct);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Set<? extends Node<ElkClass>> getSubClasses(ElkClassExpression ce, boolean direct) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException, ClassExpressionNotInProfileException {
        LOGGER_.trace("getSubClasses(ElkClassExpression, boolean)");
        try {
            return (Set)Incompleteness.getValue(this.computeSubClasses(ce, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSubClasses(ElkClassExpression, boolean)", e.getMessage());
        }
    }

    public Set<ElkDataProperty> getSubDataProperties(ElkDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSubDataProperties(ElkDataProperty, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSubDataProperties(ElkDataProperty, boolean)");
    }

    public IncompleteResult<? extends Set<? extends Node<ElkObjectProperty>>> computeSubObjectProperties(ElkObjectProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSubObjectProperties(pe, direct);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Set<? extends Node<ElkObjectProperty>> getSubObjectProperties(ElkObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSubObjectProperties(ElkObjectPropertyExpression, boolean)");
        if (pe instanceof ElkObjectProperty) {
            try {
                return (Set)Incompleteness.getValue(this.computeSubObjectProperties((ElkObjectProperty)pe, direct));
            }
            catch (ElkUnsupportedReasoningTaskException e) {
                throw ElkReasoner.unsupportedOwlApiMethod("getSubObjectProperties(ElkObjectPropertyExpression, boolean)", e.getMessage());
            }
        }
        throw ElkReasoner.unsupportedOwlApiMethod("getSubObjectProperties(ElkObjectPropertyExpression, boolean)");
    }

    public IncompleteResult<? extends Set<? extends Node<ElkClass>>> computeSuperClasses(ElkClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSuperClasses(ce, direct);
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperClasses(ElkClassExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Set<? extends Node<ElkClass>> getSuperClasses(ElkClassExpression ce, boolean direct) throws InconsistentOntologyException, ClassExpressionNotInProfileException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSuperClasses(ElkClassExpression, boolean)");
        try {
            return (Set)Incompleteness.getValue(this.computeSuperClasses(ce, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperClasses(ElkClassExpression, boolean)", e.getMessage());
        }
    }

    public Set<ElkDataProperty> getSuperDataProperties(ElkDataProperty arg0, boolean arg1) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSuperDataProperties(ElkDataProperty, boolean)");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperDataProperties(ElkDataProperty, boolean)");
    }

    public IncompleteResult<? extends Set<? extends Node<ElkObjectProperty>>> computeSuperObjectProperties(ElkObjectProperty pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getSuperObjectProperties(pe, direct);
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(ElkObjectPropertyExpression, boolean)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Set<? extends Node<ElkObjectProperty>> getSuperObjectProperties(ElkObjectPropertyExpression pe, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getSuperObjectProperties(ElkObjectPropertyExpression, boolean)");
        if (pe instanceof ElkObjectProperty) {
            try {
                return (Set)Incompleteness.getValue(this.computeSuperObjectProperties((ElkObjectProperty)pe, direct));
            }
            catch (ElkUnsupportedReasoningTaskException e) {
                throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(ElkObjectPropertyExpression, boolean)", e.getMessage());
            }
        }
        throw ElkReasoner.unsupportedOwlApiMethod("getSuperObjectProperties(ElkObjectPropertyExpression, boolean)");
    }

    public long getTimeOut() {
        LOGGER_.trace("getTimeOut()");
        return 0L;
    }

    public IncompleteResult<? extends Node<ElkClass>> computeTopClassNode() {
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlThing());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<ElkClass> getTopClassNode() {
        LOGGER_.trace("getTopClassNode()");
        this.checkInterrupted();
        try {
            return (Node)Incompleteness.getValue(this.computeTopClassNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTopClassNode()", e.getMessage());
        }
    }

    public Node<ElkDataProperty> getTopDataPropertyNode() {
        LOGGER_.trace("getTopDataPropertyNode()");
        this.checkInterrupted();
        throw ElkReasoner.unsupportedOwlApiMethod("getTopDataPropertyNode()");
    }

    public IncompleteResult<? extends TaxonomyNode<ElkObjectProperty>> computeTopObjectPropertyNode() {
        this.checkInterrupted();
        try {
            return this.getObjectPropertyNode(this.objectFactory_.getOwlTopObjectProperty());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public TaxonomyNode<ElkObjectProperty> getTopObjectPropertyNode() {
        LOGGER_.trace("getTopObjectPropertyNode()");
        try {
            return (TaxonomyNode)Incompleteness.getValue(this.computeTopObjectPropertyNode());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTopObjectPropertyNode()", e.getMessage());
        }
    }

    public IncompleteResult<? extends Set<? extends Node<ElkClass>>> computeTypes(ElkNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        this.checkInterrupted();
        try {
            return this.reasoner_.getTypes(ind, direct);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Set<? extends Node<ElkClass>> getTypes(ElkNamedIndividual ind, boolean direct) throws InconsistentOntologyException, FreshEntitiesException, ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("getTypes(ElkNamedIndividual, boolean)");
        try {
            return (Set)Incompleteness.getValue(this.computeTypes(ind, direct));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getTypes(ElkNamedIndividual, boolean)", e.getMessage());
        }
    }

    public IncompleteResult<? extends Node<ElkClass>> computeUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        this.checkInterrupted();
        try {
            return this.getClassNode(this.objectFactory_.getOwlNothing());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public Node<ElkClass> getUnsatisfiableClasses() throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        LOGGER_.trace("getUnsatisfiableClasses()");
        this.checkInterrupted();
        try {
            return (Node)Incompleteness.getValue(this.computeUnsatisfiableClasses());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("getUnsatisfiableClasses()", e.getMessage());
        }
    }

    public void interrupt() {
        LOGGER_.trace("interrupt()");
        this.reasoner_.interrupt();
    }

    public IncompleteResult<Boolean> checkIsConsistent() {
        try {
            return this.reasoner_.isInconsistent().map(res -> res == false);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isConsistent() throws ReasonerInterruptedException, TimeOutException {
        LOGGER_.trace("isConsistent()");
        try {
            return (Boolean)Incompleteness.getValue(this.checkIsConsistent());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isConsistent()", e.getMessage());
        }
    }

    public IncompleteResult<Boolean> checkEntailment(ElkAxiom elkAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        try {
            VerifiableQueryResult entailment = this.reasoner_.checkEntailment(elkAxiom);
            return new IncompleteResult((Object)entailment.entailmentProved(), entailment.getIncompletenessMonitor());
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(ElkAxiom)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isEntailed(ElkAxiom owlAxiom) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("isEntailed(ElkAxiom)");
        this.checkInterrupted();
        return (Boolean)Incompleteness.getValue(this.checkEntailment(owlAxiom));
    }

    public boolean isEntailed(Set<? extends ElkAxiom> owlAxioms) throws ReasonerInterruptedException, UnsupportedEntailmentTypeException, TimeOutException, AxiomNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("isEntailed(Set<? extends ElkAxiom>)");
        this.checkInterrupted();
        try {
            Map results = this.reasoner_.checkEntailment(owlAxioms);
            for (VerifiableQueryResult result : results.values()) {
                if (Incompleteness.getValue((QueryResult)result)) continue;
                return false;
            }
            return true;
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isEntailed(Set<? extends ElkAxiom>)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isEntailmentCheckingSupported(Class<? extends ElkObject> elkAxiomClass) {
        if (elkAxiomClass == null || !ElkAxiom.class.isAssignableFrom(elkAxiomClass)) {
            return false;
        }
        return EntailmentQueryConverter.isEntailmentCheckingSupported(elkAxiomClass.asSubclass(ElkAxiom.class));
    }

    public boolean isPrecomputed(InferenceType inferenceType) {
        LOGGER_.trace("isPrecomputed(InferenceType)");
        if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
            return this.reasoner_.doneTaxonomy();
        }
        if (inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) {
            return this.reasoner_.doneInstanceTaxonomy();
        }
        if (inferenceType.equals((Object)InferenceType.OBJECT_PROPERTY_HIERARCHY)) {
            return this.reasoner_.doneObjectPropertyTaxonomy();
        }
        return false;
    }

    public IncompleteResult<? extends Boolean> checkSatisfiability(ElkClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        this.checkInterrupted();
        try {
            return this.reasoner_.isSatisfiable(classExpression);
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
    }

    public boolean isSatisfiable(ElkClassExpression classExpression) throws ReasonerInterruptedException, TimeOutException, ClassExpressionNotInProfileException, FreshEntitiesException, InconsistentOntologyException {
        LOGGER_.trace("isSatisfiable(ElkClassExpression)");
        try {
            return (Boolean)Incompleteness.getValue(this.checkSatisfiability(classExpression));
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("isSatisfiable(classExpression)", e.getMessage());
        }
    }

    public void precomputeInferences(InferenceType ... inferenceTypes) throws ReasonerInterruptedException, TimeOutException, InconsistentOntologyException {
        LOGGER_.trace("precomputeInferences(InferenceType...)");
        this.checkInterrupted();
        this.reasoner_.setProgressMonitor(this.mainProgressMonitor_);
        try {
            for (InferenceType inferenceType : inferenceTypes) {
                if (inferenceType.equals((Object)InferenceType.CLASS_HIERARCHY)) {
                    this.reasoner_.getTaxonomy();
                    continue;
                }
                if (inferenceType.equals((Object)InferenceType.CLASS_ASSERTIONS)) {
                    this.reasoner_.getInstanceTaxonomy();
                    continue;
                }
                if (!inferenceType.equals((Object)InferenceType.OBJECT_PROPERTY_HIERARCHY)) continue;
                this.reasoner_.getObjectPropertyTaxonomy();
            }
        }
        catch (ElkUnsupportedReasoningTaskException e) {
            throw ElkReasoner.unsupportedOwlApiMethod("precomputeInferences(inferenceTypes)", e.getMessage());
        }
        catch (ElkException e) {
            throw this.elkConverter_.convert(e);
        }
        catch (ElkRuntimeException e) {
            throw this.elkConverter_.convert(e);
        }
        finally {
            this.reasoner_.setProgressMonitor(this.secondaryProgressMonitor_);
        }
    }

    public void addListener(ChangeListener listener) {
        this.changeListeners_.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.changeListeners_.remove(listener);
    }

    protected class OntologyChangeListener
    implements OwlxOntologyChangeListener {
        protected OntologyChangeListener() {
        }

        @Override
        public void ontologiesChanged(List<? extends OwlxOntologyChange> changes) {
            Set<OwlxOntology> importClosure = null;
            for (OwlxOntologyChange owlxOntologyChange : changes) {
                OwlxOntology changedOntology = owlxOntologyChange.getOntology();
                if (!changedOntology.equals(ElkReasoner.this.owlOntology_)) {
                    if (importClosure == null) {
                        importClosure = ElkReasoner.this.owlOntology_.getImportsClosure();
                    }
                    if (!importClosure.contains(changedOntology)) {
                        LOGGER_.trace("Ignoring the change not applicable to the current ontology: {}" + String.valueOf(owlxOntologyChange));
                        continue;
                    }
                }
                if (!owlxOntologyChange.isAxiomChange()) {
                    LOGGER_.trace("Non-axiom change: {}\n The ontology will be reloaded.", (Object)owlxOntologyChange);
                    ElkReasoner.this.ontologyReloadRequired_ = true;
                    continue;
                }
                ElkReasoner.this.bufferedChangesLoader_.registerChange(owlxOntologyChange);
            }
            if (!ElkReasoner.this.isBufferingMode_) {
                ElkReasoner.this.flush();
            }
        }
    }

    private class OntologyChangeProgressListener
    implements OwlxOntologyChangeProgressListener {
        private static final long serialVersionUID = -609834181047406971L;

        private OntologyChangeProgressListener() {
        }

        @Override
        public void begin(int size) {
            if (ElkReasoner.this.isBufferingMode_ && ElkReasoner.this.loadBeforeChanges_) {
                try {
                    LOGGER_.trace("force initial loading");
                    ElkReasoner.this.reasoner_.ensureLoading();
                    ElkReasoner.this.loadBeforeChanges_ = false;
                }
                catch (ElkException e) {
                    throw ElkReasoner.this.elkConverter_.convert(e);
                }
            }
        }

        @Override
        public void appliedChange(OwlxOntologyChange change) {
        }

        @Override
        public void end() {
        }
    }

    public static interface ChangeListener {
        public void ontologyChanged();
    }
}

