/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.reasoner;

import dev.ikm.elk.snomed.owlapix.reasoner.FreshEntityPolicy;
import dev.ikm.elk.snomed.owlapix.reasoner.IndividualNodeSetPolicy;
import dev.ikm.elk.snomed.owlapix.reasoner.NullReasonerProgressMonitor;
import dev.ikm.elk.snomed.owlapix.reasoner.OwlReasonerConfiguration;
import dev.ikm.elk.snomed.owlapix.reasoner.ReasonerProgressMonitor;
import dev.ikm.elk.snomed.owlapix.reasoner.SimpleConfiguration;
import org.semanticweb.elk.reasoner.config.ReasonerConfiguration;

public class ElkReasonerConfiguration {
    private static final long serialVersionUID = 4747024112171682291L;
    private final ReasonerConfiguration elkConfig;
    private final OwlReasonerConfiguration owlConfig;

    public ElkReasonerConfiguration(OwlReasonerConfiguration owlConfig, ReasonerConfiguration elkConfig) {
        this.elkConfig = elkConfig;
        this.owlConfig = owlConfig;
    }

    public ElkReasonerConfiguration() {
        this(ElkReasonerConfiguration.getDefaultOwlReasonerConfiguration(), ReasonerConfiguration.getConfiguration());
    }

    public ElkReasonerConfiguration(ReasonerProgressMonitor monitor) {
        this(ElkReasonerConfiguration.getDefaultOwlReasonerConfiguration(monitor), ReasonerConfiguration.getConfiguration());
    }

    public ElkReasonerConfiguration(OwlReasonerConfiguration genConfig) {
        this(genConfig, ReasonerConfiguration.getConfiguration());
    }

    public static OwlReasonerConfiguration getDefaultOwlReasonerConfiguration(ReasonerProgressMonitor monitor) {
        return new SimpleConfiguration(monitor, FreshEntityPolicy.ALLOW, 0L, IndividualNodeSetPolicy.BY_NAME);
    }

    public static OwlReasonerConfiguration getDefaultOwlReasonerConfiguration() {
        return ElkReasonerConfiguration.getDefaultOwlReasonerConfiguration(new NullReasonerProgressMonitor());
    }

    public FreshEntityPolicy getFreshEntityPolicy() {
        return this.owlConfig.getFreshEntityPolicy();
    }

    public IndividualNodeSetPolicy getIndividualNodeSetPolicy() {
        return this.owlConfig.getIndividualNodeSetPolicy();
    }

    public ReasonerProgressMonitor getProgressMonitor() {
        return this.owlConfig.getProgressMonitor();
    }

    public long getTimeOut() {
        return this.owlConfig.getTimeOut();
    }

    public ReasonerConfiguration getElkConfiguration() {
        return this.elkConfig;
    }
}

