/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.reasoner;

import dev.ikm.elk.snomed.owlapix.model.OwlxOntology;
import dev.ikm.elk.snomed.owlapix.reasoner.IllegalConfigurationException;
import dev.ikm.elk.snomed.owlapix.reasoner.OwlReasonerConfiguration;
import dev.ikm.elk.snomed.reasoner.ElkReasoner;
import dev.ikm.elk.snomed.reasoner.ElkReasonerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElkReasonerFactory {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(ElkReasonerFactory.class);

    public String getReasonerName() {
        LOGGER_.trace("getReasonerName()");
        return ElkReasonerFactory.class.getPackage().getImplementationTitle();
    }

    public ElkReasoner createNonBufferingReasoner(OwlxOntology ontology) {
        LOGGER_.trace("createNonBufferingReasoner(OWLOntology)");
        return this.createElkReasoner(ontology, false, null);
    }

    public ElkReasoner createReasoner(OwlxOntology ontology) {
        LOGGER_.trace("createReasoner(OWLOntology)");
        return this.createElkReasoner(ontology, true, null);
    }

    public ElkReasoner createNonBufferingReasoner(OwlxOntology ontology, OwlReasonerConfiguration config) throws IllegalConfigurationException {
        LOGGER_.trace("createNonBufferingReasoner(OWLOntology, OWLReasonerConfiguration)");
        return this.createElkReasoner(ontology, false, config);
    }

    public ElkReasoner createReasoner(OwlxOntology ontology, OwlReasonerConfiguration config) throws IllegalConfigurationException {
        LOGGER_.trace("createReasoner(OWLOntology, OWLReasonerConfiguration)");
        return this.createElkReasoner(ontology, true, config);
    }

    ElkReasoner createElkReasoner(OwlxOntology ontology, boolean isBufferingMode, OwlReasonerConfiguration config) throws IllegalConfigurationException {
        LOGGER_.trace("createElkReasoner(OWLOntology, boolean, OWLReasonerConfiguration)");
        ElkReasonerConfiguration elkReasonerConfig = config != null ? (config instanceof ElkReasonerConfiguration ? (ElkReasonerConfiguration)((Object)config) : new ElkReasonerConfiguration(config)) : new ElkReasonerConfiguration();
        return new ElkReasoner(ontology, isBufferingMode, elkReasonerConfig);
    }
}

