/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.reasoner;

import dev.ikm.elk.snomed.owlapix.reasoner.ReasonerProgressMonitor;
import org.semanticweb.elk.reasoner.ProgressMonitor;

public class ElkReasonerProgressMonitor
implements ProgressMonitor {
    private final ReasonerProgressMonitor pm;
    private static final long updateInterval = 10L;
    private static final double mimimalIncrement = 0.005;
    private long lastUpdateTime;
    private double lastProgress;

    public ElkReasonerProgressMonitor(ReasonerProgressMonitor pm) {
        this.pm = pm;
    }

    public synchronized void start(String message) {
        this.pm.reasonerTaskStarted(message);
        this.lastProgress = 0.0;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    public synchronized void report(int state, int maxState) {
        long time = System.currentTimeMillis();
        double progress = maxState == 0 ? 0.0 : (double)state / (double)maxState;
        if (time > this.lastUpdateTime + 10L && progress > this.lastProgress + 0.005) {
            this.pm.reasonerTaskProgressChanged(state, maxState);
            this.lastUpdateTime = time;
            this.lastProgress = progress;
        }
    }

    public synchronized void finish() {
        this.pm.reasonerTaskStopped();
    }
}

