/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.reasoner;

import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChange;
import dev.ikm.elk.snomed.reasoner.OwlOntologyChangeProcessorVisitor;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OwlChangesLoaderFactory
implements AxiomLoader.Factory {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(OwlChangesLoaderFactory.class);
    private final ProgressMonitor progressMonitor;
    private final LinkedList<OwlxOntologyChange> pendingChanges_;
    private Loader loader_ = null;

    OwlChangesLoaderFactory(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
        this.pendingChanges_ = new LinkedList();
    }

    private synchronized void load(InterruptMonitor interrupter, ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
        if (!this.pendingChanges_.isEmpty()) {
            OwlxOntologyChange change;
            String status = "Loading of Changes";
            this.progressMonitor.start(status);
            int changesCount = this.pendingChanges_.size();
            LOGGER_.trace("{}: {}", (Object)status, (Object)changesCount);
            int currentAxiom = 0;
            while (!interrupter.isInterrupted() && (change = this.pendingChanges_.poll()) != null) {
                if (!change.isAxiomChange()) {
                    ElkLoadingException exception = new ElkLoadingException("Cannot apply non-axiom change!");
                    LOGGER_.error(exception.getMessage(), (Throwable)exception);
                    throw exception;
                }
                OwlOntologyChangeProcessorVisitor loader = new OwlOntologyChangeProcessorVisitor(axiomInserter, axiomDeleter);
                loader.process(change);
                ElkLoadingException error = loader.getError();
                if (error != null) {
                    LOGGER_.error(error.getMessage(), (Throwable)error);
                    throw error;
                }
                this.progressMonitor.report(++currentAxiom, changesCount);
            }
            this.progressMonitor.finish();
        }
    }

    synchronized boolean isLoadingFinished() {
        return this.pendingChanges_.isEmpty();
    }

    synchronized void registerChange(OwlxOntologyChange change) {
        LOGGER_.trace("Registering change: {}", (Object)change);
        this.pendingChanges_.add(change);
    }

    Set<ElkAxiom> getPendingAxiomAdditions() {
        HashSet<ElkAxiom> added = new HashSet<ElkAxiom>();
        for (OwlxOntologyChange change : this.pendingChanges_) {
            if (!change.isAddAxiom()) continue;
            added.add(change.getAxiom());
        }
        return added;
    }

    Set<ElkAxiom> getPendingAxiomRemovals() {
        HashSet<ElkAxiom> removed = new HashSet<ElkAxiom>();
        for (OwlxOntologyChange change : this.pendingChanges_) {
            if (!change.isRemoveAxiom()) continue;
            removed.add(change.getAxiom());
        }
        return removed;
    }

    List<OwlxOntologyChange> getPendingChanges() {
        return this.pendingChanges_;
    }

    public AxiomLoader getAxiomLoader(InterruptMonitor interrupter) {
        if (this.loader_ == null) {
            this.loader_ = new Loader(interrupter);
        }
        return this.loader_;
    }

    private class Loader
    extends AbstractAxiomLoader {
        public Loader(InterruptMonitor interrupter) {
            super(interrupter);
        }

        public void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) throws ElkLoadingException {
            OwlChangesLoaderFactory.this.load((InterruptMonitor)this, axiomInserter, axiomDeleter);
        }

        public boolean isLoadingFinished() {
            return OwlChangesLoaderFactory.this.isLoadingFinished();
        }
    }
}

