/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.reasoner;

import dev.ikm.elk.snomed.owlapix.model.OwlxOntologyChange;
import org.semanticweb.elk.loading.ElkLoadingException;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OwlOntologyChangeProcessorVisitor {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(OwlOntologyChangeProcessorVisitor.class);
    private final ElkAxiomProcessor axiomInserter_;
    private final ElkAxiomProcessor axiomDeleter_;
    private ElkLoadingException error_ = null;

    OwlOntologyChangeProcessorVisitor(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) {
        this.axiomInserter_ = axiomInserter;
        this.axiomDeleter_ = axiomDeleter;
    }

    public void process(OwlxOntologyChange change) {
        ElkAxiom axiom = change.getAxiom();
        if (change.isAddAxiom()) {
            this.axiomInserter_.visit(axiom);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("adding " + String.valueOf(axiom));
            }
            return;
        }
        if (change.isRemoveAxiom()) {
            this.axiomDeleter_.visit(axiom);
            if (LOGGER_.isTraceEnabled()) {
                LOGGER_.trace("removing " + String.valueOf(axiom));
            }
            return;
        }
        this.error_ = new ElkLoadingException("Ontology change " + change.toString() + " is not supported");
    }

    public ElkLoadingException getError() {
        return this.error_;
    }
}

