/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.elk.snomed.reasoner;

import dev.ikm.elk.snomed.owlapix.model.OwlxOntology;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.elk.loading.AbstractAxiomLoader;
import org.semanticweb.elk.loading.AxiomLoader;
import org.semanticweb.elk.owl.interfaces.ElkAxiom;
import org.semanticweb.elk.owl.visitors.ElkAxiomProcessor;
import org.semanticweb.elk.reasoner.ProgressMonitor;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OwlOntologyLoader
extends AbstractAxiomLoader
implements AxiomLoader {
    private static final Logger LOGGER_ = LoggerFactory.getLogger(OwlOntologyLoader.class);
    private final OwlxOntology owlOntology_;
    private final ProgressMonitor progressMonitor_;
    private String status;
    private Iterator<OwlxOntology> importsClosureIterator_;
    private int importsClosureCount_;
    private int importsClosureProcessed_;
    private Iterator<ElkAxiom> axiomsIterator_;
    private int axiomsCount_;
    private int axiomsProcessed_;

    public OwlOntologyLoader(InterruptMonitor interrupter, OwlxOntology owlOntology, ProgressMonitor progressMonitor) {
        super(interrupter);
        this.owlOntology_ = owlOntology;
        this.progressMonitor_ = progressMonitor;
        this.initImportsClosure();
    }

    public void load(ElkAxiomProcessor axiomInserter, ElkAxiomProcessor axiomDeleter) {
        this.progressMonitor_.start(this.status);
        LOGGER_.trace("{}", (Object)this.status);
        while (!this.isInterrupted()) {
            if (!this.axiomsIterator_.hasNext()) {
                ++this.importsClosureProcessed_;
                if (!this.importsClosureIterator_.hasNext()) break;
                this.progressMonitor_.finish();
                this.updateStatus();
                this.progressMonitor_.start(this.status);
                LOGGER_.trace("{}", (Object)this.status);
                this.initAxioms(this.importsClosureIterator_.next());
                continue;
            }
            ElkAxiom axiom = this.axiomsIterator_.next();
            LOGGER_.trace("loading {}", (Object)axiom);
            axiomInserter.visit(axiom);
            ++this.axiomsProcessed_;
            this.progressMonitor_.report(this.axiomsProcessed_, this.axiomsCount_);
        }
        this.progressMonitor_.finish();
    }

    public boolean isLoadingFinished() {
        return this.axiomsIterator_ != null && !this.axiomsIterator_.hasNext() && this.importsClosureIterator_ != null && !this.importsClosureIterator_.hasNext();
    }

    public void dispose() {
        this.importsClosureIterator_ = null;
        this.importsClosureProcessed_ = 0;
        this.axiomsIterator_ = null;
        this.axiomsProcessed_ = 0;
    }

    private void initImportsClosure() {
        Set<OwlxOntology> importsClosure = this.owlOntology_.getImportsClosure();
        this.importsClosureIterator_ = importsClosure.iterator();
        this.importsClosureCount_ = importsClosure.size();
        this.importsClosureProcessed_ = 0;
        this.updateStatus();
        if (this.importsClosureIterator_.hasNext()) {
            this.initAxioms(this.importsClosureIterator_.next());
        } else {
            this.axiomsIterator_ = Collections.emptySet().iterator();
        }
    }

    private void initAxioms(OwlxOntology ontology) {
        Set<ElkAxiom> axioms = ontology.getAxioms();
        this.axiomsIterator_ = axioms.iterator();
        this.axiomsCount_ = axioms.size();
        this.axiomsProcessed_ = 0;
    }

    private void updateStatus() {
        this.status = this.importsClosureCount_ == 1 ? "Loading" : "Loading " + (this.importsClosureProcessed_ + 1) + " of " + this.importsClosureCount_;
    }

    public static class Factory
    implements AxiomLoader.Factory {
        private final OwlxOntology owlOntology_;
        private final ProgressMonitor progressMonitor_;

        public Factory(OwlxOntology owlOntology, ProgressMonitor progressMonitor) {
            this.owlOntology_ = owlOntology;
            this.progressMonitor_ = progressMonitor;
        }

        public OwlOntologyLoader getAxiomLoader(InterruptMonitor interrupter) {
            return new OwlOntologyLoader(interrupter, this.owlOntology_, this.progressMonitor_);
        }
    }
}

