/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.util.concurrent.computation;

import java.util.Random;
import org.semanticweb.elk.util.concurrent.computation.InterruptMonitor;

public class RandomInterruptMonitor
implements InterruptMonitor {
    private final Random random_;
    private final double chance_;
    private final long intervalNanos_;
    private long lastTrialTimeNanos_;

    public RandomInterruptMonitor(Random random, double chance, long intervalNanos) {
        if (chance < 0.0 || chance > 1.0) {
            throw new IllegalArgumentException("chance must be between 0 and 1 inclusive!");
        }
        if (intervalNanos <= 0L) {
            throw new IllegalArgumentException("interval must be positive!");
        }
        this.random_ = random;
        this.chance_ = chance;
        this.intervalNanos_ = intervalNanos;
        this.lastTrialTimeNanos_ = System.nanoTime();
    }

    @Override
    public synchronized boolean isInterrupted() {
        long timeSinceLastTrial = System.nanoTime() - this.lastTrialTimeNanos_;
        long nTrials = timeSinceLastTrial / this.intervalNanos_;
        if (nTrials > 0L) {
            this.lastTrialTimeNanos_ += nTrials * this.intervalNanos_;
            double chanceNow = 1.0 - Math.pow(1.0 - this.chance_, nTrials);
            if (this.random_.nextDouble() < chanceNow) {
                return true;
            }
        }
        return false;
    }
}

