/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class FileUtils {
    public static FilenameFilter getExtBasedFilenameFilter(final String extension) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.endsWith("." + extension);
            }
        };
    }

    public static String dropExtension(String filename) {
        int index = -1;
        index = filename.lastIndexOf(46);
        if (index < 0) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String dropExtension(String filename, String extension) {
        int index = -1;
        index = filename.lastIndexOf("." + extension);
        if (index < 0) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index < 0) {
            return null;
        }
        return filename.substring(index + 1, filename.length());
    }

    public static String getFileName(String path) {
        return new File(path).getName();
    }

    public static void deleteRecursively(File file) throws IOException {
        FileUtils.deleteRecursively(file, false);
    }

    public static void deleteRecursively(File file, boolean deleteOnExit) throws IOException {
        File[] directoryFiles = file.listFiles();
        if (directoryFiles != null) {
            for (File c : directoryFiles) {
                FileUtils.deleteRecursively(c);
            }
        }
        if (deleteOnExit) {
            file.deleteOnExit();
        } else if (!file.delete()) {
            throw new IOException("Failed to delete file: " + String.valueOf(file));
        }
    }
}

