/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.elk.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IOUtils {
    private static final int BUFFER_SIZE = 2048;

    public static void closeQuietly(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeQuietly(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[2048];
        BufferedInputStream in = new BufferedInputStream(input, 2048);
        BufferedOutputStream out = new BufferedOutputStream(output, 2048);
        int count = 0;
        int n = 0;
        try {
            while ((n = in.read(buffer, 0, 2048)) != -1) {
                out.write(buffer, 0, n);
                count += n;
            }
            out.flush();
        }
        finally {
            IOUtils.closeQuietly(in);
            IOUtils.closeQuietly(out);
        }
        return count;
    }

    private static void collectResourceNamesFromDir(File file, String prefix, String extension, Collection<String> result) {
        String fileName = file.getName();
        if (file.isDirectory()) {
            File[] innerFiles = file.listFiles();
            if (innerFiles == null) {
                throw new RuntimeException("Error listing directory " + String.valueOf(file));
            }
            for (File innerFile : innerFiles) {
                IOUtils.collectResourceNamesFromDir(innerFile, prefix + fileName + File.separator, extension, result);
            }
            return;
        }
        if (fileName.endsWith("." + extension)) {
            result.add(prefix + fileName);
        }
    }

    public static List<String> getResourceNamesFromDir(File dir, String extension) {
        ArrayList<String> testResources = new ArrayList<String>();
        IOUtils.collectResourceNamesFromDir(dir, "", extension, testResources);
        return testResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getResourceNamesFromJAR(String path, String extension, Class<?> clazz) throws IOException {
        ZipInputStream zip;
        ArrayList<String> testResources;
        block4: {
            block3: {
                CodeSource src = clazz.getProtectionDomain().getCodeSource();
                testResources = new ArrayList<String>();
                zip = null;
                if (src == null) break block3;
                URL jar = src.getLocation();
                ZipEntry ze = null;
                try {
                    zip = new ZipInputStream(jar.openStream());
                    while ((ze = zip.getNextEntry()) != null) {
                        String entryName = ze.getName();
                        if (!entryName.startsWith(path) || !entryName.endsWith("." + extension)) continue;
                        testResources.add(entryName);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(zip);
                    throw throwable;
                }
                break block4;
            }
            throw new IOException("Unable to get code source for " + clazz.getSimpleName());
        }
        IOUtils.closeQuietly(zip);
        return testResources;
    }

    public static void traverseDirectoryTree(File root, PathVisitor visitor) {
        IOUtils.traverseDirectoryTree(root, "", visitor);
    }

    private static void traverseDirectoryTree(File file, String relativePath, PathVisitor visitor) {
        String path = relativePath + file.getName();
        visitor.visitBefore(path);
        if (file.isDirectory()) {
            File[] innerFiles = file.listFiles();
            if (innerFiles == null) {
                throw new RuntimeException("Error listing directory " + String.valueOf(file));
            }
            for (File innerFile : innerFiles) {
                IOUtils.traverseDirectoryTree(innerFile, path + File.separator, visitor);
            }
        }
        visitor.visitAfter(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traverseJarContentTree(String rootPath, Class<?> srcClass, PathVisitor visitor) throws IOException {
        Object root = rootPath.endsWith("/") ? rootPath : rootPath + "/";
        CodeSource src = srcClass.getProtectionDomain().getCodeSource();
        if (src == null) {
            throw new IOException("Unable to get code source for " + srcClass.getSimpleName());
        }
        ArrayList<Object> paths = new ArrayList<Object>();
        boolean haveRootPath = false;
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(src.getLocation().openStream());
            ZipEntry ze = null;
            while ((ze = zip.getNextEntry()) != null) {
                String entryName = ze.getName();
                if (!entryName.startsWith((String)root)) continue;
                paths.add(entryName);
                if (entryName.length() != ((String)root).length()) continue;
                haveRootPath = true;
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zip);
            throw throwable;
        }
        IOUtils.closeQuietly(zip);
        if (!haveRootPath) {
            paths.add(root);
        }
        Collections.sort(paths);
        Stack<String> currentBranch = new Stack<String>();
        for (String string : paths) {
            String[] pathComponents = string.split("/");
            if (currentBranch.isEmpty()) {
                visitor.visitBefore(string);
                currentBranch.push(string);
                continue;
            }
            String top = (String)currentBranch.peek();
            String[] topComponents = top.split("/");
            if (IOUtils.startsWith(pathComponents, topComponents)) {
                visitor.visitBefore(string);
                currentBranch.push(string);
                continue;
            }
            do {
                currentBranch.pop();
                visitor.visitAfter(top);
            } while (!IOUtils.startsWith(pathComponents, topComponents = (top = (String)currentBranch.peek()).split("/")));
            visitor.visitBefore(string);
            currentBranch.push(string);
        }
        while (!currentBranch.isEmpty()) {
            String top = (String)currentBranch.pop();
            visitor.visitAfter(top);
        }
    }

    private static <E> boolean startsWith(E[] array, E[] prefix) {
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (!(prefix[i] == null ? array[i] != null : !prefix[i].equals(array[i]))) continue;
            return false;
        }
        return true;
    }

    public static interface PathVisitor {
        public void visitBefore(String var1);

        public void visitAfter(String var1);
    }
}

