/*
 * Decompiled with CFR 0.152.
 */
package io.activej.bytebuf;

import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.common.ApplicationSettings;
import io.activej.common.Checks;
import io.activej.common.collection.CollectionUtils;
import io.activej.common.exception.InvalidSizeException;
import io.activej.common.exception.MalformedDataException;
import io.activej.common.exception.UncheckedException;
import io.activej.common.recycle.Recyclable;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Collector;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ByteBufs
implements Recyclable {
    private static final boolean CHECK = Checks.isEnabled(ByteBufs.class);
    private static final int DEFAULT_CAPACITY = 8;
    private static final boolean NULLIFY_ON_TAKE_OUT = ApplicationSettings.getBoolean(ByteBufs.class, (String)"nullifyOnTakeOut", (boolean)ByteBufPool.USE_WATCHDOG);
    private ByteBuf[] bufs;
    private int first = 0;
    private int last = 0;
    private static final Collector<ByteBuf, ByteBufs, ByteBuf> COLLECTOR = Collector.of(ByteBufs::new, ByteBufs::add, (bufs1, bufs2) -> {
        throw new UnsupportedOperationException("Parallel collection of byte bufs is not supported");
    }, ByteBufs::takeRemaining, new Collector.Characteristics[0]);

    public ByteBufs() {
        this(8);
    }

    public ByteBufs(int capacity) {
        this.bufs = new ByteBuf[capacity];
    }

    public static Collector<ByteBuf, ByteBufs, ByteBuf> collector() {
        return COLLECTOR;
    }

    public static Collector<ByteBuf, ByteBufs, ByteBuf> collector(int maxSize) {
        return Collector.of(ByteBufs::new, (bufs, buf) -> {
            int size = buf.readRemaining();
            if (size > maxSize || bufs.hasRemainingBytes(maxSize - size + 1)) {
                bufs.recycle();
                buf.recycle();
                throw new UncheckedException((Throwable)new InvalidSizeException("Size of ByteBufs exceeds maximum size of " + maxSize + " bytes"));
            }
            bufs.add((ByteBuf)buf);
        }, (bufs1, bufs2) -> {
            throw new UnsupportedOperationException("Parallel collection of byte bufs is not supported");
        }, ByteBufs::takeRemaining, new Collector.Characteristics[0]);
    }

    private int next(int i) {
        return (i + 1) % this.bufs.length;
    }

    private void grow() {
        ByteBuf[] newBufs = new ByteBuf[this.bufs.length * 2];
        System.arraycopy(this.bufs, this.last, newBufs, 0, this.bufs.length - this.last);
        System.arraycopy(this.bufs, 0, newBufs, this.bufs.length - this.last, this.last);
        this.first = 0;
        this.last = this.bufs.length;
        this.bufs = newBufs;
    }

    public void add(@NotNull ByteBuf buf) {
        if (!buf.canRead()) {
            buf.recycle();
            return;
        }
        this.bufs[this.last] = buf;
        this.last = this.next(this.last);
        if (this.last == this.first) {
            this.grow();
        }
    }

    public void addAll(@NotNull Iterable<ByteBuf> byteBufs) {
        for (ByteBuf buf : byteBufs) {
            this.add(buf);
        }
    }

    @NotNull
    public ByteBuf take() {
        if (CHECK) {
            Checks.checkState((boolean)this.hasRemaining(), (Object)"No bufs to take");
        }
        ByteBuf buf = this.bufs[this.first];
        if (NULLIFY_ON_TAKE_OUT) {
            this.bufs[this.first] = null;
        }
        this.first = this.next(this.first);
        return buf;
    }

    @Nullable
    public ByteBuf poll() {
        if (this.hasRemaining()) {
            return this.take();
        }
        return null;
    }

    @NotNull
    public ByteBuf takeAtMost(int size) {
        if (this.isEmpty() || size == 0) {
            return ByteBuf.empty();
        }
        ByteBuf buf = this.bufs[this.first];
        if (size >= buf.readRemaining()) {
            if (NULLIFY_ON_TAKE_OUT) {
                this.bufs[this.first] = null;
            }
            this.first = this.next(this.first);
            return buf;
        }
        ByteBuf result = buf.slice(size);
        buf.moveHead(size);
        return result;
    }

    @NotNull
    public ByteBuf takeAtLeast(int size) {
        return this.takeAtLeast(size, $ -> {});
    }

    @NotNull
    public ByteBuf takeAtLeast(int size, @NotNull Consumer<ByteBuf> recycledBufs) {
        if (CHECK) {
            Checks.checkArgument((boolean)this.hasRemainingBytes(size), () -> "There are less than " + size + " bufs");
        }
        if (size == 0) {
            return ByteBuf.empty();
        }
        ByteBuf buf = this.bufs[this.first];
        if (buf.readRemaining() >= size) {
            if (NULLIFY_ON_TAKE_OUT) {
                this.bufs[this.first] = null;
            }
            this.first = this.next(this.first);
            return buf;
        }
        ByteBuf result = ByteBufPool.allocate(size);
        this.drainTo(result.array(), 0, size, recycledBufs);
        result.moveTail(size);
        return result;
    }

    @NotNull
    public ByteBuf takeExactSize(int exactSize) {
        return this.takeExactSize(exactSize, $ -> {});
    }

    @NotNull
    public ByteBuf takeExactSize(int exactSize, @NotNull Consumer<ByteBuf> recycledBufs) {
        if (CHECK) {
            Checks.checkArgument((boolean)this.hasRemainingBytes(exactSize), () -> "There are less than " + exactSize + " bufs");
        }
        if (exactSize == 0) {
            return ByteBuf.empty();
        }
        ByteBuf buf = this.bufs[this.first];
        if (buf.readRemaining() == exactSize) {
            if (NULLIFY_ON_TAKE_OUT) {
                this.bufs[this.first] = null;
            }
            this.first = this.next(this.first);
            return buf;
        }
        if (exactSize < buf.readRemaining()) {
            ByteBuf result = buf.slice(exactSize);
            buf.moveHead(exactSize);
            return result;
        }
        ByteBuf result = ByteBufPool.allocate(exactSize);
        this.drainTo(result.array(), 0, exactSize, recycledBufs);
        result.moveTail(exactSize);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(int size, @NotNull Consumer<ByteBuf> consumer) {
        ByteBuf buf;
        if (CHECK) {
            Checks.checkArgument((boolean)this.hasRemainingBytes(size), () -> "There are less than " + size + " bufs");
        }
        if ((buf = this.bufs[this.first]).readRemaining() >= size) {
            int newPos = buf.head() + size;
            consumer.accept(buf);
            buf.head(newPos);
            if (!buf.canRead()) {
                if (NULLIFY_ON_TAKE_OUT) {
                    this.bufs[this.first] = null;
                }
                this.first = this.next(this.first);
                buf.recycle();
            }
        } else {
            buf = ByteBufPool.allocate(size);
            this.drainTo(buf, size);
            try {
                consumer.accept(buf);
            }
            finally {
                buf.recycle();
            }
        }
    }

    @NotNull
    public ByteBuf takeRemaining() {
        return this.takeExactSize(this.remainingBytes());
    }

    @Contract(pure=true)
    public ByteBuf peekBuf() {
        return this.hasRemaining() ? this.bufs[this.first] : null;
    }

    @NotNull
    @Contract(pure=true)
    public ByteBuf peekBuf(int n) {
        if (CHECK) {
            Checks.checkArgument((n <= this.remainingBufs() ? 1 : 0) != 0, (Object)"Index exceeds bufs size");
        }
        return this.bufs[(this.first + n) % this.bufs.length];
    }

    public int peekTo(@NotNull byte[] dest, int destOffset, int maxSize) {
        int s = maxSize;
        int first = this.first;
        while (first != this.last) {
            ByteBuf buf = this.bufs[first];
            int remaining = buf.readRemaining();
            if (s < remaining) {
                System.arraycopy(buf.array(), buf.head(), dest, destOffset, s);
                return maxSize;
            }
            System.arraycopy(buf.array(), buf.head(), dest, destOffset, remaining);
            first = this.next(first);
            s -= remaining;
            destOffset += remaining;
        }
        return maxSize - s;
    }

    @Contract(pure=true)
    public int remainingBufs() {
        return (this.bufs.length + (this.last - this.first)) % this.bufs.length;
    }

    @Contract(pure=true)
    public int remainingBytes() {
        int result = 0;
        int i = this.first;
        while (i != this.last) {
            result += this.bufs[i].readRemaining();
            i = this.next(i);
        }
        return result;
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return !this.hasRemaining();
    }

    @Contract(pure=true)
    public boolean hasRemaining() {
        return this.first != this.last;
    }

    @Contract(pure=true)
    public boolean hasRemainingBytes(int remaining) {
        if (CHECK) {
            Checks.checkArgument((remaining >= 0 ? 1 : 0) != 0, (Object)"Cannot check for negative bytes");
        }
        if (remaining == 0) {
            return true;
        }
        int i = this.first;
        while (i != this.last) {
            int bufRemaining = this.bufs[i].readRemaining();
            if (bufRemaining >= remaining) {
                return true;
            }
            remaining -= bufRemaining;
            i = this.next(i);
        }
        return false;
    }

    public byte getByte() {
        if (CHECK) {
            Checks.checkState((boolean)this.hasRemaining(), (Object)"No bytes to get");
        }
        ByteBuf buf = this.bufs[this.first];
        if (CHECK) {
            Checks.checkState((boolean)buf.canRead(), (Object)"Empty buf is found in bufs");
        }
        byte result = buf.get();
        if (!buf.canRead()) {
            this.bufs[this.first].recycle();
            if (NULLIFY_ON_TAKE_OUT) {
                this.bufs[this.first] = null;
            }
            this.first = this.next(this.first);
        }
        return result;
    }

    @Contract(pure=true)
    public byte peekByte() {
        if (CHECK) {
            Checks.checkState((boolean)this.hasRemaining(), (Object)"No bytes to peek");
        }
        ByteBuf buf = this.bufs[this.first];
        return buf.peek();
    }

    @Contract(pure=true)
    public byte peekByte(int index) {
        if (CHECK) {
            Checks.checkState((boolean)this.hasRemainingBytes(index + 1), (Object)"Index exceeds the number of bytes in bufs");
        }
        int i = this.first;
        ByteBuf buf;
        while (index >= (buf = this.bufs[i]).readRemaining()) {
            index -= buf.readRemaining();
            i = this.next(i);
        }
        return buf.peek(index);
    }

    public void setByte(int index, byte b) {
        if (CHECK) {
            Checks.checkArgument((boolean)this.hasRemainingBytes(index + 1), (Object)"Index exceeds bufs bytes length");
        }
        int i = this.first;
        while (true) {
            ByteBuf buf;
            if (index < (buf = this.bufs[i]).readRemaining()) {
                buf.array[buf.head + index] = b;
                return;
            }
            index -= buf.readRemaining();
            i = this.next(i);
        }
    }

    public int skip(int maxSize) {
        return this.skip(maxSize, $ -> {});
    }

    public int skip(int maxSize, @NotNull Consumer<ByteBuf> recycledBufs) {
        int s = maxSize;
        while (this.hasRemaining()) {
            ByteBuf buf = this.bufs[this.first];
            int remaining = buf.readRemaining();
            if (s < remaining) {
                buf.moveHead(s);
                return maxSize;
            }
            recycledBufs.accept(buf);
            buf.recycle();
            if (NULLIFY_ON_TAKE_OUT) {
                this.bufs[this.first] = null;
            }
            this.first = this.next(this.first);
            s -= remaining;
        }
        return maxSize - s;
    }

    public int drainTo(@NotNull byte[] dest, int destOffset, int maxSize) {
        return this.drainTo(dest, destOffset, maxSize, $ -> {});
    }

    public int drainTo(@NotNull byte[] dest, int destOffset, int maxSize, @NotNull Consumer<ByteBuf> recycledBufs) {
        int s = maxSize;
        while (this.hasRemaining()) {
            ByteBuf buf = this.bufs[this.first];
            int remaining = buf.readRemaining();
            if (s < remaining) {
                System.arraycopy(buf.array(), buf.head(), dest, destOffset, s);
                buf.moveHead(s);
                return maxSize;
            }
            System.arraycopy(buf.array(), buf.head(), dest, destOffset, remaining);
            recycledBufs.accept(buf);
            buf.recycle();
            if (NULLIFY_ON_TAKE_OUT) {
                this.bufs[this.first] = null;
            }
            this.first = this.next(this.first);
            s -= remaining;
            destOffset += remaining;
        }
        return maxSize - s;
    }

    public int drainTo(@NotNull ByteBuf dest, int maxSize) {
        int actualSize = this.drainTo(dest.array(), dest.tail(), maxSize);
        dest.moveTail(actualSize);
        return actualSize;
    }

    public int drainTo(@NotNull ByteBuf dest) {
        return this.drainTo(dest, dest.writeRemaining());
    }

    public int drainTo(@NotNull ByteBufs dest) {
        int size = 0;
        while (this.hasRemaining()) {
            ByteBuf buf = this.take();
            dest.add(buf);
            size += buf.readRemaining();
        }
        return size;
    }

    public int drainTo(@NotNull ByteBufs dest, int maxSize) {
        int s;
        ByteBuf buf;
        for (s = maxSize; s != 0 && this.hasRemaining(); s -= buf.readRemaining()) {
            buf = this.takeAtMost(s);
            dest.add(buf);
        }
        return maxSize - s;
    }

    public int scanBytes(ByteScanner byteScanner) throws MalformedDataException {
        return this.scanBytes(0, byteScanner);
    }

    public int scanBytes(int offset, ByteScanner byteScanner) throws MalformedDataException {
        int readRemaining;
        int n = this.first;
        while (offset > 0 && n != this.last && offset >= (readRemaining = this.bufs[n].readRemaining())) {
            offset -= readRemaining;
            n = this.next(n);
        }
        int index = 0;
        while (n != this.last) {
            ByteBuf buf = this.bufs[n];
            byte[] array = buf.array();
            int tail = buf.tail();
            for (int i = buf.head() + offset; i != tail; ++i) {
                if (!byteScanner.consume(index++, array[i])) continue;
                return index;
            }
            n = this.next(n);
            offset = 0;
        }
        return 0;
    }

    public int consumeBytes(ByteScanner byteScanner) throws MalformedDataException {
        return this.consumeBytes(0, byteScanner, $ -> {});
    }

    public int consumeBytes(ByteScanner byteScanner, Consumer<ByteBuf> recycledBufs) throws MalformedDataException {
        return this.consumeBytes(0, byteScanner, recycledBufs);
    }

    public int consumeBytes(int offset, ByteScanner byteScanner) throws MalformedDataException {
        return this.consumeBytes(offset, byteScanner, $ -> {});
    }

    public int consumeBytes(int offset, ByteScanner byteScanner, Consumer<ByteBuf> recycledBufs) throws MalformedDataException {
        int readRemaining;
        int n = this.first;
        while (offset > 0 && n != this.last && offset >= (readRemaining = this.bufs[n].readRemaining())) {
            offset -= readRemaining;
            n = this.next(n);
        }
        int index = 0;
        while (n != this.last) {
            int i;
            ByteBuf buf = this.bufs[n];
            byte[] array = buf.array();
            int tail = buf.tail();
            for (i = buf.head() + offset; i != tail && !byteScanner.consume(index++, array[i]); ++i) {
            }
            if (i != tail) {
                while (this.first != n) {
                    ByteBuf bufToRecycle = this.bufs[this.first];
                    recycledBufs.accept(bufToRecycle);
                    bufToRecycle.recycle();
                    if (NULLIFY_ON_TAKE_OUT) {
                        this.bufs[this.first] = null;
                    }
                    this.first = this.next(this.first);
                }
                if (i == tail - 1) {
                    recycledBufs.accept(buf);
                    buf.recycle();
                    if (NULLIFY_ON_TAKE_OUT) {
                        this.bufs[this.first] = null;
                    }
                    this.first = this.next(this.first);
                } else {
                    buf.head(i + 1);
                }
                return index;
            }
            n = this.next(n);
            offset = 0;
        }
        return 0;
    }

    @NotNull
    public Iterator<ByteBuf> asIterator() {
        if (!this.hasRemaining()) {
            return CollectionUtils.emptyIterator();
        }
        ByteBufIterator iterator = new ByteBufIterator(this);
        this.last = 0;
        this.first = 0;
        this.bufs = null;
        return iterator;
    }

    public boolean isRecycled() {
        return this.bufs == null;
    }

    public void recycle() {
        while (this.first != this.last) {
            this.bufs[this.first].recycle();
            this.first = this.next(this.first);
        }
        this.bufs = null;
    }

    public String toString() {
        return "bufs:" + this.remainingBufs() + " bytes:" + this.remainingBytes();
    }

    public static interface ByteScanner {
        public boolean consume(int var1, byte var2) throws MalformedDataException;
    }

    public static class ByteBufIterator
    implements Iterator<ByteBuf> {
        ByteBuf[] bufs;
        int first;
        final int last;

        private ByteBufIterator(@NotNull ByteBufs bufs) {
            this.bufs = bufs.bufs;
            this.first = bufs.first;
            this.last = bufs.last;
        }

        @Override
        public boolean hasNext() {
            return this.first != this.last;
        }

        @Override
        @NotNull
        public ByteBuf next() {
            ByteBuf buf = this.bufs[this.first];
            if (NULLIFY_ON_TAKE_OUT) {
                this.bufs[this.first] = null;
            }
            this.first = (this.first + 1) % this.bufs.length;
            return buf;
        }

        public boolean isRecycled() {
            return this.bufs == null;
        }
    }
}

