/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Bundle", profile="http://hl7.org/fhir/StructureDefinition/Bundle")
public class Bundle
extends Resource
implements IBaseBundle {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Persistent identifier for the bundle", formalDefinition="A persistent identifier for the bundle that won't change as a bundle is copied from server to server.")
    protected Identifier identifier;
    @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection", formalDefinition="Indicates the purpose of this bundle - how it is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/bundle-type")
    protected Enumeration<BundleType> type;
    @Child(name="timestamp", type={InstantType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the bundle was assembled", formalDefinition="The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.")
    protected InstantType timestamp;
    @Child(name="total", type={UnsignedIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="If search, the total number of matches", formalDefinition="If a set of search matches, this is the total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.")
    protected UnsignedIntType total;
    @Child(name="link", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Links related to this Bundle", formalDefinition="A series of links that provide context to this bundle.")
    protected List<BundleLinkComponent> link;
    @Child(name="entry", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Entry in the bundle - will have a resource or information", formalDefinition="An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).")
    protected List<BundleEntryComponent> entry;
    @Child(name="signature", type={Signature.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Digital Signature", formalDefinition="Digital Signature - base64 encoded. XML-DSig or a JWT.")
    protected Signature signature;
    private static final long serialVersionUID = 1740470158L;
    @SearchParamDefinition(name="identifier", path="Bundle.identifier", description="Persistent identifier for the bundle", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="composition", path="Bundle.entry[0].resource", description="The first resource in the bundle, if the bundle type is \"document\" - this is a composition, and this parameter provides access to search its contents", type="reference", target={Composition.class})
    public static final String SP_COMPOSITION = "composition";
    public static final ReferenceClientParam COMPOSITION = new ReferenceClientParam("composition");
    public static final Include INCLUDE_COMPOSITION = new Include("Bundle:composition").toLocked();
    @SearchParamDefinition(name="type", path="Bundle.type", description="document | message | transaction | transaction-response | batch | batch-response | history | searchset | collection", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="message", path="Bundle.entry[0].resource", description="The first resource in the bundle, if the bundle type is \"message\" - this is a message header, and this parameter provides access to search its contents", type="reference", target={MessageHeader.class})
    public static final String SP_MESSAGE = "message";
    public static final ReferenceClientParam MESSAGE = new ReferenceClientParam("message");
    public static final Include INCLUDE_MESSAGE = new Include("Bundle:message").toLocked();
    @SearchParamDefinition(name="timestamp", path="Bundle.timestamp", description="When the bundle was assembled", type="date")
    public static final String SP_TIMESTAMP = "timestamp";
    public static final DateClientParam TIMESTAMP = new DateClientParam("timestamp");

    public Bundle() {
    }

    public Bundle(Enumeration<BundleType> type) {
        this.type = type;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Bundle setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Enumeration<BundleType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Bundle setTypeElement(Enumeration<BundleType> value) {
        this.type = value;
        return this;
    }

    public BundleType getType() {
        return this.type == null ? null : (BundleType)((Object)this.type.getValue());
    }

    public Bundle setType(BundleType value) {
        if (this.type == null) {
            this.type = new Enumeration<BundleType>(new BundleTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public InstantType getTimestampElement() {
        if (this.timestamp == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.timestamp");
            }
            if (Configuration.doAutoCreate()) {
                this.timestamp = new InstantType();
            }
        }
        return this.timestamp;
    }

    public boolean hasTimestampElement() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public boolean hasTimestamp() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public Bundle setTimestampElement(InstantType value) {
        this.timestamp = value;
        return this;
    }

    public Date getTimestamp() {
        return this.timestamp == null ? null : (Date)this.timestamp.getValue();
    }

    public Bundle setTimestamp(Date value) {
        if (value == null) {
            this.timestamp = null;
        } else {
            if (this.timestamp == null) {
                this.timestamp = new InstantType();
            }
            this.timestamp.setValue(value);
        }
        return this;
    }

    public UnsignedIntType getTotalElement() {
        if (this.total == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.total");
            }
            if (Configuration.doAutoCreate()) {
                this.total = new UnsignedIntType();
            }
        }
        return this.total;
    }

    public boolean hasTotalElement() {
        return this.total != null && !this.total.isEmpty();
    }

    public boolean hasTotal() {
        return this.total != null && !this.total.isEmpty();
    }

    public Bundle setTotalElement(UnsignedIntType value) {
        this.total = value;
        return this;
    }

    public int getTotal() {
        return this.total == null || this.total.isEmpty() ? 0 : (Integer)this.total.getValue();
    }

    public Bundle setTotal(int value) {
        if (this.total == null) {
            this.total = new UnsignedIntType();
        }
        this.total.setValue((Object)value);
        return this;
    }

    public List<BundleLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        return this.link;
    }

    public Bundle setLink(List<BundleLinkComponent> theLink) {
        this.link = theLink;
        return this;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (BundleLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BundleLinkComponent addLink() {
        BundleLinkComponent t = new BundleLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public Bundle addLink(BundleLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<BundleLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    public BundleLinkComponent getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            this.addLink();
        }
        return this.getLink().get(0);
    }

    public List<BundleEntryComponent> getEntry() {
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        return this.entry;
    }

    public Bundle setEntry(List<BundleEntryComponent> theEntry) {
        this.entry = theEntry;
        return this;
    }

    public boolean hasEntry() {
        if (this.entry == null) {
            return false;
        }
        for (BundleEntryComponent item : this.entry) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BundleEntryComponent addEntry() {
        BundleEntryComponent t = new BundleEntryComponent();
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        this.entry.add(t);
        return t;
    }

    public Bundle addEntry(BundleEntryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.entry == null) {
            this.entry = new ArrayList<BundleEntryComponent>();
        }
        this.entry.add(t);
        return this;
    }

    public BundleEntryComponent getEntryFirstRep() {
        if (this.getEntry().isEmpty()) {
            this.addEntry();
        }
        return this.getEntry().get(0);
    }

    public Signature getSignature() {
        if (this.signature == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Bundle.signature");
            }
            if (Configuration.doAutoCreate()) {
                this.signature = new Signature();
            }
        }
        return this.signature;
    }

    public boolean hasSignature() {
        return this.signature != null && !this.signature.isEmpty();
    }

    public Bundle setSignature(Signature value) {
        this.signature = value;
        return this;
    }

    public BundleLinkComponent getLink(String theRelation) {
        Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
        for (BundleLinkComponent next : this.getLink()) {
            if (!theRelation.equals(next.getRelation())) continue;
            return next;
        }
        return null;
    }

    public BundleLinkComponent getLinkOrCreate(String theRelation) {
        Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
        for (BundleLinkComponent next : this.getLink()) {
            if (!theRelation.equals(next.getRelation())) continue;
            return next;
        }
        BundleLinkComponent retVal = new BundleLinkComponent();
        retVal.setRelation(theRelation);
        this.getLink().add(retVal);
        return retVal;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A persistent identifier for the bundle that won't change as a bundle is copied from server to server.", 0, 1, this.identifier));
        children.add(new Property(SP_TYPE, "code", "Indicates the purpose of this bundle - how it is intended to be used.", 0, 1, this.type));
        children.add(new Property(SP_TIMESTAMP, "instant", "The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.", 0, 1, this.timestamp));
        children.add(new Property("total", "unsignedInt", "If a set of search matches, this is the total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.", 0, 1, this.total));
        children.add(new Property("link", "", "A series of links that provide context to this bundle.", 0, Integer.MAX_VALUE, this.link));
        children.add(new Property("entry", "", "An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).", 0, Integer.MAX_VALUE, this.entry));
        children.add(new Property("signature", "Signature", "Digital Signature - base64 encoded. XML-DSig or a JWT.", 0, 1, this.signature));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A persistent identifier for the bundle that won't change as a bundle is copied from server to server.", 0, 1, this.identifier);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "Indicates the purpose of this bundle - how it is intended to be used.", 0, 1, this.type);
            }
            case 55126294: {
                return new Property(SP_TIMESTAMP, "instant", "The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.", 0, 1, this.timestamp);
            }
            case 110549828: {
                return new Property("total", "unsignedInt", "If a set of search matches, this is the total number of entries of type 'match' across all pages in the search.  It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.", 0, 1, this.total);
            }
            case 3321850: {
                return new Property("link", "", "A series of links that provide context to this bundle.", 0, Integer.MAX_VALUE, this.link);
            }
            case 96667762: {
                return new Property("entry", "", "An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).", 0, Integer.MAX_VALUE, this.entry);
            }
            case 1073584312: {
                return new Property("signature", "Signature", "Digital Signature - base64 encoded. XML-DSig or a JWT.", 0, 1, this.signature);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                Base[] baseArray;
                if (this.identifier == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.identifier;
                }
                return baseArray;
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.type;
                }
                return baseArray;
            }
            case 55126294: {
                Base[] baseArray;
                if (this.timestamp == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.timestamp;
                }
                return baseArray;
            }
            case 110549828: {
                Base[] baseArray;
                if (this.total == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.total;
                }
                return baseArray;
            }
            case 3321850: {
                return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
            }
            case 96667762: {
                return this.entry == null ? new Base[]{} : this.entry.toArray(new Base[this.entry.size()]);
            }
            case 1073584312: {
                Base[] baseArray;
                if (this.signature == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.signature;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.identifier = this.castToIdentifier(value);
                return value;
            }
            case 3575610: {
                value = new BundleTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
                return value;
            }
            case 55126294: {
                this.timestamp = this.castToInstant(value);
                return value;
            }
            case 110549828: {
                this.total = this.castToUnsignedInt(value);
                return value;
            }
            case 3321850: {
                this.getLink().add((BundleLinkComponent)((Object)value));
                return value;
            }
            case 96667762: {
                this.getEntry().add((BundleEntryComponent)((Object)value));
                return value;
            }
            case 1073584312: {
                this.signature = this.castToSignature(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_TYPE)) {
            value = new BundleTypeEnumFactory().fromType(this.castToCode(value));
            this.type = value;
        } else if (name.equals(SP_TIMESTAMP)) {
            this.timestamp = this.castToInstant(value);
        } else if (name.equals("total")) {
            this.total = this.castToUnsignedInt(value);
        } else if (name.equals("link")) {
            this.getLink().add((BundleLinkComponent)((Object)value));
        } else if (name.equals("entry")) {
            this.getEntry().add((BundleEntryComponent)((Object)value));
        } else if (name.equals("signature")) {
            this.signature = this.castToSignature(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = null;
        } else if (name.equals(SP_TYPE)) {
            this.type = null;
        } else if (name.equals(SP_TIMESTAMP)) {
            this.timestamp = null;
        } else if (name.equals("total")) {
            this.total = null;
        } else if (name.equals("link")) {
            this.getLink().remove((BundleLinkComponent)value);
        } else if (name.equals("entry")) {
            this.getEntry().remove((BundleEntryComponent)value);
        } else if (name.equals("signature")) {
            this.signature = null;
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.getIdentifier();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 55126294: {
                return this.getTimestampElement();
            }
            case 110549828: {
                return this.getTotalElement();
            }
            case 3321850: {
                return this.addLink();
            }
            case 96667762: {
                return this.addEntry();
            }
            case 1073584312: {
                return this.getSignature();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 55126294: {
                return new String[]{"instant"};
            }
            case 110549828: {
                return new String[]{"unsignedInt"};
            }
            case 3321850: {
                return new String[0];
            }
            case 96667762: {
                return new String[0];
            }
            case 1073584312: {
                return new String[]{"Signature"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Bundle.type");
        }
        if (name.equals(SP_TIMESTAMP)) {
            throw new FHIRException("Cannot call addChild on a singleton property Bundle.timestamp");
        }
        if (name.equals("total")) {
            throw new FHIRException("Cannot call addChild on a singleton property Bundle.total");
        }
        if (name.equals("link")) {
            return this.addLink();
        }
        if (name.equals("entry")) {
            return this.addEntry();
        }
        if (name.equals("signature")) {
            this.signature = new Signature();
            return this.signature;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Bundle";
    }

    @Override
    public Bundle copy() {
        Bundle dst = new Bundle();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Bundle dst) {
        super.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
        UnsignedIntType unsignedIntType = dst.total = this.total == null ? null : this.total.copy();
        if (this.link != null) {
            dst.link = new ArrayList<BundleLinkComponent>();
            for (BundleLinkComponent bundleLinkComponent : this.link) {
                dst.link.add(bundleLinkComponent.copy());
            }
        }
        if (this.entry != null) {
            dst.entry = new ArrayList<BundleEntryComponent>();
            for (BundleEntryComponent bundleEntryComponent : this.entry) {
                dst.entry.add(bundleEntryComponent.copy());
            }
        }
        dst.signature = this.signature == null ? null : this.signature.copy();
    }

    protected Bundle typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Bundle)) {
            return false;
        }
        Bundle o = (Bundle)other_;
        return Bundle.compareDeep(this.identifier, o.identifier, true) && Bundle.compareDeep(this.type, o.type, true) && Bundle.compareDeep(this.timestamp, o.timestamp, true) && Bundle.compareDeep(this.total, o.total, true) && Bundle.compareDeep(this.link, o.link, true) && Bundle.compareDeep(this.entry, o.entry, true) && Bundle.compareDeep(this.signature, o.signature, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Bundle)) {
            return false;
        }
        Bundle o = (Bundle)other_;
        return Bundle.compareValues(this.type, o.type, true) && Bundle.compareValues(this.timestamp, o.timestamp, true) && Bundle.compareValues(this.total, o.total, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.type, this.timestamp, this.total, this.link, this.entry, this.signature});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Bundle;
    }

    @Block
    public static class BundleEntryResponseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Status response code (text optional)", formalDefinition="The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.")
        protected StringType status;
        @Child(name="location", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The location (if the operation returns a location)", formalDefinition="The location header created by processing this operation, populated if the operation returns a location.")
        protected UriType location;
        @Child(name="etag", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The Etag for the resource (if relevant)", formalDefinition="The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).")
        protected StringType etag;
        @Child(name="lastModified", type={InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Server's date time modified", formalDefinition="The date/time that the resource was modified on the server.")
        protected InstantType lastModified;
        @Child(name="outcome", type={Resource.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="OperationOutcome with hints and warnings (for batch/transaction)", formalDefinition="An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.")
        protected Resource outcome;
        private static final long serialVersionUID = 923278008L;

        public BundleEntryResponseComponent() {
        }

        public BundleEntryResponseComponent(StringType status) {
            this.status = status;
        }

        public StringType getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new StringType();
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public BundleEntryResponseComponent setStatusElement(StringType value) {
            this.status = value;
            return this;
        }

        public String getStatus() {
            return this.status == null ? null : (String)this.status.getValue();
        }

        public BundleEntryResponseComponent setStatus(String value) {
            if (this.status == null) {
                this.status = new StringType();
            }
            this.status.setValue(value);
            return this;
        }

        public UriType getLocationElement() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new UriType();
                }
            }
            return this.location;
        }

        public boolean hasLocationElement() {
            return this.location != null && !this.location.isEmpty();
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public BundleEntryResponseComponent setLocationElement(UriType value) {
            this.location = value;
            return this;
        }

        public String getLocation() {
            return this.location == null ? null : (String)this.location.getValue();
        }

        public BundleEntryResponseComponent setLocation(String value) {
            if (Utilities.noString((String)value)) {
                this.location = null;
            } else {
                if (this.location == null) {
                    this.location = new UriType();
                }
                this.location.setValue(value);
            }
            return this;
        }

        public StringType getEtagElement() {
            if (this.etag == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.etag");
                }
                if (Configuration.doAutoCreate()) {
                    this.etag = new StringType();
                }
            }
            return this.etag;
        }

        public boolean hasEtagElement() {
            return this.etag != null && !this.etag.isEmpty();
        }

        public boolean hasEtag() {
            return this.etag != null && !this.etag.isEmpty();
        }

        public BundleEntryResponseComponent setEtagElement(StringType value) {
            this.etag = value;
            return this;
        }

        public String getEtag() {
            return this.etag == null ? null : (String)this.etag.getValue();
        }

        public BundleEntryResponseComponent setEtag(String value) {
            if (Utilities.noString((String)value)) {
                this.etag = null;
            } else {
                if (this.etag == null) {
                    this.etag = new StringType();
                }
                this.etag.setValue(value);
            }
            return this;
        }

        public InstantType getLastModifiedElement() {
            if (this.lastModified == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryResponseComponent.lastModified");
                }
                if (Configuration.doAutoCreate()) {
                    this.lastModified = new InstantType();
                }
            }
            return this.lastModified;
        }

        public boolean hasLastModifiedElement() {
            return this.lastModified != null && !this.lastModified.isEmpty();
        }

        public boolean hasLastModified() {
            return this.lastModified != null && !this.lastModified.isEmpty();
        }

        public BundleEntryResponseComponent setLastModifiedElement(InstantType value) {
            this.lastModified = value;
            return this;
        }

        public Date getLastModified() {
            return this.lastModified == null ? null : (Date)this.lastModified.getValue();
        }

        public BundleEntryResponseComponent setLastModified(Date value) {
            if (value == null) {
                this.lastModified = null;
            } else {
                if (this.lastModified == null) {
                    this.lastModified = new InstantType();
                }
                this.lastModified.setValue(value);
            }
            return this;
        }

        public Resource getOutcome() {
            return this.outcome;
        }

        public boolean hasOutcome() {
            return this.outcome != null && !this.outcome.isEmpty();
        }

        public BundleEntryResponseComponent setOutcome(Resource value) {
            this.outcome = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("status", "string", "The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.", 0, 1, this.status));
            children.add(new Property("location", "uri", "The location header created by processing this operation, populated if the operation returns a location.", 0, 1, this.location));
            children.add(new Property("etag", "string", "The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).", 0, 1, this.etag));
            children.add(new Property("lastModified", "instant", "The date/time that the resource was modified on the server.", 0, 1, this.lastModified));
            children.add(new Property("outcome", "Resource", "An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.", 0, 1, this.outcome));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property("status", "string", "The status code returned by processing this entry. The status SHALL start with a 3 digit HTTP code (e.g. 404) and may contain the standard HTTP description associated with the status code.", 0, 1, this.status);
                }
                case 1901043637: {
                    return new Property("location", "uri", "The location header created by processing this operation, populated if the operation returns a location.", 0, 1, this.location);
                }
                case 3123477: {
                    return new Property("etag", "string", "The Etag for the resource, if the operation for the entry produced a versioned resource (see [Resource Metadata and Versioning](http.html#versioning) and [Managing Resource Contention](http.html#concurrency)).", 0, 1, this.etag);
                }
                case 1959003007: {
                    return new Property("lastModified", "instant", "The date/time that the resource was modified on the server.", 0, 1, this.lastModified);
                }
                case -1106507950: {
                    return new Property("outcome", "Resource", "An OperationOutcome containing hints and warnings produced as part of processing this entry in a batch or transaction.", 0, 1, this.outcome);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.location;
                    }
                    return baseArray;
                }
                case 3123477: {
                    Base[] baseArray;
                    if (this.etag == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.etag;
                    }
                    return baseArray;
                }
                case 1959003007: {
                    Base[] baseArray;
                    if (this.lastModified == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.lastModified;
                    }
                    return baseArray;
                }
                case -1106507950: {
                    Base[] baseArray;
                    if (this.outcome == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.outcome;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    this.status = this.castToString(value);
                    return value;
                }
                case 1901043637: {
                    this.location = this.castToUri(value);
                    return value;
                }
                case 3123477: {
                    this.etag = this.castToString(value);
                    return value;
                }
                case 1959003007: {
                    this.lastModified = this.castToInstant(value);
                    return value;
                }
                case -1106507950: {
                    this.outcome = this.castToResource(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("status")) {
                this.status = this.castToString(value);
            } else if (name.equals("location")) {
                this.location = this.castToUri(value);
            } else if (name.equals("etag")) {
                this.etag = this.castToString(value);
            } else if (name.equals("lastModified")) {
                this.lastModified = this.castToInstant(value);
            } else if (name.equals("outcome")) {
                this.outcome = this.castToResource(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("status")) {
                this.status = null;
            } else if (name.equals("location")) {
                this.location = null;
            } else if (name.equals("etag")) {
                this.etag = null;
            } else if (name.equals("lastModified")) {
                this.lastModified = null;
            } else if (name.equals("outcome")) {
                this.outcome = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatusElement();
                }
                case 1901043637: {
                    return this.getLocationElement();
                }
                case 3123477: {
                    return this.getEtagElement();
                }
                case 1959003007: {
                    return this.getLastModifiedElement();
                }
                case -1106507950: {
                    throw new FHIRException("Cannot make property outcome as it is not a complex type");
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"string"};
                }
                case 1901043637: {
                    return new String[]{"uri"};
                }
                case 3123477: {
                    return new String[]{"string"};
                }
                case 1959003007: {
                    return new String[]{"instant"};
                }
                case -1106507950: {
                    return new String[]{"Resource"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("status")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.status");
            }
            if (name.equals("location")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.location");
            }
            if (name.equals("etag")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.etag");
            }
            if (name.equals("lastModified")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.lastModified");
            }
            if (name.equals("outcome")) {
                throw new FHIRException("Cannot call addChild on an abstract type Bundle.outcome");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryResponseComponent copy() {
            BundleEntryResponseComponent dst = new BundleEntryResponseComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntryResponseComponent dst) {
            super.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.location = this.location == null ? null : this.location.copy();
            dst.etag = this.etag == null ? null : this.etag.copy();
            dst.lastModified = this.lastModified == null ? null : this.lastModified.copy();
            dst.outcome = this.outcome == null ? null : this.outcome.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryResponseComponent)) {
                return false;
            }
            BundleEntryResponseComponent o = (BundleEntryResponseComponent)other_;
            return BundleEntryResponseComponent.compareDeep(this.status, o.status, true) && BundleEntryResponseComponent.compareDeep(this.location, o.location, true) && BundleEntryResponseComponent.compareDeep(this.etag, o.etag, true) && BundleEntryResponseComponent.compareDeep(this.lastModified, o.lastModified, true) && BundleEntryResponseComponent.compareDeep(this.outcome, o.outcome, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryResponseComponent)) {
                return false;
            }
            BundleEntryResponseComponent o = (BundleEntryResponseComponent)other_;
            return BundleEntryResponseComponent.compareValues(this.status, o.status, true) && BundleEntryResponseComponent.compareValues(this.location, o.location, true) && BundleEntryResponseComponent.compareValues(this.etag, o.etag, true) && BundleEntryResponseComponent.compareValues(this.lastModified, o.lastModified, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.status, this.location, this.etag, this.lastModified, this.outcome});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.response";
        }
    }

    @Block
    public static class BundleEntryRequestComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="method", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="GET | HEAD | POST | PUT | DELETE | PATCH", formalDefinition="In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/http-verb")
        protected Enumeration<HTTPVerb> method;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URL for HTTP equivalent of this entry", formalDefinition="The URL for this entry, relative to the root (the address to which the request is posted).")
        protected UriType url;
        @Child(name="ifNoneMatch", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing cache currency", formalDefinition="If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).")
        protected StringType ifNoneMatch;
        @Child(name="ifModifiedSince", type={InstantType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing cache currency", formalDefinition="Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).")
        protected InstantType ifModifiedSince;
        @Child(name="ifMatch", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For managing update contention", formalDefinition="Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).")
        protected StringType ifMatch;
        @Child(name="ifNoneExist", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="For conditional creates", formalDefinition="Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").")
        protected StringType ifNoneExist;
        private static final long serialVersionUID = -1349769744L;

        public BundleEntryRequestComponent() {
        }

        public BundleEntryRequestComponent(Enumeration<HTTPVerb> method, UriType url) {
            this.method = method;
            this.url = url;
        }

        public Enumeration<HTTPVerb> getMethodElement() {
            if (this.method == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.method");
                }
                if (Configuration.doAutoCreate()) {
                    this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory());
                }
            }
            return this.method;
        }

        public boolean hasMethodElement() {
            return this.method != null && !this.method.isEmpty();
        }

        public boolean hasMethod() {
            return this.method != null && !this.method.isEmpty();
        }

        public BundleEntryRequestComponent setMethodElement(Enumeration<HTTPVerb> value) {
            this.method = value;
            return this;
        }

        public HTTPVerb getMethod() {
            return this.method == null ? null : (HTTPVerb)((Object)this.method.getValue());
        }

        public BundleEntryRequestComponent setMethod(HTTPVerb value) {
            if (this.method == null) {
                this.method = new Enumeration<HTTPVerb>(new HTTPVerbEnumFactory());
            }
            this.method.setValue((Object)value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public BundleEntryRequestComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public BundleEntryRequestComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        public StringType getIfNoneMatchElement() {
            if (this.ifNoneMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifNoneMatch = new StringType();
                }
            }
            return this.ifNoneMatch;
        }

        public boolean hasIfNoneMatchElement() {
            return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        public boolean hasIfNoneMatch() {
            return this.ifNoneMatch != null && !this.ifNoneMatch.isEmpty();
        }

        public BundleEntryRequestComponent setIfNoneMatchElement(StringType value) {
            this.ifNoneMatch = value;
            return this;
        }

        public String getIfNoneMatch() {
            return this.ifNoneMatch == null ? null : (String)this.ifNoneMatch.getValue();
        }

        public BundleEntryRequestComponent setIfNoneMatch(String value) {
            if (Utilities.noString((String)value)) {
                this.ifNoneMatch = null;
            } else {
                if (this.ifNoneMatch == null) {
                    this.ifNoneMatch = new StringType();
                }
                this.ifNoneMatch.setValue(value);
            }
            return this;
        }

        public InstantType getIfModifiedSinceElement() {
            if (this.ifModifiedSince == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifModifiedSince");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifModifiedSince = new InstantType();
                }
            }
            return this.ifModifiedSince;
        }

        public boolean hasIfModifiedSinceElement() {
            return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        public boolean hasIfModifiedSince() {
            return this.ifModifiedSince != null && !this.ifModifiedSince.isEmpty();
        }

        public BundleEntryRequestComponent setIfModifiedSinceElement(InstantType value) {
            this.ifModifiedSince = value;
            return this;
        }

        public Date getIfModifiedSince() {
            return this.ifModifiedSince == null ? null : (Date)this.ifModifiedSince.getValue();
        }

        public BundleEntryRequestComponent setIfModifiedSince(Date value) {
            if (value == null) {
                this.ifModifiedSince = null;
            } else {
                if (this.ifModifiedSince == null) {
                    this.ifModifiedSince = new InstantType();
                }
                this.ifModifiedSince.setValue(value);
            }
            return this;
        }

        public StringType getIfMatchElement() {
            if (this.ifMatch == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifMatch");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifMatch = new StringType();
                }
            }
            return this.ifMatch;
        }

        public boolean hasIfMatchElement() {
            return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        public boolean hasIfMatch() {
            return this.ifMatch != null && !this.ifMatch.isEmpty();
        }

        public BundleEntryRequestComponent setIfMatchElement(StringType value) {
            this.ifMatch = value;
            return this;
        }

        public String getIfMatch() {
            return this.ifMatch == null ? null : (String)this.ifMatch.getValue();
        }

        public BundleEntryRequestComponent setIfMatch(String value) {
            if (Utilities.noString((String)value)) {
                this.ifMatch = null;
            } else {
                if (this.ifMatch == null) {
                    this.ifMatch = new StringType();
                }
                this.ifMatch.setValue(value);
            }
            return this;
        }

        public StringType getIfNoneExistElement() {
            if (this.ifNoneExist == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryRequestComponent.ifNoneExist");
                }
                if (Configuration.doAutoCreate()) {
                    this.ifNoneExist = new StringType();
                }
            }
            return this.ifNoneExist;
        }

        public boolean hasIfNoneExistElement() {
            return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        public boolean hasIfNoneExist() {
            return this.ifNoneExist != null && !this.ifNoneExist.isEmpty();
        }

        public BundleEntryRequestComponent setIfNoneExistElement(StringType value) {
            this.ifNoneExist = value;
            return this;
        }

        public String getIfNoneExist() {
            return this.ifNoneExist == null ? null : (String)this.ifNoneExist.getValue();
        }

        public BundleEntryRequestComponent setIfNoneExist(String value) {
            if (Utilities.noString((String)value)) {
                this.ifNoneExist = null;
            } else {
                if (this.ifNoneExist == null) {
                    this.ifNoneExist = new StringType();
                }
                this.ifNoneExist.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("method", "code", "In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.", 0, 1, this.method));
            children.add(new Property("url", "uri", "The URL for this entry, relative to the root (the address to which the request is posted).", 0, 1, this.url));
            children.add(new Property("ifNoneMatch", "string", "If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifNoneMatch));
            children.add(new Property("ifModifiedSince", "instant", "Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifModifiedSince));
            children.add(new Property("ifMatch", "string", "Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).", 0, 1, this.ifMatch));
            children.add(new Property("ifNoneExist", "string", "Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").", 0, 1, this.ifNoneExist));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1077554975: {
                    return new Property("method", "code", "In a transaction or batch, this is the HTTP action to be executed for this entry. In a history bundle, this indicates the HTTP action that occurred.", 0, 1, this.method);
                }
                case 116079: {
                    return new Property("url", "uri", "The URL for this entry, relative to the root (the address to which the request is posted).", 0, 1, this.url);
                }
                case 171868368: {
                    return new Property("ifNoneMatch", "string", "If the ETag values match, return a 304 Not Modified status. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifNoneMatch);
                }
                case -2061602860: {
                    return new Property("ifModifiedSince", "instant", "Only perform the operation if the last updated date matches. See the API documentation for [\"Conditional Read\"](http.html#cread).", 0, 1, this.ifModifiedSince);
                }
                case 1692894888: {
                    return new Property("ifMatch", "string", "Only perform the operation if the Etag value matches. For more information, see the API section [\"Managing Resource Contention\"](http.html#concurrency).", 0, 1, this.ifMatch);
                }
                case 165155330: {
                    return new Property("ifNoneExist", "string", "Instruct the server not to perform the create if a specified resource already exists. For further information, see the API documentation for [\"Conditional Create\"](http.html#ccreate). This is just the query portion of the URL - what follows the \"?\" (not including the \"?\").", 0, 1, this.ifNoneExist);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    Base[] baseArray;
                    if (this.method == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.method;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
                case 171868368: {
                    Base[] baseArray;
                    if (this.ifNoneMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.ifNoneMatch;
                    }
                    return baseArray;
                }
                case -2061602860: {
                    Base[] baseArray;
                    if (this.ifModifiedSince == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.ifModifiedSince;
                    }
                    return baseArray;
                }
                case 1692894888: {
                    Base[] baseArray;
                    if (this.ifMatch == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.ifMatch;
                    }
                    return baseArray;
                }
                case 165155330: {
                    Base[] baseArray;
                    if (this.ifNoneExist == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.ifNoneExist;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    value = new HTTPVerbEnumFactory().fromType(this.castToCode(value));
                    this.method = value;
                    return value;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    return value;
                }
                case 171868368: {
                    this.ifNoneMatch = this.castToString(value);
                    return value;
                }
                case -2061602860: {
                    this.ifModifiedSince = this.castToInstant(value);
                    return value;
                }
                case 1692894888: {
                    this.ifMatch = this.castToString(value);
                    return value;
                }
                case 165155330: {
                    this.ifNoneExist = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("method")) {
                value = new HTTPVerbEnumFactory().fromType(this.castToCode(value));
                this.method = value;
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("ifNoneMatch")) {
                this.ifNoneMatch = this.castToString(value);
            } else if (name.equals("ifModifiedSince")) {
                this.ifModifiedSince = this.castToInstant(value);
            } else if (name.equals("ifMatch")) {
                this.ifMatch = this.castToString(value);
            } else if (name.equals("ifNoneExist")) {
                this.ifNoneExist = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("method")) {
                this.method = null;
            } else if (name.equals("url")) {
                this.url = null;
            } else if (name.equals("ifNoneMatch")) {
                this.ifNoneMatch = null;
            } else if (name.equals("ifModifiedSince")) {
                this.ifModifiedSince = null;
            } else if (name.equals("ifMatch")) {
                this.ifMatch = null;
            } else if (name.equals("ifNoneExist")) {
                this.ifNoneExist = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return this.getMethodElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
                case 171868368: {
                    return this.getIfNoneMatchElement();
                }
                case -2061602860: {
                    return this.getIfModifiedSinceElement();
                }
                case 1692894888: {
                    return this.getIfMatchElement();
                }
                case 165155330: {
                    return this.getIfNoneExistElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1077554975: {
                    return new String[]{"code"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
                case 171868368: {
                    return new String[]{"string"};
                }
                case -2061602860: {
                    return new String[]{"instant"};
                }
                case 1692894888: {
                    return new String[]{"string"};
                }
                case 165155330: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("method")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.method");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.url");
            }
            if (name.equals("ifNoneMatch")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.ifNoneMatch");
            }
            if (name.equals("ifModifiedSince")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.ifModifiedSince");
            }
            if (name.equals("ifMatch")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.ifMatch");
            }
            if (name.equals("ifNoneExist")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.ifNoneExist");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryRequestComponent copy() {
            BundleEntryRequestComponent dst = new BundleEntryRequestComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntryRequestComponent dst) {
            super.copyValues(dst);
            dst.method = this.method == null ? null : this.method.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.ifNoneMatch = this.ifNoneMatch == null ? null : this.ifNoneMatch.copy();
            dst.ifModifiedSince = this.ifModifiedSince == null ? null : this.ifModifiedSince.copy();
            dst.ifMatch = this.ifMatch == null ? null : this.ifMatch.copy();
            dst.ifNoneExist = this.ifNoneExist == null ? null : this.ifNoneExist.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryRequestComponent)) {
                return false;
            }
            BundleEntryRequestComponent o = (BundleEntryRequestComponent)other_;
            return BundleEntryRequestComponent.compareDeep(this.method, o.method, true) && BundleEntryRequestComponent.compareDeep(this.url, o.url, true) && BundleEntryRequestComponent.compareDeep(this.ifNoneMatch, o.ifNoneMatch, true) && BundleEntryRequestComponent.compareDeep(this.ifModifiedSince, o.ifModifiedSince, true) && BundleEntryRequestComponent.compareDeep(this.ifMatch, o.ifMatch, true) && BundleEntryRequestComponent.compareDeep(this.ifNoneExist, o.ifNoneExist, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryRequestComponent)) {
                return false;
            }
            BundleEntryRequestComponent o = (BundleEntryRequestComponent)other_;
            return BundleEntryRequestComponent.compareValues(this.method, o.method, true) && BundleEntryRequestComponent.compareValues(this.url, o.url, true) && BundleEntryRequestComponent.compareValues(this.ifNoneMatch, o.ifNoneMatch, true) && BundleEntryRequestComponent.compareValues(this.ifModifiedSince, o.ifModifiedSince, true) && BundleEntryRequestComponent.compareValues(this.ifMatch, o.ifMatch, true) && BundleEntryRequestComponent.compareValues(this.ifNoneExist, o.ifNoneExist, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.method, this.url, this.ifNoneMatch, this.ifModifiedSince, this.ifMatch, this.ifNoneExist});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.request";
        }
    }

    @Block
    public static class BundleEntrySearchComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="mode", type={CodeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="match | include | outcome - why this is in the result set", formalDefinition="Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-entry-mode")
        protected Enumeration<SearchEntryMode> mode;
        @Child(name="score", type={DecimalType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search ranking (between 0 and 1)", formalDefinition="When searching, the server's search ranking score for the entry.")
        protected DecimalType score;
        private static final long serialVersionUID = 837739866L;

        public Enumeration<SearchEntryMode> getModeElement() {
            if (this.mode == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntrySearchComponent.mode");
                }
                if (Configuration.doAutoCreate()) {
                    this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory());
                }
            }
            return this.mode;
        }

        public boolean hasModeElement() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public boolean hasMode() {
            return this.mode != null && !this.mode.isEmpty();
        }

        public BundleEntrySearchComponent setModeElement(Enumeration<SearchEntryMode> value) {
            this.mode = value;
            return this;
        }

        public SearchEntryMode getMode() {
            return this.mode == null ? null : (SearchEntryMode)((Object)this.mode.getValue());
        }

        public BundleEntrySearchComponent setMode(SearchEntryMode value) {
            if (value == null) {
                this.mode = null;
            } else {
                if (this.mode == null) {
                    this.mode = new Enumeration<SearchEntryMode>(new SearchEntryModeEnumFactory());
                }
                this.mode.setValue((Object)value);
            }
            return this;
        }

        public DecimalType getScoreElement() {
            if (this.score == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntrySearchComponent.score");
                }
                if (Configuration.doAutoCreate()) {
                    this.score = new DecimalType();
                }
            }
            return this.score;
        }

        public boolean hasScoreElement() {
            return this.score != null && !this.score.isEmpty();
        }

        public boolean hasScore() {
            return this.score != null && !this.score.isEmpty();
        }

        public BundleEntrySearchComponent setScoreElement(DecimalType value) {
            this.score = value;
            return this;
        }

        public BigDecimal getScore() {
            return this.score == null ? null : (BigDecimal)this.score.getValue();
        }

        public BundleEntrySearchComponent setScore(BigDecimal value) {
            if (value == null) {
                this.score = null;
            } else {
                if (this.score == null) {
                    this.score = new DecimalType();
                }
                this.score.setValue(value);
            }
            return this;
        }

        public BundleEntrySearchComponent setScore(long value) {
            this.score = new DecimalType();
            this.score.setValue(value);
            return this;
        }

        public BundleEntrySearchComponent setScore(double value) {
            this.score = new DecimalType();
            this.score.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("mode", "code", "Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.", 0, 1, this.mode));
            children.add(new Property("score", "decimal", "When searching, the server's search ranking score for the entry.", 0, 1, this.score));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 0x3339A3: {
                    return new Property("mode", "code", "Why this entry is in the result set - whether it's included as a match or because of an _include requirement, or to convey information or warning information about the search process.", 0, 1, this.mode);
                }
                case 109264530: {
                    return new Property("score", "decimal", "When searching, the server's search ranking score for the entry.", 0, 1, this.score);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    Base[] baseArray;
                    if (this.mode == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.mode;
                    }
                    return baseArray;
                }
                case 109264530: {
                    Base[] baseArray;
                    if (this.score == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.score;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    value = new SearchEntryModeEnumFactory().fromType(this.castToCode(value));
                    this.mode = value;
                    return value;
                }
                case 109264530: {
                    this.score = this.castToDecimal(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                value = new SearchEntryModeEnumFactory().fromType(this.castToCode(value));
                this.mode = value;
            } else if (name.equals("score")) {
                this.score = this.castToDecimal(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("mode")) {
                this.mode = null;
            } else if (name.equals("score")) {
                this.score = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return this.getModeElement();
                }
                case 109264530: {
                    return this.getScoreElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 0x3339A3: {
                    return new String[]{"code"};
                }
                case 109264530: {
                    return new String[]{"decimal"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("mode")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.mode");
            }
            if (name.equals("score")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.score");
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntrySearchComponent copy() {
            BundleEntrySearchComponent dst = new BundleEntrySearchComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntrySearchComponent dst) {
            super.copyValues(dst);
            dst.mode = this.mode == null ? null : this.mode.copy();
            dst.score = this.score == null ? null : this.score.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntrySearchComponent)) {
                return false;
            }
            BundleEntrySearchComponent o = (BundleEntrySearchComponent)other_;
            return BundleEntrySearchComponent.compareDeep(this.mode, o.mode, true) && BundleEntrySearchComponent.compareDeep(this.score, o.score, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntrySearchComponent)) {
                return false;
            }
            BundleEntrySearchComponent o = (BundleEntrySearchComponent)other_;
            return BundleEntrySearchComponent.compareValues(this.mode, o.mode, true) && BundleEntrySearchComponent.compareValues(this.score, o.score, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mode, this.score});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry.search";
        }
    }

    @Block
    public static class BundleEntryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="link", type={BundleLinkComponent.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Links related to this entry", formalDefinition="A series of links that provide context to this entry.")
        protected List<BundleLinkComponent> link;
        @Child(name="fullUrl", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="URI for resource (Absolute URL server address or URI for UUID/OID)", formalDefinition="The Absolute URL for the resource.  The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. The fullUrl element SHALL have a value except that: \n* fullUrl can be empty on a POST (although it does not need to when specifying a temporary id for reference in the bundle)\n* Results from operations might involve resources that are not identified.")
        protected UriType fullUrl;
        @Child(name="resource", type={Resource.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A resource in the bundle", formalDefinition="The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type.")
        protected Resource resource;
        @Child(name="search", type={}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Search related information", formalDefinition="Information about the search process that lead to the creation of this entry.")
        protected BundleEntrySearchComponent search;
        @Child(name="request", type={}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Additional execution information (transaction/batch/history)", formalDefinition="Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.")
        protected BundleEntryRequestComponent request;
        @Child(name="response", type={}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Results of execution (transaction/batch/history)", formalDefinition="Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.")
        protected BundleEntryResponseComponent response;
        private static final long serialVersionUID = 517783054L;

        public List<BundleLinkComponent> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            return this.link;
        }

        public BundleEntryComponent setLink(List<BundleLinkComponent> theLink) {
            this.link = theLink;
            return this;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (BundleLinkComponent item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public BundleLinkComponent addLink() {
            BundleLinkComponent t = new BundleLinkComponent();
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            this.link.add(t);
            return t;
        }

        public BundleEntryComponent addLink(BundleLinkComponent t) {
            if (t == null) {
                return this;
            }
            if (this.link == null) {
                this.link = new ArrayList<BundleLinkComponent>();
            }
            this.link.add(t);
            return this;
        }

        public BundleLinkComponent getLinkFirstRep() {
            if (this.getLink().isEmpty()) {
                this.addLink();
            }
            return this.getLink().get(0);
        }

        public UriType getFullUrlElement() {
            if (this.fullUrl == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.fullUrl");
                }
                if (Configuration.doAutoCreate()) {
                    this.fullUrl = new UriType();
                }
            }
            return this.fullUrl;
        }

        public boolean hasFullUrlElement() {
            return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        public boolean hasFullUrl() {
            return this.fullUrl != null && !this.fullUrl.isEmpty();
        }

        public BundleEntryComponent setFullUrlElement(UriType value) {
            this.fullUrl = value;
            return this;
        }

        public String getFullUrl() {
            return this.fullUrl == null ? null : (String)this.fullUrl.getValue();
        }

        public BundleEntryComponent setFullUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.fullUrl = null;
            } else {
                if (this.fullUrl == null) {
                    this.fullUrl = new UriType();
                }
                this.fullUrl.setValue(value);
            }
            return this;
        }

        public Resource getResource() {
            return this.resource;
        }

        public boolean hasResource() {
            return this.resource != null && !this.resource.isEmpty();
        }

        public BundleEntryComponent setResource(Resource value) {
            this.resource = value;
            return this;
        }

        public BundleEntrySearchComponent getSearch() {
            if (this.search == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.search");
                }
                if (Configuration.doAutoCreate()) {
                    this.search = new BundleEntrySearchComponent();
                }
            }
            return this.search;
        }

        public boolean hasSearch() {
            return this.search != null && !this.search.isEmpty();
        }

        public BundleEntryComponent setSearch(BundleEntrySearchComponent value) {
            this.search = value;
            return this;
        }

        public BundleEntryRequestComponent getRequest() {
            if (this.request == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.request");
                }
                if (Configuration.doAutoCreate()) {
                    this.request = new BundleEntryRequestComponent();
                }
            }
            return this.request;
        }

        public boolean hasRequest() {
            return this.request != null && !this.request.isEmpty();
        }

        public BundleEntryComponent setRequest(BundleEntryRequestComponent value) {
            this.request = value;
            return this;
        }

        public BundleEntryResponseComponent getResponse() {
            if (this.response == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleEntryComponent.response");
                }
                if (Configuration.doAutoCreate()) {
                    this.response = new BundleEntryResponseComponent();
                }
            }
            return this.response;
        }

        public boolean hasResponse() {
            return this.response != null && !this.response.isEmpty();
        }

        public BundleEntryComponent setResponse(BundleEntryResponseComponent value) {
            this.response = value;
            return this;
        }

        public BundleLinkComponent getLink(String theRelation) {
            Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
            for (BundleLinkComponent next : this.getLink()) {
                if (!theRelation.equals(next.getRelation())) continue;
                return next;
            }
            return null;
        }

        public BundleLinkComponent getLinkOrCreate(String theRelation) {
            Validate.notBlank((CharSequence)theRelation, (String)"theRelation may not be null or empty", (Object[])new Object[0]);
            for (BundleLinkComponent next : this.getLink()) {
                if (!theRelation.equals(next.getRelation())) continue;
                return next;
            }
            BundleLinkComponent retVal = new BundleLinkComponent();
            retVal.setRelation(theRelation);
            this.getLink().add(retVal);
            return retVal;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("link", "@Bundle.link", "A series of links that provide context to this entry.", 0, Integer.MAX_VALUE, this.link));
            children.add(new Property("fullUrl", "uri", "The Absolute URL for the resource.  The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. The fullUrl element SHALL have a value except that: \n* fullUrl can be empty on a POST (although it does not need to when specifying a temporary id for reference in the bundle)\n* Results from operations might involve resources that are not identified.", 0, 1, this.fullUrl));
            children.add(new Property("resource", "Resource", "The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type.", 0, 1, this.resource));
            children.add(new Property("search", "", "Information about the search process that lead to the creation of this entry.", 0, 1, this.search));
            children.add(new Property("request", "", "Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.", 0, 1, this.request));
            children.add(new Property("response", "", "Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.", 0, 1, this.response));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3321850: {
                    return new Property("link", "@Bundle.link", "A series of links that provide context to this entry.", 0, Integer.MAX_VALUE, this.link);
                }
                case -511251360: {
                    return new Property("fullUrl", "uri", "The Absolute URL for the resource.  The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. The fullUrl element SHALL have a value except that: \n* fullUrl can be empty on a POST (although it does not need to when specifying a temporary id for reference in the bundle)\n* Results from operations might involve resources that are not identified.", 0, 1, this.fullUrl);
                }
                case -341064690: {
                    return new Property("resource", "Resource", "The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type.", 0, 1, this.resource);
                }
                case -906336856: {
                    return new Property("search", "", "Information about the search process that lead to the creation of this entry.", 0, 1, this.search);
                }
                case 1095692943: {
                    return new Property("request", "", "Additional information about how this entry should be processed as part of a transaction or batch.  For history, it shows how the entry was processed to create the version contained in the entry.", 0, 1, this.request);
                }
                case -340323263: {
                    return new Property("response", "", "Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.", 0, 1, this.response);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
                case -511251360: {
                    Base[] baseArray;
                    if (this.fullUrl == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.fullUrl;
                    }
                    return baseArray;
                }
                case -341064690: {
                    Base[] baseArray;
                    if (this.resource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.resource;
                    }
                    return baseArray;
                }
                case -906336856: {
                    Base[] baseArray;
                    if (this.search == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.search;
                    }
                    return baseArray;
                }
                case 1095692943: {
                    Base[] baseArray;
                    if (this.request == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.request;
                    }
                    return baseArray;
                }
                case -340323263: {
                    Base[] baseArray;
                    if (this.response == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.response;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    this.getLink().add((BundleLinkComponent)value);
                    return value;
                }
                case -511251360: {
                    this.fullUrl = this.castToUri(value);
                    return value;
                }
                case -341064690: {
                    this.resource = this.castToResource(value);
                    return value;
                }
                case -906336856: {
                    this.search = (BundleEntrySearchComponent)value;
                    return value;
                }
                case 1095692943: {
                    this.request = (BundleEntryRequestComponent)value;
                    return value;
                }
                case -340323263: {
                    this.response = (BundleEntryResponseComponent)value;
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("link")) {
                this.getLink().add((BundleLinkComponent)value);
            } else if (name.equals("fullUrl")) {
                this.fullUrl = this.castToUri(value);
            } else if (name.equals("resource")) {
                this.resource = this.castToResource(value);
            } else if (name.equals("search")) {
                this.search = (BundleEntrySearchComponent)value;
            } else if (name.equals("request")) {
                this.request = (BundleEntryRequestComponent)value;
            } else if (name.equals("response")) {
                this.response = (BundleEntryResponseComponent)value;
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("link")) {
                this.getLink().remove((BundleLinkComponent)value);
            } else if (name.equals("fullUrl")) {
                this.fullUrl = null;
            } else if (name.equals("resource")) {
                this.resource = null;
            } else if (name.equals("search")) {
                this.search = (BundleEntrySearchComponent)value;
            } else if (name.equals("request")) {
                this.request = (BundleEntryRequestComponent)value;
            } else if (name.equals("response")) {
                this.response = (BundleEntryResponseComponent)value;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return this.addLink();
                }
                case -511251360: {
                    return this.getFullUrlElement();
                }
                case -341064690: {
                    throw new FHIRException("Cannot make property resource as it is not a complex type");
                }
                case -906336856: {
                    return this.getSearch();
                }
                case 1095692943: {
                    return this.getRequest();
                }
                case -340323263: {
                    return this.getResponse();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3321850: {
                    return new String[]{"@Bundle.link"};
                }
                case -511251360: {
                    return new String[]{"uri"};
                }
                case -341064690: {
                    return new String[]{"Resource"};
                }
                case -906336856: {
                    return new String[0];
                }
                case 1095692943: {
                    return new String[0];
                }
                case -340323263: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("link")) {
                return this.addLink();
            }
            if (name.equals("fullUrl")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.fullUrl");
            }
            if (name.equals("resource")) {
                throw new FHIRException("Cannot call addChild on an abstract type Bundle.resource");
            }
            if (name.equals("search")) {
                this.search = new BundleEntrySearchComponent();
                return this.search;
            }
            if (name.equals("request")) {
                this.request = new BundleEntryRequestComponent();
                return this.request;
            }
            if (name.equals("response")) {
                this.response = new BundleEntryResponseComponent();
                return this.response;
            }
            return super.addChild(name);
        }

        @Override
        public BundleEntryComponent copy() {
            BundleEntryComponent dst = new BundleEntryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleEntryComponent dst) {
            super.copyValues(dst);
            if (this.link != null) {
                dst.link = new ArrayList<BundleLinkComponent>();
                for (BundleLinkComponent i : this.link) {
                    dst.link.add(i.copy());
                }
            }
            dst.fullUrl = this.fullUrl == null ? null : this.fullUrl.copy();
            dst.resource = this.resource == null ? null : this.resource.copy();
            dst.search = this.search == null ? null : this.search.copy();
            dst.request = this.request == null ? null : this.request.copy();
            dst.response = this.response == null ? null : this.response.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryComponent)) {
                return false;
            }
            BundleEntryComponent o = (BundleEntryComponent)other_;
            return BundleEntryComponent.compareDeep(this.link, o.link, true) && BundleEntryComponent.compareDeep(this.fullUrl, o.fullUrl, true) && BundleEntryComponent.compareDeep(this.resource, o.resource, true) && BundleEntryComponent.compareDeep(this.search, o.search, true) && BundleEntryComponent.compareDeep(this.request, o.request, true) && BundleEntryComponent.compareDeep(this.response, o.response, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleEntryComponent)) {
                return false;
            }
            BundleEntryComponent o = (BundleEntryComponent)other_;
            return BundleEntryComponent.compareValues(this.fullUrl, o.fullUrl, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.link, this.fullUrl, this.resource, this.search, this.request, this.response});
        }

        @Override
        public String fhirType() {
            return "Bundle.entry";
        }
    }

    @Block
    public static class BundleLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relation", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="See http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1", formalDefinition="A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).")
        protected StringType relation;
        @Child(name="url", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference details for the link", formalDefinition="The reference details for the link.")
        protected UriType url;
        private static final long serialVersionUID = -1010386066L;

        public BundleLinkComponent() {
        }

        public BundleLinkComponent(StringType relation, UriType url) {
            this.relation = relation;
            this.url = url;
        }

        public StringType getRelationElement() {
            if (this.relation == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleLinkComponent.relation");
                }
                if (Configuration.doAutoCreate()) {
                    this.relation = new StringType();
                }
            }
            return this.relation;
        }

        public boolean hasRelationElement() {
            return this.relation != null && !this.relation.isEmpty();
        }

        public boolean hasRelation() {
            return this.relation != null && !this.relation.isEmpty();
        }

        public BundleLinkComponent setRelationElement(StringType value) {
            this.relation = value;
            return this;
        }

        public String getRelation() {
            return this.relation == null ? null : (String)this.relation.getValue();
        }

        public BundleLinkComponent setRelation(String value) {
            if (this.relation == null) {
                this.relation = new StringType();
            }
            this.relation.setValue(value);
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create BundleLinkComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public BundleLinkComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public BundleLinkComponent setUrl(String value) {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("relation", "string", "A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).", 0, 1, this.relation));
            children.add(new Property("url", "uri", "The reference details for the link.", 0, 1, this.url));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -554436100: {
                    return new Property("relation", "string", "A name which details the functional use for this link - see [http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1](http://www.iana.org/assignments/link-relations/link-relations.xhtml#link-relations-1).", 0, 1, this.relation);
                }
                case 116079: {
                    return new Property("url", "uri", "The reference details for the link.", 0, 1, this.url);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    Base[] baseArray;
                    if (this.relation == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.relation;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.url;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    this.relation = this.castToString(value);
                    return value;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relation")) {
                this.relation = this.castToString(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("relation")) {
                this.relation = null;
            } else if (name.equals("url")) {
                this.url = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    return this.getRelationElement();
                }
                case 116079: {
                    return this.getUrlElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -554436100: {
                    return new String[]{"string"};
                }
                case 116079: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relation")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.relation");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a singleton property Bundle.url");
            }
            return super.addChild(name);
        }

        @Override
        public BundleLinkComponent copy() {
            BundleLinkComponent dst = new BundleLinkComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(BundleLinkComponent dst) {
            super.copyValues(dst);
            dst.relation = this.relation == null ? null : this.relation.copy();
            dst.url = this.url == null ? null : this.url.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleLinkComponent)) {
                return false;
            }
            BundleLinkComponent o = (BundleLinkComponent)other_;
            return BundleLinkComponent.compareDeep(this.relation, o.relation, true) && BundleLinkComponent.compareDeep(this.url, o.url, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof BundleLinkComponent)) {
                return false;
            }
            BundleLinkComponent o = (BundleLinkComponent)other_;
            return BundleLinkComponent.compareValues(this.relation, o.relation, true) && BundleLinkComponent.compareValues(this.url, o.url, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.relation, this.url});
        }

        @Override
        public String fhirType() {
            return "Bundle.link";
        }
    }

    public static class HTTPVerbEnumFactory
    implements EnumFactory<HTTPVerb> {
        @Override
        public HTTPVerb fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return HTTPVerb.GET;
            }
            if ("HEAD".equals(codeString)) {
                return HTTPVerb.HEAD;
            }
            if ("POST".equals(codeString)) {
                return HTTPVerb.POST;
            }
            if ("PUT".equals(codeString)) {
                return HTTPVerb.PUT;
            }
            if ("DELETE".equals(codeString)) {
                return HTTPVerb.DELETE;
            }
            if ("PATCH".equals(codeString)) {
                return HTTPVerb.PATCH;
            }
            throw new IllegalArgumentException("Unknown HTTPVerb code '" + codeString + "'");
        }

        public Enumeration<HTTPVerb> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.NULL, code);
            }
            if ("GET".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.GET, code);
            }
            if ("HEAD".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.HEAD, code);
            }
            if ("POST".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.POST, code);
            }
            if ("PUT".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.PUT, code);
            }
            if ("DELETE".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.DELETE, code);
            }
            if ("PATCH".equals(codeString)) {
                return new Enumeration<HTTPVerb>(this, HTTPVerb.PATCH, code);
            }
            throw new FHIRException("Unknown HTTPVerb code '" + codeString + "'");
        }

        @Override
        public String toCode(HTTPVerb code) {
            if (code == HTTPVerb.GET) {
                return "GET";
            }
            if (code == HTTPVerb.HEAD) {
                return "HEAD";
            }
            if (code == HTTPVerb.POST) {
                return "POST";
            }
            if (code == HTTPVerb.PUT) {
                return "PUT";
            }
            if (code == HTTPVerb.DELETE) {
                return "DELETE";
            }
            if (code == HTTPVerb.PATCH) {
                return "PATCH";
            }
            return "?";
        }

        @Override
        public String toSystem(HTTPVerb code) {
            return code.getSystem();
        }
    }

    public static enum HTTPVerb {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        PATCH,
        NULL;


        public static HTTPVerb fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("GET".equals(codeString)) {
                return GET;
            }
            if ("HEAD".equals(codeString)) {
                return HEAD;
            }
            if ("POST".equals(codeString)) {
                return POST;
            }
            if ("PUT".equals(codeString)) {
                return PUT;
            }
            if ("DELETE".equals(codeString)) {
                return DELETE;
            }
            if ("PATCH".equals(codeString)) {
                return PATCH;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown HTTPVerb code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case GET: {
                    return "GET";
                }
                case HEAD: {
                    return "HEAD";
                }
                case POST: {
                    return "POST";
                }
                case PUT: {
                    return "PUT";
                }
                case DELETE: {
                    return "DELETE";
                }
                case PATCH: {
                    return "PATCH";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case GET: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case HEAD: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case POST: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case PUT: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case DELETE: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case PATCH: {
                    return "http://hl7.org/fhir/http-verb";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case GET: {
                    return "HTTP GET Command.";
                }
                case HEAD: {
                    return "HTTP HEAD Command.";
                }
                case POST: {
                    return "HTTP POST Command.";
                }
                case PUT: {
                    return "HTTP PUT Command.";
                }
                case DELETE: {
                    return "HTTP DELETE Command.";
                }
                case PATCH: {
                    return "HTTP PATCH Command.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case GET: {
                    return "GET";
                }
                case HEAD: {
                    return "HEAD";
                }
                case POST: {
                    return "POST";
                }
                case PUT: {
                    return "PUT";
                }
                case DELETE: {
                    return "DELETE";
                }
                case PATCH: {
                    return "PATCH";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class SearchEntryModeEnumFactory
    implements EnumFactory<SearchEntryMode> {
        @Override
        public SearchEntryMode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("match".equals(codeString)) {
                return SearchEntryMode.MATCH;
            }
            if ("include".equals(codeString)) {
                return SearchEntryMode.INCLUDE;
            }
            if ("outcome".equals(codeString)) {
                return SearchEntryMode.OUTCOME;
            }
            throw new IllegalArgumentException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        public Enumeration<SearchEntryMode> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.NULL, code);
            }
            if ("match".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.MATCH, code);
            }
            if ("include".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.INCLUDE, code);
            }
            if ("outcome".equals(codeString)) {
                return new Enumeration<SearchEntryMode>(this, SearchEntryMode.OUTCOME, code);
            }
            throw new FHIRException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchEntryMode code) {
            if (code == SearchEntryMode.MATCH) {
                return "match";
            }
            if (code == SearchEntryMode.INCLUDE) {
                return "include";
            }
            if (code == SearchEntryMode.OUTCOME) {
                return "outcome";
            }
            return "?";
        }

        @Override
        public String toSystem(SearchEntryMode code) {
            return code.getSystem();
        }
    }

    public static enum SearchEntryMode {
        MATCH,
        INCLUDE,
        OUTCOME,
        NULL;


        public static SearchEntryMode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("match".equals(codeString)) {
                return MATCH;
            }
            if ("include".equals(codeString)) {
                return INCLUDE;
            }
            if ("outcome".equals(codeString)) {
                return OUTCOME;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SearchEntryMode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MATCH: {
                    return "match";
                }
                case INCLUDE: {
                    return "include";
                }
                case OUTCOME: {
                    return "outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MATCH: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case INCLUDE: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case OUTCOME: {
                    return "http://hl7.org/fhir/search-entry-mode";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MATCH: {
                    return "This resource matched the search specification.";
                }
                case INCLUDE: {
                    return "This resource is returned because it is referred to from another resource in the search set.";
                }
                case OUTCOME: {
                    return "An OperationOutcome that provides additional information about the processing of a search.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MATCH: {
                    return "Match";
                }
                case INCLUDE: {
                    return "Include";
                }
                case OUTCOME: {
                    return "Outcome";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class BundleTypeEnumFactory
    implements EnumFactory<BundleType> {
        @Override
        public BundleType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("document".equals(codeString)) {
                return BundleType.DOCUMENT;
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return BundleType.MESSAGE;
            }
            if ("transaction".equals(codeString)) {
                return BundleType.TRANSACTION;
            }
            if ("transaction-response".equals(codeString)) {
                return BundleType.TRANSACTIONRESPONSE;
            }
            if ("batch".equals(codeString)) {
                return BundleType.BATCH;
            }
            if ("batch-response".equals(codeString)) {
                return BundleType.BATCHRESPONSE;
            }
            if ("history".equals(codeString)) {
                return BundleType.HISTORY;
            }
            if ("searchset".equals(codeString)) {
                return BundleType.SEARCHSET;
            }
            if ("collection".equals(codeString)) {
                return BundleType.COLLECTION;
            }
            throw new IllegalArgumentException("Unknown BundleType code '" + codeString + "'");
        }

        public Enumeration<BundleType> fromType(PrimitiveType<?> code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<BundleType>(this, BundleType.NULL, code);
            }
            String codeString = code.asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.NULL, code);
            }
            if ("document".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.DOCUMENT, code);
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.MESSAGE, code);
            }
            if ("transaction".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.TRANSACTION, code);
            }
            if ("transaction-response".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.TRANSACTIONRESPONSE, code);
            }
            if ("batch".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.BATCH, code);
            }
            if ("batch-response".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.BATCHRESPONSE, code);
            }
            if ("history".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.HISTORY, code);
            }
            if ("searchset".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.SEARCHSET, code);
            }
            if ("collection".equals(codeString)) {
                return new Enumeration<BundleType>(this, BundleType.COLLECTION, code);
            }
            throw new FHIRException("Unknown BundleType code '" + codeString + "'");
        }

        @Override
        public String toCode(BundleType code) {
            if (code == BundleType.DOCUMENT) {
                return "document";
            }
            if (code == BundleType.MESSAGE) {
                return Bundle.SP_MESSAGE;
            }
            if (code == BundleType.TRANSACTION) {
                return "transaction";
            }
            if (code == BundleType.TRANSACTIONRESPONSE) {
                return "transaction-response";
            }
            if (code == BundleType.BATCH) {
                return "batch";
            }
            if (code == BundleType.BATCHRESPONSE) {
                return "batch-response";
            }
            if (code == BundleType.HISTORY) {
                return "history";
            }
            if (code == BundleType.SEARCHSET) {
                return "searchset";
            }
            if (code == BundleType.COLLECTION) {
                return "collection";
            }
            return "?";
        }

        @Override
        public String toSystem(BundleType code) {
            return code.getSystem();
        }
    }

    public static enum BundleType {
        DOCUMENT,
        MESSAGE,
        TRANSACTION,
        TRANSACTIONRESPONSE,
        BATCH,
        BATCHRESPONSE,
        HISTORY,
        SEARCHSET,
        COLLECTION,
        NULL;


        public static BundleType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("document".equals(codeString)) {
                return DOCUMENT;
            }
            if (Bundle.SP_MESSAGE.equals(codeString)) {
                return MESSAGE;
            }
            if ("transaction".equals(codeString)) {
                return TRANSACTION;
            }
            if ("transaction-response".equals(codeString)) {
                return TRANSACTIONRESPONSE;
            }
            if ("batch".equals(codeString)) {
                return BATCH;
            }
            if ("batch-response".equals(codeString)) {
                return BATCHRESPONSE;
            }
            if ("history".equals(codeString)) {
                return HISTORY;
            }
            if ("searchset".equals(codeString)) {
                return SEARCHSET;
            }
            if ("collection".equals(codeString)) {
                return COLLECTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown BundleType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DOCUMENT: {
                    return "document";
                }
                case MESSAGE: {
                    return Bundle.SP_MESSAGE;
                }
                case TRANSACTION: {
                    return "transaction";
                }
                case TRANSACTIONRESPONSE: {
                    return "transaction-response";
                }
                case BATCH: {
                    return "batch";
                }
                case BATCHRESPONSE: {
                    return "batch-response";
                }
                case HISTORY: {
                    return "history";
                }
                case SEARCHSET: {
                    return "searchset";
                }
                case COLLECTION: {
                    return "collection";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DOCUMENT: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case MESSAGE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case TRANSACTION: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case TRANSACTIONRESPONSE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case BATCH: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case BATCHRESPONSE: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case HISTORY: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case SEARCHSET: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case COLLECTION: {
                    return "http://hl7.org/fhir/bundle-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DOCUMENT: {
                    return "The bundle is a document. The first resource is a Composition.";
                }
                case MESSAGE: {
                    return "The bundle is a message. The first resource is a MessageHeader.";
                }
                case TRANSACTION: {
                    return "The bundle is a transaction - intended to be processed by a server as an atomic commit.";
                }
                case TRANSACTIONRESPONSE: {
                    return "The bundle is a transaction response. Because the response is a transaction response, the transaction has succeeded, and all responses are error free.";
                }
                case BATCH: {
                    return "The bundle is a set of actions - intended to be processed by a server as a group of independent actions.";
                }
                case BATCHRESPONSE: {
                    return "The bundle is a batch response. Note that as a batch, some responses may indicate failure and others success.";
                }
                case HISTORY: {
                    return "The bundle is a list of resources from a history interaction on a server.";
                }
                case SEARCHSET: {
                    return "The bundle is a list of resources returned as a result of a search/query interaction, operation, or message.";
                }
                case COLLECTION: {
                    return "The bundle is a set of resources collected into a single package for ease of distribution that imposes no processing obligations or behavioral rules beyond persistence.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DOCUMENT: {
                    return "Document";
                }
                case MESSAGE: {
                    return "Message";
                }
                case TRANSACTION: {
                    return "Transaction";
                }
                case TRANSACTIONRESPONSE: {
                    return "Transaction Response";
                }
                case BATCH: {
                    return "Batch";
                }
                case BATCHRESPONSE: {
                    return "Batch Response";
                }
                case HISTORY: {
                    return "History List";
                }
                case SEARCHSET: {
                    return "Search Results";
                }
                case COLLECTION: {
                    return "Collection";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

