/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EncounterSpecialArrangements {
    WHEEL,
    ADDBED,
    INT,
    ATT,
    DOG,
    NULL;


    public static EncounterSpecialArrangements fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("wheel".equals(codeString)) {
            return WHEEL;
        }
        if ("add-bed".equals(codeString)) {
            return ADDBED;
        }
        if ("int".equals(codeString)) {
            return INT;
        }
        if ("att".equals(codeString)) {
            return ATT;
        }
        if ("dog".equals(codeString)) {
            return DOG;
        }
        throw new FHIRException("Unknown EncounterSpecialArrangements code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case WHEEL: {
                return "wheel";
            }
            case ADDBED: {
                return "add-bed";
            }
            case INT: {
                return "int";
            }
            case ATT: {
                return "att";
            }
            case DOG: {
                return "dog";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/encounter-special-arrangements";
    }

    public String getDefinition() {
        switch (this) {
            case WHEEL: {
                return "The patient requires a wheelchair to be made available for the encounter.";
            }
            case ADDBED: {
                return "An additional bed made available for a person accompanying the patient, for example a parent accompanying a child.";
            }
            case INT: {
                return "The patient is not fluent in the local language and requires an interpreter to be available. Refer to the Patient.Language property for the type of interpreter required.";
            }
            case ATT: {
                return "A person who accompanies a patient to provide assistive services necessary for the patient's care during the encounter.";
            }
            case DOG: {
                return "The patient has a guide dog and the location used for the encounter should be able to support the presence of the service animal.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case WHEEL: {
                return "Wheelchair";
            }
            case ADDBED: {
                return "Additional bedding";
            }
            case INT: {
                return "Interpreter";
            }
            case ATT: {
                return "Attendant";
            }
            case DOG: {
                return "Guide dog";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

