/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.settings.FhirSettings;

public class SimpleHTTPClient {
    private static final int MAX_REDIRECTS = 5;
    private static int counter = 1;
    private List<Header> headers = new ArrayList<Header>();
    private AuthenticationMode authenticationMode;
    private String username;
    private String password;
    private String token;

    public void addHeader(String name, String value) {
        this.headers.add(new Header(name, value));
    }

    public HTTPResult get(String url) throws IOException {
        return this.get(url, null);
    }

    public HTTPResult get(String url, String accept) throws IOException {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        URL u = new URL(url);
        HashMap<String, Integer> visited = new HashMap<String, Integer>();
        HttpURLConnection c = null;
        boolean done = false;
        block3: while (!done) {
            int times = visited.compute(url, (key, count) -> count == null ? 1 : count + 1);
            if (times > 5) {
                throw new IOException("Stuck in redirect loop");
            }
            u = new URL(url);
            c = (HttpURLConnection)u.openConnection();
            c.setRequestMethod("GET");
            if (accept != null) {
                c.setRequestProperty("Accept", accept);
            }
            this.setHeaders(c);
            c.setInstanceFollowRedirects(false);
            switch (c.getResponseCode()) {
                case 301: 
                case 302: {
                    String location = c.getHeaderField("Location");
                    location = URLDecoder.decode(location, "UTF-8");
                    URL base = new URL(url);
                    URL next = new URL(base, location);
                    url = next.toExternalForm();
                    continue block3;
                }
            }
            done = true;
        }
        return new HTTPResult(url, c.getResponseCode(), c.getResponseMessage(), c.getRequestProperty("Content-Type"), TextFile.streamToBytes(c.getResponseCode() >= 400 ? c.getErrorStream() : c.getInputStream()));
    }

    private void setHeaders(HttpURLConnection c) {
        if (this.headers != null) {
            for (Header h : this.headers) {
                c.setRequestProperty(h.getName(), h.getValue());
            }
        }
        c.setConnectTimeout(15000);
        c.setReadTimeout(15000);
        this.setAuthenticationHeader(c);
    }

    private void setAuthenticationHeader(HttpURLConnection c) {
        String authHeaderValue = null;
        if (this.authenticationMode == AuthenticationMode.TOKEN) {
            authHeaderValue = "Bearer " + new String(this.token);
        } else if (this.authenticationMode == AuthenticationMode.BASIC) {
            String auth = this.username + ":" + this.password;
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            authHeaderValue = "Basic " + new String(encodedAuth);
        }
        if (authHeaderValue != null) {
            c.setRequestProperty("Authorization", authHeaderValue);
        }
    }

    public HTTPResult post(String url, String contentType, byte[] content, String accept) throws IOException {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        URL u = new URL(url);
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        c.setDoOutput(true);
        c.setDoInput(true);
        c.setRequestMethod("POST");
        c.setRequestProperty("Content-type", contentType);
        if (accept != null) {
            c.setRequestProperty("Accept", accept);
        }
        this.setHeaders(c);
        c.getOutputStream().write(content);
        c.getOutputStream().close();
        return new HTTPResult(url, c.getResponseCode(), c.getResponseMessage(), c.getRequestProperty("Content-Type"), TextFile.streamToBytes(c.getResponseCode() >= 400 ? c.getErrorStream() : c.getInputStream()));
    }

    public HTTPResult put(String url, String contentType, byte[] content, String accept) throws IOException {
        if (FhirSettings.isProhibitNetworkAccess()) {
            throw new FHIRException("Network Access is prohibited in this context");
        }
        URL u = new URL(url);
        HttpURLConnection c = (HttpURLConnection)u.openConnection();
        c.setDoOutput(true);
        c.setDoInput(true);
        c.setRequestMethod("PUT");
        c.setRequestProperty("Content-type", contentType);
        if (accept != null) {
            c.setRequestProperty("Accept", accept);
        }
        this.setHeaders(c);
        c.getOutputStream().write(content);
        c.getOutputStream().close();
        return new HTTPResult(url, c.getResponseCode(), c.getResponseMessage(), c.getRequestProperty("Content-Type"), TextFile.streamToBytes(c.getResponseCode() >= 400 ? c.getErrorStream() : c.getInputStream()));
    }

    public AuthenticationMode getAuthenticationMode() {
        return this.authenticationMode;
    }

    public void setAuthenticationMode(AuthenticationMode authenticationMode) {
        this.authenticationMode = authenticationMode;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public static class HTTPResult {
        private int code;
        private String contentType;
        private byte[] content;
        private String source;
        private String message;

        public HTTPResult(String source, int code, String message, String contentType, byte[] content) {
            this.source = source;
            this.code = code;
            this.contentType = contentType;
            this.content = content;
            this.message = message;
        }

        public int getCode() {
            return this.code;
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getContent() {
            return this.content;
        }

        public String getSource() {
            return this.source;
        }

        public void checkThrowException() throws IOException {
            if (this.code >= 300) {
                String filename = Utilities.path("[tmp]", "http-log", "fhir-http-" + ++counter + ".log");
                if (this.content == null || this.content.length == 0) {
                    HTTPResultException exception = new HTTPResultException(this.code, this.message, this.source, null);
                    throw new IOException(exception.message, exception);
                }
                Utilities.createDirectory(Utilities.path("[tmp]", "http-log"));
                TextFile.bytesToFile(this.content, filename);
                HTTPResultException exception = new HTTPResultException(this.code, this.message, this.source, filename);
                throw new IOException(exception.message, exception);
            }
        }

        public String getMessage() {
            return this.message;
        }

        public String getContentAsString() {
            return new String(this.content, StandardCharsets.UTF_8);
        }
    }

    public static class HTTPResultException
    extends Exception {
        public final int httpCode;
        public final String message;
        public final String url;
        public final String logPath;

        public HTTPResultException(int httpCode, String message, String url, String logPath) {
            this.httpCode = httpCode;
            this.message = message;
            this.url = url;
            this.logPath = logPath;
        }

        @Override
        public String getMessage() {
            return "Invalid HTTP response " + this.httpCode + " from " + this.url + " (" + this.message + ") (" + (String)(this.logPath != null ? "Response in " + this.logPath : "No response content") + ")";
        }
    }

    public static class Header {
        private String name;
        private String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum AuthenticationMode {
        NONE,
        BASIC,
        TOKEN;

    }
}

