/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.hl7.fhir.utilities.CSFile;

public class TextFile {
    public static List<String> readAllLines(String path) throws IOException {
        CSFile file = new CSFile(path);
        return Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
    }

    public static void writeAllLines(String path, List<String> lines) throws IOException {
        CSFile file = new CSFile(path);
        Files.write(file.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    public static void stringToStream(String content, OutputStream stream) throws IOException {
        stream.write(content.getBytes(StandardCharsets.UTF_8));
    }

    public static byte[] stringToBytes(String content) throws IOException {
        return content.getBytes(StandardCharsets.UTF_8);
    }

    public static void stringToFile(String content, String path) throws IOException {
        CSFile file = new CSFile(path);
        TextFile.stringToFile(content, file);
    }

    public static void stringToFile(String content, File file) throws IOException {
        try (OutputStream output = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            output.write(content.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void stringToFileWithBOM(String content, File file) throws IOException {
        try (OutputStream output = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            output.write(new byte[]{-17, -69, -65});
            output.write(content.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void stringToFileWithBOM(String content, String path) throws IOException {
        CSFile file = new CSFile(path);
        TextFile.stringToFileWithBOM(content, file);
    }

    public static String fileToString(File f) throws FileNotFoundException, IOException {
        return new String(Files.readAllBytes(f.toPath()), StandardCharsets.UTF_8);
    }

    public static String fileToString(String src) throws FileNotFoundException, IOException {
        CSFile f = new CSFile(src);
        if (!f.exists()) {
            throw new IOException("File " + src + " not found");
        }
        return TextFile.fileToString(f);
    }

    public static String streamToString(InputStream input) throws IOException {
        return new String(input.readAllBytes(), StandardCharsets.UTF_8).replace("\ufeff", "");
    }

    public static byte[] streamToBytes(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        byte[] read = input.readAllBytes();
        input.close();
        return read;
    }

    public static byte[] streamToBytesNoClose(InputStream input) throws IOException {
        if (input == null) {
            return null;
        }
        return input.readAllBytes();
    }

    public static void bytesToFile(byte[] bytes, String path) throws IOException {
        try (FileOutputStream sw = new FileOutputStream(new CSFile(path));){
            ((OutputStream)sw).write(bytes);
        }
    }

    public static void bytesToFile(byte[] bytes, File f) throws IOException {
        try (FileOutputStream sw = new FileOutputStream(f);){
            ((OutputStream)sw).write(bytes);
        }
    }

    public static void appendBytesToFile(byte[] bytes, String path) throws IOException {
        byte[] linebreak = new byte[]{13, 10};
        Files.write(Paths.get(path, new String[0]), linebreak, StandardOpenOption.APPEND);
        Files.write(Paths.get(path, new String[0]), bytes, StandardOpenOption.APPEND);
    }

    public static byte[] fileToBytes(String srcFile) throws FileNotFoundException, IOException {
        CSFile f = new CSFile(srcFile);
        return Files.readAllBytes(f.toPath());
    }

    public static byte[] fileToBytesNCS(String srcFile) throws FileNotFoundException, IOException {
        return Files.readAllBytes(Path.of(srcFile, new String[0]));
    }

    public static byte[] fileToBytes(File file) throws FileNotFoundException, IOException {
        return Files.readAllBytes(file.toPath());
    }

    public static String bytesToString(byte[] bs) throws IOException {
        return new String(bs, StandardCharsets.UTF_8);
    }

    public static String bytesToString(byte[] bs, boolean removeBOM) throws IOException {
        String read = new String(bs, StandardCharsets.UTF_8);
        if (removeBOM) {
            return read.replace("\ufeff", "");
        }
        return read;
    }

    public static void streamToFile(InputStream stream, String filename) throws IOException {
        Files.copy(stream, Path.of(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        stream.close();
    }

    public static void streamToFileNoClose(InputStream stream, String filename) throws IOException {
        Files.copy(stream, Path.of(filename, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }
}

