/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;

public class FilesystemPackageCacheLock {
    private static final ConcurrentHashMap<File, ReadWriteLock> locks = new ConcurrentHashMap();
    private final File lockFile;

    public FilesystemPackageCacheLock(File cacheFolder, String name) throws IOException {
        this.lockFile = new File(cacheFolder, name + ".lock");
        if (!this.lockFile.isFile()) {
            TextFile.stringToFile("", this.lockFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doWriteWithLock(FilesystemPackageCacheManager.CacheLockFunction<T> f) throws IOException {
        try (FileChannel channel = new RandomAccessFile(this.lockFile, "rw").getChannel();){
            locks.putIfAbsent(this.lockFile, new ReentrantReadWriteLock());
            ReadWriteLock lock = locks.get(this.lockFile);
            lock.writeLock().lock();
            FileLock fileLock = channel.lock();
            T result = null;
            try {
                result = f.get();
            }
            finally {
                fileLock.release();
                lock.writeLock().unlock();
            }
            if (!this.lockFile.delete()) {
                this.lockFile.deleteOnExit();
            }
            T t = result;
            return t;
        }
    }
}

