/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.validation;

import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.AcceptLanguageHeader;

public class ValidationOptions {
    private AcceptLanguageHeader langs = null;
    private boolean useServer = true;
    private boolean useClient = true;
    private boolean guessSystem = false;
    private boolean membershipOnly = false;
    private boolean displayWarningMode = false;
    private boolean vsAsUrl;
    private boolean versionFlexible = true;
    private boolean useValueSetDisplays;
    private boolean englishOk = true;
    private boolean activeOnly = false;
    private boolean exampleOK = false;
    private FhirPublication fhirVersion;

    public ValidationOptions(FhirPublication fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    public ValidationOptions(FhirPublication fhirVersion, String language) {
        if (!Utilities.noString(language)) {
            this.langs = new AcceptLanguageHeader(language, false);
        }
    }

    public static ValidationOptions defaults() {
        return new ValidationOptions(FhirPublication.R5, "en, en-US");
    }

    public AcceptLanguageHeader getLanguages() {
        return this.langs;
    }

    public boolean hasLanguages() {
        return this.langs != null && !Utilities.noString(this.langs.getSource());
    }

    public boolean isUseServer() {
        return this.useServer;
    }

    public boolean isUseClient() {
        return this.useClient;
    }

    public boolean isGuessSystem() {
        return this.guessSystem;
    }

    public boolean isActiveOnly() {
        return this.activeOnly;
    }

    public boolean getVsAsUrl() {
        return this.vsAsUrl;
    }

    public boolean isVersionFlexible() {
        return this.versionFlexible;
    }

    public boolean isUseValueSetDisplays() {
        return this.useValueSetDisplays;
    }

    public boolean isMembershipOnly() {
        return this.membershipOnly;
    }

    public boolean isEnglishOk() {
        return this.englishOk;
    }

    public ValidationOptions withLanguage(String language) {
        if (language == null) {
            return this;
        }
        ValidationOptions n = this.copy();
        n.addLanguage(language);
        return n;
    }

    public ValidationOptions withNoServer() {
        ValidationOptions n = this.copy();
        n.useServer = false;
        return n;
    }

    public ValidationOptions withNoClient() {
        ValidationOptions n = this.copy();
        n.useClient = false;
        return n;
    }

    public ValidationOptions withGuessSystem() {
        ValidationOptions n = this.copy();
        n.guessSystem = true;
        return n;
    }

    public ValidationOptions withGuessSystem(boolean value) {
        ValidationOptions n = this.copy();
        n.guessSystem = value;
        return n;
    }

    public ValidationOptions withActiveOnly() {
        ValidationOptions n = this.copy();
        n.activeOnly = true;
        return n;
    }

    public ValidationOptions withCheckValueSetOnly() {
        ValidationOptions n = this.copy();
        n.membershipOnly = true;
        return n;
    }

    public ValidationOptions withVsAsUrl() {
        ValidationOptions n = this.copy();
        n.vsAsUrl = true;
        return n;
    }

    public ValidationOptions withVersionFlexible(boolean value) {
        ValidationOptions n = this.copy();
        n.versionFlexible = value;
        return n;
    }

    public ValidationOptions withUseValueSetDisplays(boolean useValueSetDisplays) {
        ValidationOptions n = this.copy();
        n.useValueSetDisplays = useValueSetDisplays;
        return n;
    }

    public ValidationOptions withEnglishOk(boolean englishOk) {
        ValidationOptions n = this.copy();
        n.englishOk = englishOk;
        return n;
    }

    public ValidationOptions addLanguage(String language) {
        if (this.langs == null) {
            this.langs = new AcceptLanguageHeader(language, false);
        } else {
            this.langs.add(language);
        }
        return this;
    }

    public ValidationOptions setLanguages(String language) {
        this.langs = new AcceptLanguageHeader(language, false);
        return this;
    }

    public ValidationOptions setNoServer(boolean useServer) {
        this.useServer = useServer;
        return this;
    }

    public ValidationOptions setNoClient(boolean useClient) {
        this.useClient = useClient;
        return this;
    }

    public ValidationOptions setGuessSystem(boolean guessSystem) {
        this.guessSystem = guessSystem;
        return this;
    }

    public ValidationOptions setActiveOnly(boolean activeOnly) {
        this.activeOnly = activeOnly;
        return this;
    }

    public ValidationOptions setCheckValueSetOnly() {
        this.membershipOnly = true;
        return this;
    }

    public ValidationOptions setVsAsUrl(boolean value) {
        this.vsAsUrl = value;
        return this;
    }

    public ValidationOptions setVersionFlexible(boolean value) {
        this.versionFlexible = value;
        return this;
    }

    public ValidationOptions setUseValueSetDisplays(boolean useValueSetDisplays) {
        this.useValueSetDisplays = useValueSetDisplays;
        return this;
    }

    public ValidationOptions setEnglishOk(boolean englishOk) {
        this.englishOk = englishOk;
        return this;
    }

    public boolean isDisplayWarningMode() {
        return this.displayWarningMode;
    }

    public ValidationOptions setDisplayWarningMode(boolean displayWarningMode) {
        this.displayWarningMode = displayWarningMode;
        return this;
    }

    public boolean isExampleOK() {
        return this.exampleOK;
    }

    public ValidationOptions setExampleOK(boolean exampleOK) {
        this.exampleOK = exampleOK;
        return this;
    }

    public ValidationOptions withExampleOK() {
        return this.setExampleOK(true);
    }

    public ValidationOptions copy() {
        ValidationOptions n = new ValidationOptions(this.fhirVersion);
        n.langs = this.langs == null ? null : this.langs.copy();
        n.useServer = this.useServer;
        n.useClient = this.useClient;
        n.guessSystem = this.guessSystem;
        n.activeOnly = this.activeOnly;
        n.vsAsUrl = this.vsAsUrl;
        n.versionFlexible = this.versionFlexible;
        n.membershipOnly = this.membershipOnly;
        n.useValueSetDisplays = this.useValueSetDisplays;
        n.displayWarningMode = this.displayWarningMode;
        n.exampleOK = this.exampleOK;
        return n;
    }

    public String toJson() {
        return "\"langs\":\"" + (this.langs == null ? "" : this.langs.toString()) + "\", \"useServer\":\"" + Boolean.toString(this.useServer) + "\", \"useClient\":\"" + Boolean.toString(this.useClient) + "\", \"guessSystem\":\"" + Boolean.toString(this.guessSystem) + "\", \"activeOnly\":\"" + Boolean.toString(this.activeOnly) + (String)(this.exampleOK ? "\", \"exampleOK\":\"" + Boolean.toString(this.exampleOK) : "") + "\", \"membershipOnly\":\"" + Boolean.toString(this.membershipOnly) + "\", \"displayWarningMode\":\"" + Boolean.toString(this.displayWarningMode) + "\", \"versionFlexible\":\"" + Boolean.toString(this.versionFlexible) + "\"";
    }

    public String langSummary() {
        if (this.langs == null) {
            return "--";
        }
        String s = this.langs.toString();
        if (Utilities.noString(s)) {
            s = "--";
        }
        return s;
    }

    public FhirPublication getFhirVersion() {
        return this.fhirVersion;
    }
}

