/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImplWithoutEntityAndAnonCaching;

public class OWLAnnotationAssertionAxiomImpl
extends OWLAxiomImplWithoutEntityAndAnonCaching
implements OWLAnnotationAssertionAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLAnnotationSubject subject;
    @Nonnull
    private final OWLAnnotationProperty property;
    @Nonnull
    private final OWLAnnotationValue value;

    public OWLAnnotationAssertionAxiomImpl(@Nonnull OWLAnnotationSubject subject, @Nonnull OWLAnnotationProperty property, @Nonnull OWLAnnotationValue value, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.subject = (OWLAnnotationSubject)OWLAPIPreconditions.checkNotNull((Object)subject, (String)"subject cannot be null");
        this.property = (OWLAnnotationProperty)OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
        this.value = (OWLAnnotationValue)OWLAPIPreconditions.checkNotNull((Object)value, (String)"value cannot be null");
    }

    public OWLAnnotationAssertionAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLAnnotationAssertionAxiomImpl(this.getSubject(), this.getProperty(), this.getValue(), NO_ANNOTATIONS);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.property);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        OWLAnonymousIndividual anonymousIndividual;
        if (this.subject instanceof OWLAnonymousIndividual) {
            anonymousIndividual = (OWLAnonymousIndividual)this.subject;
            anons.add(anonymousIndividual);
        }
        if (this.value instanceof OWLAnonymousIndividual) {
            anonymousIndividual = (OWLAnonymousIndividual)this.value;
            anons.add(anonymousIndividual);
        }
    }

    public boolean isDeprecatedIRIAssertion() {
        return this.property.isDeprecated() && this.getAnnotation().isDeprecatedIRIAnnotation();
    }

    public OWLAnnotationAssertionAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLAnnotationAssertionAxiomImpl(this.getSubject(), this.getProperty(), this.getValue(), this.mergeAnnos(annotations));
    }

    public OWLAnnotationValue getValue() {
        return this.value;
    }

    public OWLAnnotationSubject getSubject() {
        return this.subject;
    }

    public OWLAnnotationProperty getProperty() {
        return this.property;
    }

    public OWLAnnotation getAnnotation() {
        return new OWLAnnotationImpl(this.property, this.value, NO_ANNOTATIONS);
    }

    public boolean isLogicalAxiom() {
        return false;
    }

    public boolean isAnnotationAxiom() {
        return true;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLAnnotationAssertionAxiom other = (OWLAnnotationAssertionAxiom)object;
        int diff = this.subject.compareTo((Object)other.getSubject());
        if (diff != 0) {
            return diff;
        }
        diff = this.property.compareTo((Object)other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return this.value.compareTo((Object)other.getValue());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLAnnotationAssertionAxiom)this);
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLAnnotationAssertionAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationAssertionAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationAssertionAxiom)this);
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.ANNOTATION_ASSERTION;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLAnnotationAssertionAxiom)) {
            return false;
        }
        OWLAnnotationAssertionAxiom other = (OWLAnnotationAssertionAxiom)obj;
        return this.subject.equals((Object)other.getSubject()) && this.property.equals((Object)other.getProperty()) && this.value.equals((Object)other.getValue());
    }
}

