/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImplWithoutEntityAndAnonCaching;

public class OWLAnnotationPropertyDomainAxiomImpl
extends OWLAxiomImplWithoutEntityAndAnonCaching
implements OWLAnnotationPropertyDomainAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLAnnotationProperty property;
    @Nonnull
    private final IRI domain;

    public OWLAnnotationPropertyDomainAxiomImpl(@Nonnull OWLAnnotationProperty property, @Nonnull IRI domain, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.domain = (IRI)OWLAPIPreconditions.checkNotNull((Object)domain, (String)"domain cannot be null");
        this.property = (OWLAnnotationProperty)OWLAPIPreconditions.checkNotNull((Object)property, (String)"property cannot be null");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.property);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    public OWLAnnotationPropertyDomainAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLAnnotationPropertyDomainAxiomImpl(this.getProperty(), this.getDomain(), NO_ANNOTATIONS);
    }

    public OWLAnnotationPropertyDomainAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLAnnotationPropertyDomainAxiomImpl(this.getProperty(), this.getDomain(), this.mergeAnnos(annotations));
    }

    public IRI getDomain() {
        return this.domain;
    }

    public OWLAnnotationProperty getProperty() {
        return this.property;
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.ANNOTATION_PROPERTY_DOMAIN;
    }

    public boolean isLogicalAxiom() {
        return false;
    }

    public boolean isAnnotationAxiom() {
        return true;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLAnnotationPropertyDomainAxiom other = (OWLAnnotationPropertyDomainAxiom)object;
        int diff = this.property.compareTo((Object)other.getProperty());
        if (diff != 0) {
            return diff;
        }
        return this.domain.compareTo((OWLObject)other.getDomain());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLAnnotationPropertyDomainAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationPropertyDomainAxiom)this);
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLAnnotationPropertyDomainAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLAnnotationPropertyDomainAxiom)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLAnnotationPropertyDomainAxiom)) {
            return false;
        }
        OWLAnnotationPropertyDomainAxiom other = (OWLAnnotationPropertyDomainAxiom)obj;
        return this.property.equals((Object)other.getProperty()) && this.domain.equals((Object)other.getDomain());
    }
}

