/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.NodeID;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassProvider;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.PrefixManager;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLFacet;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnnotationPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousIndividualImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLAsymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLClassImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternals;
import uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryInternalsImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDataUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeDefinitionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDatatypeRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDeclarationAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDifferentIndividualsAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLDisjointUnionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentClassesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentDataPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLEquivalentObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFacetRestrictionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalDataPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLHasKeyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLImportsDeclarationImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseFunctionalObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLInverseObjectPropertiesAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLIrreflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeDataPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLNegativeObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectAllValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectComplementOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectExactCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasSelfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectHasValueImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectIntersectionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectInverseOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMaxCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectMinCardinalityImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectOneOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyAssertionAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyDomainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectPropertyRangeAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectSomeValuesFromImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLReflexiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSameIndividualAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubAnnotationPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubClassOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubDataPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubObjectPropertyOfAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSubPropertyChainAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLSymmetricObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLTransitiveObjectPropertyAxiomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLBuiltInAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLClassAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDataRangeAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLDifferentIndividualsAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLIndividualArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLLiteralArgumentImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLObjectPropertyAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLRuleImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLSameIndividualAtomImpl;
import uk.ac.manchester.cs.owl.owlapi.SWRLVariableImpl;

@Singleton
public class OWLDataFactoryImpl
implements OWLDataFactory,
Serializable,
OWLClassProvider {
    private static final String CLASS_EXPRESSION_CANNOT_BE_NULL = "classExpression cannot be null";
    private static final String ARG1_CANNOT_BE_NULL = "arg1 cannot be null";
    private static final String CLASS_EXPRESSIONS = "classExpressions";
    private static final String OPERANDS2 = "operands";
    private static final String INDIVIDUALS2 = "individuals";
    private static final String DATA_RANGE_CANNOT_BE_NULL = "dataRange cannot be null";
    private static final String PREFIX_MANAGER_CANNOT_BE_NULL = "prefixManager cannot be null";
    private static final String DATA_RANGES = "dataRanges";
    private static final String CARDINALITY_CANNOT_BE_NEGATIVE = "cardinality cannot be negative";
    private static final String SUPER_PROPERTY_CANNOT_BE_NULL = "superProperty cannot be null";
    private static final String PROPERTY_CANNOT_BE_NULL = "property cannot be null";
    private static final String ARG0_CANNOT_BE_NULL = "arg0 cannot be null";
    private static final String PROPERTIES2 = "properties";
    private static final String SUBJECT_CANNOT_BE_NULL = "subject cannot be null";
    private static final String INDIVIDUAL_CANNOT_BE_NULL = "individual cannot be null";
    private static final String VALUE_CANNOT_BE_NULL = "value cannot be null";
    private static final String OBJECT_CANNOT_BE_NULL = "object cannot be null";
    private static final String IRI_CANNOT_BE_NULL = "iri cannot be null";
    private static final String DATATYPE_CANNOT_BE_NULL = "datatype cannot be null";
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private static final OWLClass OWL_THING = new OWLClassImpl(OWLRDFVocabulary.OWL_THING.getIRI());
    @Nonnull
    private static final OWLClass OWL_NOTHING = new OWLClassImpl(OWLRDFVocabulary.OWL_NOTHING.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_LABEL = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_LABEL.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_COMMENT = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_COMMENT.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_SEE_ALSO = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_SEE_ALSO.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty RDFS_IS_DEFINED_BY = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.RDFS_IS_DEFINED_BY.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_BACKWARD_COMPATIBLE_WITH = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_BACKWARD_COMPATIBLE_WITH.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_INCOMPATIBLE_WITH = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_INCOMPATIBLE_WITH.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_VERSION_INFO = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_VERSION_INFO.getIRI());
    @Nonnull
    private static final OWLAnnotationProperty OWL_DEPRECATED = new OWLAnnotationPropertyImpl(OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
    @Nonnull
    private static final OWLObjectProperty OWL_TOP_OBJECT_PROPERTY = new OWLObjectPropertyImpl(OWLRDFVocabulary.OWL_TOP_OBJECT_PROPERTY.getIRI());
    @Nonnull
    private static final OWLObjectProperty OWL_BOTTOM_OBJECT_PROPERTY = new OWLObjectPropertyImpl(OWLRDFVocabulary.OWL_BOTTOM_OBJECT_PROPERTY.getIRI());
    @Nonnull
    private static final OWLDataProperty OWL_TOP_DATA_PROPERTY = new OWLDataPropertyImpl(OWLRDFVocabulary.OWL_TOP_DATA_PROPERTY.getIRI());
    @Nonnull
    private static final OWLDataProperty OWL_BOTTOM_DATA_PROPERTY = new OWLDataPropertyImpl(OWLRDFVocabulary.OWL_BOTTOM_DATA_PROPERTY.getIRI());
    private final OWLDataFactoryInternals dataFactoryInternals = new OWLDataFactoryInternalsImpl(false);
    private OWLOntologyLoaderConfiguration config;
    @Nonnull
    private static final Set<OWLAnnotation> EMPTY_ANNOTATIONS_SET = CollectionFactory.emptySet();

    @Inject
    public OWLDataFactoryImpl() {
        this(new OWLOntologyLoaderConfiguration());
    }

    public OWLDataFactoryImpl(OWLOntologyLoaderConfiguration config) {
        this.config = config;
    }

    public void purge() {
        this.dataFactoryInternals.purge();
    }

    private static void checkAnnotations(@Nonnull Set<? extends OWLAnnotation> o) {
        OWLDataFactoryImpl.checkNull(o, "annotations cannot be null", true);
    }

    private static void checkNull(@Nonnull Collection<?> o, String name, boolean emptyAllowed) {
        OWLAPIPreconditions.checkNotNull(o, (String)(name + " cannot be null"));
        if (!emptyAllowed && o.isEmpty()) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    private static void checkNull(@Nonnull Object[] o, String name, boolean emptyAllowed) {
        OWLAPIPreconditions.checkNotNull((Object)o, (String)(name + " cannot be null"));
        if (!emptyAllowed && o.length == 0) {
            throw new IllegalArgumentException(name + " cannot be empty");
        }
    }

    @Nonnull
    public <E extends OWLEntity> E getOWLEntity(@Nonnull EntityType<E> entityType, IRI iri) {
        OWLAPIPreconditions.checkNotNull(entityType, (String)"entityType cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)IRI_CANNOT_BE_NULL);
        OWLClass ret = null;
        if (entityType.equals((Object)EntityType.CLASS)) {
            ret = this.getOWLClass(iri);
        } else if (entityType.equals((Object)EntityType.OBJECT_PROPERTY)) {
            ret = this.getOWLObjectProperty(iri);
        } else if (entityType.equals((Object)EntityType.DATA_PROPERTY)) {
            ret = this.getOWLDataProperty(iri);
        } else if (entityType.equals((Object)EntityType.ANNOTATION_PROPERTY)) {
            ret = this.getOWLAnnotationProperty(iri);
        } else if (entityType.equals((Object)EntityType.NAMED_INDIVIDUAL)) {
            ret = this.getOWLNamedIndividual(iri);
        } else if (entityType.equals((Object)EntityType.DATATYPE)) {
            ret = this.getOWLDatatype(iri);
        }
        if (ret != null) {
            return (E)ret;
        }
        throw new OWLRuntimeException("Entity type not recognized: " + String.valueOf(entityType) + " for iri " + String.valueOf(iri));
    }

    public OWLClass getOWLClass(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)IRI_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLClass(iri);
    }

    public OWLClass getOWLClass(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull((Object)abbreviatedIRI, (String)IRI_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)prefixManager, (String)PREFIX_MANAGER_CANNOT_BE_NULL);
        return this.getOWLClass(prefixManager.getIRI(abbreviatedIRI));
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull((Object)abbreviatedIRI, (String)"abbreviatedIRI cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)prefixManager, (String)PREFIX_MANAGER_CANNOT_BE_NULL);
        return this.getOWLAnnotationProperty(prefixManager.getIRI(abbreviatedIRI));
    }

    @Nonnull
    public OWLAnnotationProperty getRDFSLabel() {
        return RDFS_LABEL;
    }

    @Nonnull
    public OWLAnnotationProperty getRDFSComment() {
        return RDFS_COMMENT;
    }

    @Nonnull
    public OWLAnnotationProperty getRDFSSeeAlso() {
        return RDFS_SEE_ALSO;
    }

    @Nonnull
    public OWLAnnotationProperty getRDFSIsDefinedBy() {
        return RDFS_IS_DEFINED_BY;
    }

    @Nonnull
    public OWLAnnotationProperty getOWLVersionInfo() {
        return OWL_VERSION_INFO;
    }

    @Nonnull
    public OWLAnnotationProperty getOWLBackwardCompatibleWith() {
        return OWL_BACKWARD_COMPATIBLE_WITH;
    }

    @Nonnull
    public OWLAnnotationProperty getOWLIncompatibleWith() {
        return OWL_INCOMPATIBLE_WITH;
    }

    @Nonnull
    public OWLAnnotationProperty getOWLDeprecated() {
        return OWL_DEPRECATED;
    }

    public OWLDatatype getOWLDatatype(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull((Object)abbreviatedIRI, (String)"abbreviatedIRI cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)prefixManager, (String)PREFIX_MANAGER_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLDatatype(prefixManager.getIRI(abbreviatedIRI));
    }

    @Nonnull
    public OWLClass getOWLThing() {
        return OWL_THING;
    }

    @Nonnull
    public OWLClass getOWLNothing() {
        return OWL_NOTHING;
    }

    @Nonnull
    public OWLDataProperty getOWLBottomDataProperty() {
        return OWL_BOTTOM_DATA_PROPERTY;
    }

    @Nonnull
    public OWLObjectProperty getOWLBottomObjectProperty() {
        return OWL_BOTTOM_OBJECT_PROPERTY;
    }

    @Nonnull
    public OWLDataProperty getOWLTopDataProperty() {
        return OWL_TOP_DATA_PROPERTY;
    }

    @Nonnull
    public OWLObjectProperty getOWLTopObjectProperty() {
        return OWL_TOP_OBJECT_PROPERTY;
    }

    public OWLObjectProperty getOWLObjectProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)IRI_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLObjectProperty(iri);
    }

    public OWLDataProperty getOWLDataProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)IRI_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLDataProperty(iri);
    }

    public OWLNamedIndividual getOWLNamedIndividual(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)IRI_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLNamedIndividual(iri);
    }

    public OWLDataProperty getOWLDataProperty(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull((Object)abbreviatedIRI, (String)"curi canno be null");
        OWLAPIPreconditions.checkNotNull((Object)prefixManager, (String)PREFIX_MANAGER_CANNOT_BE_NULL);
        return this.getOWLDataProperty(prefixManager.getIRI(abbreviatedIRI));
    }

    public OWLNamedIndividual getOWLNamedIndividual(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull((Object)abbreviatedIRI, (String)"curi canno be null");
        OWLAPIPreconditions.checkNotNull((Object)prefixManager, (String)PREFIX_MANAGER_CANNOT_BE_NULL);
        return this.getOWLNamedIndividual(prefixManager.getIRI(abbreviatedIRI));
    }

    public OWLObjectProperty getOWLObjectProperty(String abbreviatedIRI, @Nonnull PrefixManager prefixManager) {
        OWLAPIPreconditions.checkNotNull((Object)abbreviatedIRI, (String)"curi canno be null");
        OWLAPIPreconditions.checkNotNull((Object)prefixManager, (String)PREFIX_MANAGER_CANNOT_BE_NULL);
        return this.getOWLObjectProperty(prefixManager.getIRI(abbreviatedIRI));
    }

    @Nonnull
    public OWLAnonymousIndividual getOWLAnonymousIndividual(String nodeId) {
        OWLAPIPreconditions.checkNotNull((Object)nodeId, (String)"id cannot be null");
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID((String)nodeId));
    }

    @Nonnull
    public OWLAnonymousIndividual getOWLAnonymousIndividual() {
        return new OWLAnonymousIndividualImpl(NodeID.getNodeID(null));
    }

    public OWLDatatype getOWLDatatype(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)IRI_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLDatatype(iri);
    }

    public OWLLiteral getOWLLiteral(String lexicalValue, @Nonnull OWL2Datatype datatype) {
        OWLAPIPreconditions.checkNotNull((Object)lexicalValue, (String)"lexicalValue cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)DATATYPE_CANNOT_BE_NULL);
        return this.getOWLLiteral(lexicalValue, this.getOWLDatatype(datatype.getIRI()));
    }

    public OWLLiteral getOWLLiteral(boolean value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    @Nonnull
    public OWLDataOneOf getOWLDataOneOf(@Nonnull Set<? extends OWLLiteral> values) {
        OWLDataFactoryImpl.checkNull(values, "values", true);
        return new OWLDataOneOfImpl(values);
    }

    public OWLDataOneOf getOWLDataOneOf(OWLLiteral ... values) {
        OWLDataFactoryImpl.checkNull(values, "values", true);
        return this.getOWLDataOneOf(CollectionFactory.createSet((Object[])values));
    }

    @Nonnull
    public OWLDataComplementOf getOWLDataComplementOf(OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        return new OWLDataComplementOfImpl(dataRange);
    }

    public OWLDataIntersectionOf getOWLDataIntersectionOf(OWLDataRange ... dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, DATA_RANGES, true);
        return this.getOWLDataIntersectionOf(CollectionFactory.createSet((Object[])dataRanges));
    }

    @Nonnull
    public OWLDataIntersectionOf getOWLDataIntersectionOf(@Nonnull Set<? extends OWLDataRange> dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, DATA_RANGES, true);
        return new OWLDataIntersectionOfImpl(dataRanges);
    }

    public OWLDataUnionOf getOWLDataUnionOf(OWLDataRange ... dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, DATA_RANGES, true);
        return this.getOWLDataUnionOf(CollectionFactory.createSet((Object[])dataRanges));
    }

    @Nonnull
    public OWLDataUnionOf getOWLDataUnionOf(@Nonnull Set<? extends OWLDataRange> dataRanges) {
        OWLDataFactoryImpl.checkNull(dataRanges, DATA_RANGES, true);
        return new OWLDataUnionOfImpl(dataRanges);
    }

    @Nonnull
    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, @Nonnull Set<OWLFacetRestriction> facetRestrictions) {
        OWLAPIPreconditions.checkNotNull((Object)dataType, (String)DATATYPE_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkNull(facetRestrictions, "facets", true);
        return new OWLDatatypeRestrictionImpl(dataType, facetRestrictions);
    }

    @Nonnull
    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, OWLFacet facet, OWLLiteral typedLiteral) {
        OWLAPIPreconditions.checkNotNull((Object)dataType, (String)DATATYPE_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)facet, (String)"facet cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)typedLiteral, (String)"typedConstant cannot be null");
        return new OWLDatatypeRestrictionImpl(dataType, CollectionFactory.createSet((Object)this.getOWLFacetRestriction(facet, typedLiteral)));
    }

    public OWLDatatypeRestriction getOWLDatatypeRestriction(OWLDatatype dataType, OWLFacetRestriction ... facetRestrictions) {
        OWLDataFactoryImpl.checkNull(facetRestrictions, "facetRestrictions", true);
        return this.getOWLDatatypeRestriction(dataType, CollectionFactory.createSet((Object[])facetRestrictions));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(int minInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(int minInclusive, int maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(int minExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(int minExclusive, int maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getIntegerOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinInclusiveRestriction(double minInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxInclusiveRestriction(double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_INCLUSIVE, this.getOWLLiteral(maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxInclusiveRestriction(double minInclusive, double maxInclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_INCLUSIVE, this.getOWLLiteral(minInclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_INCLUSIVE, maxInclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinExclusiveRestriction(double minExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMaxExclusiveRestriction(double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), OWLFacet.MAX_EXCLUSIVE, this.getOWLLiteral(maxExclusive));
    }

    public OWLDatatypeRestriction getOWLDatatypeMinMaxExclusiveRestriction(double minExclusive, double maxExclusive) {
        return this.getOWLDatatypeRestriction(this.getDoubleOWLDatatype(), this.getOWLFacetRestriction(OWLFacet.MIN_EXCLUSIVE, this.getOWLLiteral(minExclusive)), this.getOWLFacetRestriction(OWLFacet.MAX_EXCLUSIVE, maxExclusive));
    }

    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, int facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, double facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, float facetValue) {
        return this.getOWLFacetRestriction(facet, this.getOWLLiteral(facetValue));
    }

    @Nonnull
    public OWLFacetRestriction getOWLFacetRestriction(OWLFacet facet, OWLLiteral facetValue) {
        OWLAPIPreconditions.checkNotNull((Object)facet, (String)"facet cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)facetValue, (String)"facetValue cannot be null");
        return new OWLFacetRestrictionImpl(facet, facetValue);
    }

    @Nonnull
    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(@Nonnull Set<? extends OWLClassExpression> operands) {
        OWLDataFactoryImpl.checkNull(operands, OPERANDS2, true);
        return new OWLObjectIntersectionOfImpl(operands);
    }

    public OWLObjectIntersectionOf getOWLObjectIntersectionOf(OWLClassExpression ... operands) {
        OWLDataFactoryImpl.checkNull(operands, OPERANDS2, true);
        return this.getOWLObjectIntersectionOf(CollectionFactory.createSet((Object[])operands));
    }

    @Nonnull
    public OWLDataAllValuesFrom getOWLDataAllValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLDataAllValuesFromImpl(property, dataRange);
    }

    @Nonnull
    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLDataExactCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    @Nonnull
    public OWLDataExactCardinality getOWLDataExactCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        return new OWLDataExactCardinalityImpl(property, cardinality, dataRange);
    }

    @Nonnull
    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLDataMaxCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    @Nonnull
    public OWLDataMaxCardinality getOWLDataMaxCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        return new OWLDataMaxCardinalityImpl(property, cardinality, dataRange);
    }

    @Nonnull
    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLDataMinCardinalityImpl(property, cardinality, (OWLDataRange)this.getTopDatatype());
    }

    @Nonnull
    public OWLDataMinCardinality getOWLDataMinCardinality(int cardinality, OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLDataMinCardinalityImpl(property, cardinality, dataRange);
    }

    @Nonnull
    public OWLDataSomeValuesFrom getOWLDataSomeValuesFrom(OWLDataPropertyExpression property, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLDataSomeValuesFromImpl(property, dataRange);
    }

    @Nonnull
    public OWLDataHasValue getOWLDataHasValue(OWLDataPropertyExpression property, OWLLiteral value) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)value, (String)VALUE_CANNOT_BE_NULL);
        return new OWLDataHasValueImpl(property, value);
    }

    @Nonnull
    public OWLObjectComplementOf getOWLObjectComplementOf(OWLClassExpression operand) {
        OWLAPIPreconditions.checkNotNull((Object)operand, (String)"operand");
        return new OWLObjectComplementOfImpl(operand);
    }

    @Nonnull
    public OWLObjectAllValuesFrom getOWLObjectAllValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectAllValuesFromImpl(property, classExpression);
    }

    @Nonnull
    public OWLObjectOneOf getOWLObjectOneOf(@Nonnull Set<? extends OWLIndividual> values) {
        OWLDataFactoryImpl.checkNull(values, "values", true);
        return new OWLObjectOneOfImpl(values);
    }

    public OWLObjectOneOf getOWLObjectOneOf(OWLIndividual ... individuals) {
        OWLDataFactoryImpl.checkNull(individuals, INDIVIDUALS2, true);
        return this.getOWLObjectOneOf(CollectionFactory.createSet((Object[])individuals));
    }

    @Nonnull
    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectExactCardinalityImpl(property, cardinality, (OWLClassExpression)OWL_THING);
    }

    @Nonnull
    public OWLObjectExactCardinality getOWLObjectExactCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        return new OWLObjectExactCardinalityImpl(property, cardinality, classExpression);
    }

    @Nonnull
    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectMinCardinalityImpl(property, cardinality, (OWLClassExpression)OWL_THING);
    }

    @Nonnull
    public OWLObjectMinCardinality getOWLObjectMinCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        return new OWLObjectMinCardinalityImpl(property, cardinality, classExpression);
    }

    @Nonnull
    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectMaxCardinalityImpl(property, cardinality, (OWLClassExpression)OWL_THING);
    }

    @Nonnull
    public OWLObjectMaxCardinality getOWLObjectMaxCardinality(int cardinality, OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNegative((long)cardinality, (String)CARDINALITY_CANNOT_BE_NEGATIVE);
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectMaxCardinalityImpl(property, cardinality, classExpression);
    }

    @Nonnull
    public OWLObjectHasSelf getOWLObjectHasSelf(OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectHasSelfImpl(property);
    }

    @Nonnull
    public OWLObjectSomeValuesFrom getOWLObjectSomeValuesFrom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        return new OWLObjectSomeValuesFromImpl(property, classExpression);
    }

    @Nonnull
    public OWLObjectHasValue getOWLObjectHasValue(OWLObjectPropertyExpression property, OWLIndividual individual) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)INDIVIDUAL_CANNOT_BE_NULL);
        return new OWLObjectHasValueImpl(property, individual);
    }

    @Nonnull
    public OWLObjectUnionOf getOWLObjectUnionOf(@Nonnull Set<? extends OWLClassExpression> operands) {
        OWLDataFactoryImpl.checkNull(operands, OPERANDS2, true);
        return new OWLObjectUnionOfImpl(operands);
    }

    public OWLObjectUnionOf getOWLObjectUnionOf(OWLClassExpression ... operands) {
        OWLDataFactoryImpl.checkNull(operands, OPERANDS2, true);
        return this.getOWLObjectUnionOf(CollectionFactory.createSet((Object[])operands));
    }

    @Nonnull
    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression propertyExpression, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)propertyExpression, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAsymmetricObjectPropertyAxiomImpl(propertyExpression, annotations);
    }

    @Nonnull
    public OWLAsymmetricObjectPropertyAxiom getOWLAsymmetricObjectPropertyAxiom(OWLObjectPropertyExpression propertyExpression) {
        return this.getOWLAsymmetricObjectPropertyAxiom(propertyExpression, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)domain, (String)"domain cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyDomainAxiomImpl(property, domain, annotations);
    }

    @Nonnull
    public OWLDataPropertyDomainAxiom getOWLDataPropertyDomainAxiom(OWLDataPropertyExpression property, OWLClassExpression domain) {
        return this.getOWLDataPropertyDomainAxiom(property, domain, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)owlDataRange, (String)"owlDataRange cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyRangeAxiomImpl(property, owlDataRange, annotations);
    }

    @Nonnull
    public OWLDataPropertyRangeAxiom getOWLDataPropertyRangeAxiom(OWLDataPropertyExpression property, OWLDataRange owlDataRange) {
        return this.getOWLDataPropertyRangeAxiom(property, owlDataRange, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subProperty, (String)"subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)superProperty, (String)SUPER_PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubDataPropertyOfAxiomImpl(subProperty, superProperty, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Nonnull
    public OWLSubDataPropertyOfAxiom getOWLSubDataPropertyOfAxiom(OWLDataPropertyExpression subProperty, OWLDataPropertyExpression superProperty) {
        return this.getOWLSubDataPropertyOfAxiom(subProperty, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity) {
        return this.getOWLDeclarationAxiom(owlEntity, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDeclarationAxiom getOWLDeclarationAxiom(OWLEntity owlEntity, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)owlEntity, (String)"owlEntity cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDeclarationAxiomImpl(owlEntity, annotations);
    }

    @Nonnull
    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(@Nonnull Set<? extends OWLIndividual> individuals, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(individuals, INDIVIDUALS2, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDifferentIndividualsAxiomImpl(individuals, annotations);
    }

    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(OWLIndividual ... individuals) {
        OWLDataFactoryImpl.checkNull(individuals, INDIVIDUALS2, true);
        return this.getOWLDifferentIndividualsAxiom(CollectionFactory.createSet((Object[])individuals));
    }

    @Nonnull
    public OWLDifferentIndividualsAxiom getOWLDifferentIndividualsAxiom(@Nonnull Set<? extends OWLIndividual> individuals) {
        return this.getOWLDifferentIndividualsAxiom(individuals, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(classExpressions, CLASS_EXPRESSIONS, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        if (classExpressions.size() == 1 && !this.config.shouldAllowDuplicatesInConstructSets()) {
            OWLClassExpression classExpression = classExpressions.iterator().next();
            if (classExpression.isOWLThing()) {
                throw new OWLRuntimeException("DisjointClasses(owl:Thing) cannot be created. It is not a syntactically valid OWL 2 axiom. If the intent is to declare owl:Thing as disjoint with itself and therefore empty, it cannot be created as a DisjointClasses axiom. Please rewrite it as SubClassOf(owl:Thing, owl:Nothing).");
            }
            if (classExpression.isOWLNothing()) {
                throw new OWLRuntimeException("DisjointClasses(owl:Nothing) cannot be created. It is not a syntactically valid OWL 2 axiom. If the intent is to declare owl:Nothing as disjoint with itself and therefore empty, it cannot be created as a DisjointClasses axiom, and it is also redundant as owl:Nothing is always empty. Please rewrite it as SubClassOf(owl:Nothing, owl:Nothing) or remove the axiom.");
            }
            HashSet<Object> modifiedClassExpressions = new HashSet<Object>(2);
            OWLClass addedClass = classExpression.isOWLThing() ? OWL_NOTHING : OWL_THING;
            modifiedClassExpressions.add(addedClass);
            modifiedClassExpressions.add(classExpression);
            return new OWLDisjointClassesAxiomImpl((Set<? extends OWLClassExpression>)modifiedClassExpressions, this.makeSingletonDisjoinClassWarningAnnotation(annotations, classExpression, (OWLClassExpression)addedClass));
        }
        return new OWLDisjointClassesAxiomImpl(classExpressions, annotations);
    }

    @Nonnull
    protected Set<? extends OWLAnnotation> makeSingletonDisjoinClassWarningAnnotation(Set<? extends OWLAnnotation> annotations, OWLClassExpression classExpression, OWLClassExpression addedClass) {
        HashSet<? extends OWLAnnotation> modifiedAnnotations = new HashSet<OWLAnnotation>(annotations.size() + 1);
        modifiedAnnotations.addAll(annotations);
        String provenanceComment = String.format("%s on %s", VersionInfo.getVersionInfo().getGeneratedByMessage(), new SimpleDateFormat().format(new Date()));
        OWLAnnotationImpl provenanceAnnotation = new OWLAnnotationImpl(RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(provenanceComment), EMPTY_ANNOTATIONS_SET);
        Set<OWLAnnotationImpl> metaAnnotations = Collections.singleton(provenanceAnnotation);
        String changeComment = String.format("DisjointClasses(%s) replaced by DisjointClasses(%s %s)", classExpression, classExpression, addedClass);
        modifiedAnnotations.add(new OWLAnnotationImpl(RDFS_COMMENT, (OWLAnnotationValue)this.getOWLLiteral(changeComment), metaAnnotations));
        return modifiedAnnotations;
    }

    @Nonnull
    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLDisjointClassesAxiom(classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDisjointClassesAxiom getOWLDisjointClassesAxiom(OWLClassExpression ... classExpressions) {
        OWLDataFactoryImpl.checkNull(classExpressions, CLASS_EXPRESSIONS, true);
        HashSet<OWLClassExpression> clses = new HashSet<OWLClassExpression>();
        clses.addAll(Arrays.asList(classExpressions));
        return this.getOWLDisjointClassesAxiom(clses);
    }

    @Nonnull
    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointDataPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Nonnull
    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties) {
        return this.getOWLDisjointDataPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLDisjointDataPropertiesAxiom getOWLDisjointDataPropertiesAxiom(OWLDataPropertyExpression ... dataProperties) {
        OWLDataFactoryImpl.checkNull(dataProperties, PROPERTIES2, true);
        return this.getOWLDisjointDataPropertiesAxiom(CollectionFactory.createSet((Object[])dataProperties));
    }

    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(OWLObjectPropertyExpression ... properties) {
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        return this.getOWLDisjointObjectPropertiesAxiom(CollectionFactory.createSet((Object[])properties));
    }

    @Nonnull
    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties) {
        return this.getOWLDisjointObjectPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDisjointObjectPropertiesAxiom getOWLDisjointObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointObjectPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Nonnull
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(classExpressions, CLASS_EXPRESSIONS, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentClassesAxiomImpl(classExpressions, annotations);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression clsA, OWLClassExpression clsB) {
        OWLAPIPreconditions.checkNotNull((Object)clsA, (String)"clsA cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)clsB, (String)"clsB cannot be null");
        return this.getOWLEquivalentClassesAxiom(clsA, clsB, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression clsA, OWLClassExpression clsB, Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)clsA, (String)"clsA cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)clsB, (String)"clsB cannot be null");
        return this.getOWLEquivalentClassesAxiom(CollectionFactory.createSet((Object[])new OWLClassExpression[]{clsA, clsB}), annotations);
    }

    @Nonnull
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(OWLClassExpression ... classExpressions) {
        OWLDataFactoryImpl.checkNull(classExpressions, CLASS_EXPRESSIONS, true);
        HashSet<OWLClassExpression> clses = new HashSet<OWLClassExpression>();
        clses.addAll(Arrays.asList(classExpressions));
        return this.getOWLEquivalentClassesAxiom(clses);
    }

    @Nonnull
    public OWLEquivalentClassesAxiom getOWLEquivalentClassesAxiom(@Nonnull Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLEquivalentClassesAxiom(classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentDataPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Nonnull
    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(@Nonnull Set<? extends OWLDataPropertyExpression> properties) {
        return this.getOWLEquivalentDataPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression propertyA, OWLDataPropertyExpression propertyB) {
        return this.getOWLEquivalentDataPropertiesAxiom(propertyA, propertyB, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression propertyA, OWLDataPropertyExpression propertyB, Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)propertyA, (String)"propertyA cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)propertyB, (String)"propertyB cannot be null");
        return this.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLDataPropertyExpression[]{propertyA, propertyB}), annotations);
    }

    public OWLEquivalentDataPropertiesAxiom getOWLEquivalentDataPropertiesAxiom(OWLDataPropertyExpression ... properties) {
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        return this.getOWLEquivalentDataPropertiesAxiom(CollectionFactory.createSet((Object[])properties));
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression ... properties) {
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        return this.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet((Object[])properties));
    }

    @Nonnull
    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties) {
        return this.getOWLEquivalentObjectPropertiesAxiom(properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression propertyA, OWLObjectPropertyExpression propertyB) {
        OWLAPIPreconditions.checkNotNull((Object)propertyA, (String)"propertyA cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)propertyB, (String)"propertyB cannot be null");
        return this.getOWLEquivalentObjectPropertiesAxiom(propertyA, propertyB, EMPTY_ANNOTATIONS_SET);
    }

    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(OWLObjectPropertyExpression propertyA, OWLObjectPropertyExpression propertyB, Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)propertyA, (String)"propertyA cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)propertyB, (String)"propertyB cannot be null");
        return this.getOWLEquivalentObjectPropertiesAxiom(CollectionFactory.createSet((Object[])new OWLObjectPropertyExpression[]{propertyA, propertyB}), annotations);
    }

    @Nonnull
    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalDataPropertyAxiomImpl(property, annotations);
    }

    @Nonnull
    public OWLFunctionalDataPropertyAxiom getOWLFunctionalDataPropertyAxiom(OWLDataPropertyExpression property) {
        return this.getOWLFunctionalDataPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    @Nonnull
    public OWLFunctionalObjectPropertyAxiom getOWLFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLFunctionalObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLImportsDeclaration getOWLImportsDeclaration(IRI importedOntologyIRI) {
        OWLAPIPreconditions.checkNotNull((Object)importedOntologyIRI, (String)"importedOntologyIRI cannot be null");
        return new OWLImportsDeclarationImpl(importedOntologyIRI);
    }

    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)object, (String)OBJECT_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)SUBJECT_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, int value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, double value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, float value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, boolean value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDataPropertyAssertionAxiom getOWLDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, String value) {
        return this.getOWLDataPropertyAssertionAxiom(property, subject, this.getOWLLiteral(value), EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object) {
        return this.getOWLNegativeDataPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLNegativeDataPropertyAssertionAxiom getOWLNegativeDataPropertyAssertionAxiom(OWLDataPropertyExpression property, OWLIndividual subject, OWLLiteral object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)object, (String)OBJECT_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)SUBJECT_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeDataPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    @Nonnull
    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object) {
        return this.getOWLNegativeObjectPropertyAssertionAxiom(property, subject, object, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLNegativeObjectPropertyAssertionAxiom getOWLNegativeObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual subject, OWLIndividual object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)object, (String)OBJECT_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)SUBJECT_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLNegativeObjectPropertyAssertionAxiomImpl(subject, property, object, annotations);
    }

    @Nonnull
    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object) {
        return this.getOWLObjectPropertyAssertionAxiom(property, individual, object, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual) {
        return this.getOWLClassAssertionAxiom(classExpression, individual, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLClassAssertionAxiom getOWLClassAssertionAxiom(OWLClassExpression classExpression, OWLIndividual individual, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)INDIVIDUAL_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLClassAssertionAxiomImpl(individual, classExpression, annotations);
    }

    @Nonnull
    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLInverseFunctionalObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLInverseFunctionalObjectPropertyAxiom getOWLInverseFunctionalObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseFunctionalObjectPropertyAxiomImpl(property, annotations);
    }

    @Nonnull
    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLIrreflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    @Nonnull
    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLReflexiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLIrreflexiveObjectPropertyAxiom getOWLIrreflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLIrreflexiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyDomainAxiomImpl(property, classExpression, annotations);
    }

    @Nonnull
    public OWLObjectPropertyDomainAxiom getOWLObjectPropertyDomainAxiom(OWLObjectPropertyExpression property, OWLClassExpression classExpression) {
        return this.getOWLObjectPropertyDomainAxiom(property, classExpression, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)range, (String)"range cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyRangeAxiomImpl(property, range, annotations);
    }

    @Nonnull
    public OWLObjectPropertyRangeAxiom getOWLObjectPropertyRangeAxiom(OWLObjectPropertyExpression property, OWLClassExpression range) {
        return this.getOWLObjectPropertyRangeAxiom(property, range, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subProperty, (String)"subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)superProperty, (String)SUPER_PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubObjectPropertyOfAxiomImpl(subProperty, superProperty, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Nonnull
    public OWLSubObjectPropertyOfAxiom getOWLSubObjectPropertyOfAxiom(OWLObjectPropertyExpression subProperty, OWLObjectPropertyExpression superProperty) {
        return this.getOWLSubObjectPropertyOfAxiom(subProperty, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLReflexiveObjectPropertyAxiom getOWLReflexiveObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLReflexiveObjectPropertyAxiomImpl(property, annotations);
    }

    @Nonnull
    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(@Nonnull Set<? extends OWLIndividual> individuals, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(individuals, INDIVIDUALS2, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSameIndividualAxiomImpl(individuals, annotations);
    }

    @Nonnull
    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(OWLIndividual ... individual) {
        OWLDataFactoryImpl.checkNull(individual, INDIVIDUALS2, true);
        HashSet<OWLIndividual> inds = new HashSet<OWLIndividual>();
        inds.addAll(Arrays.asList(individual));
        return this.getOWLSameIndividualAxiom(inds);
    }

    @Nonnull
    public OWLSameIndividualAxiom getOWLSameIndividualAxiom(@Nonnull Set<? extends OWLIndividual> individuals) {
        return this.getOWLSameIndividualAxiom(individuals, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subClass, (String)"subclass cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)superClass, (String)"superclass cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubClassOfAxiomImpl(subClass, superClass, annotations);
    }

    @Nonnull
    public OWLSubClassOfAxiom getOWLSubClassOfAxiom(OWLClassExpression subClass, OWLClassExpression superClass) {
        return this.getOWLSubClassOfAxiom(subClass, superClass, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSymmetricObjectPropertyAxiomImpl(property, annotations);
    }

    @Nonnull
    public OWLSymmetricObjectPropertyAxiom getOWLSymmetricObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLSymmetricObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLTransitiveObjectPropertyAxiomImpl(property, annotations);
    }

    @Nonnull
    public OWLTransitiveObjectPropertyAxiom getOWLTransitiveObjectPropertyAxiom(OWLObjectPropertyExpression property) {
        return this.getOWLTransitiveObjectPropertyAxiom(property, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLObjectInverseOf getOWLObjectInverseOf(OWLObjectPropertyExpression property) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        if (!(property instanceof OWLObjectProperty)) {
            throw new IllegalArgumentException("ObjectInverseOf can only be applied to Object Properties");
        }
        return new OWLObjectInverseOfImpl(property);
    }

    @Nonnull
    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)forwardProperty, (String)"forwardProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)inverseProperty, (String)"inverseProperty cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLInverseObjectPropertiesAxiomImpl(forwardProperty, inverseProperty, annotations);
    }

    @Nonnull
    public OWLInverseObjectPropertiesAxiom getOWLInverseObjectPropertiesAxiom(OWLObjectPropertyExpression forwardProperty, OWLObjectPropertyExpression inverseProperty) {
        return this.getOWLInverseObjectPropertiesAxiom(forwardProperty, inverseProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(@Nonnull List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)superProperty, (String)SUPER_PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkNull(chain, "chain", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubPropertyChainAxiomImpl(chain, superProperty, annotations);
    }

    @Nonnull
    public OWLSubPropertyChainOfAxiom getOWLSubPropertyChainOfAxiom(@Nonnull List<? extends OWLObjectPropertyExpression> chain, OWLObjectPropertyExpression superProperty) {
        return this.getOWLSubPropertyChainOfAxiom(chain, superProperty, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, @Nonnull Set<? extends OWLPropertyExpression> objectProperties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)ce, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkNull(objectProperties, PROPERTIES2, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLHasKeyAxiomImpl(ce, objectProperties, annotations);
    }

    @Nonnull
    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, @Nonnull Set<? extends OWLPropertyExpression> properties) {
        return this.getOWLHasKeyAxiom(ce, properties, EMPTY_ANNOTATIONS_SET);
    }

    public OWLHasKeyAxiom getOWLHasKeyAxiom(OWLClassExpression ce, OWLPropertyExpression ... properties) {
        OWLAPIPreconditions.checkNotNull((Object)ce, (String)CLASS_EXPRESSION_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        return this.getOWLHasKeyAxiom(ce, CollectionFactory.createSet((Object[])properties));
    }

    @Nonnull
    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, @Nonnull Set<? extends OWLClassExpression> classExpressions, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)owlClass, (String)"owlClass cannot be null");
        OWLDataFactoryImpl.checkNull(classExpressions, CLASS_EXPRESSIONS, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDisjointUnionAxiomImpl(owlClass, classExpressions, annotations);
    }

    @Nonnull
    public OWLDisjointUnionAxiom getOWLDisjointUnionAxiom(OWLClass owlClass, @Nonnull Set<? extends OWLClassExpression> classExpressions) {
        return this.getOWLDisjointUnionAxiom(owlClass, classExpressions, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLEquivalentObjectPropertiesAxiom getOWLEquivalentObjectPropertiesAxiom(@Nonnull Set<? extends OWLObjectPropertyExpression> properties, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(properties, PROPERTIES2, true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLEquivalentObjectPropertiesAxiomImpl(properties, (Collection<? extends OWLAnnotation>)annotations);
    }

    @Nonnull
    public OWLObjectPropertyAssertionAxiom getOWLObjectPropertyAssertionAxiom(OWLObjectPropertyExpression property, OWLIndividual individual, OWLIndividual object, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)INDIVIDUAL_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)object, (String)OBJECT_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLObjectPropertyAssertionAxiomImpl(individual, property, object, annotations);
    }

    @Nonnull
    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup) {
        return this.getOWLSubAnnotationPropertyOfAxiom(sub, sup, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLSubAnnotationPropertyOfAxiom getOWLSubAnnotationPropertyOfAxiom(OWLAnnotationProperty sub, OWLAnnotationProperty sup, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)sub, (String)"subProperty cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)sup, (String)SUPER_PROPERTY_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLSubAnnotationPropertyOfAxiomImpl(sub, sup, annotations);
    }

    public OWLAnnotationProperty getOWLAnnotationProperty(IRI iri) {
        OWLAPIPreconditions.checkNotNull((Object)iri, (String)IRI_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLAnnotationProperty(iri);
    }

    @Nonnull
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value) {
        return this.getOWLAnnotation(property, value, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLAnnotation getOWLAnnotation(OWLAnnotationProperty property, OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)value, (String)VALUE_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return this.dataFactoryInternals.getOWLAnnotation(property, value, annotations);
    }

    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, @Nonnull OWLAnnotation annotation) {
        OWLAPIPreconditions.checkNotNull((Object)annotation, (String)"annotation cannot be null");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotation.getAnnotations());
    }

    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationSubject subject, @Nonnull OWLAnnotation annotation, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)annotation, (String)"annotation cannot be null");
        return this.getOWLAnnotationAssertionAxiom(annotation.getProperty(), subject, annotation.getValue(), annotations);
    }

    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value) {
        return this.getOWLAnnotationAssertionAxiom(property, subject, value, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLAnnotationAssertionAxiom getOWLAnnotationAssertionAxiom(OWLAnnotationProperty property, OWLAnnotationSubject subject, OWLAnnotationValue value, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)SUBJECT_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)value, (String)VALUE_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationAssertionAxiomImpl(subject, property, value, annotations);
    }

    public OWLAnnotationAssertionAxiom getDeprecatedOWLAnnotationAssertionAxiom(IRI subject) {
        OWLAPIPreconditions.checkNotNull((Object)subject, (String)SUBJECT_CANNOT_BE_NULL);
        return this.getOWLAnnotationAssertionAxiom(this.getOWLDeprecated(), (OWLAnnotationSubject)subject, (OWLAnnotationValue)this.getOWLLiteral(true));
    }

    @Nonnull
    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)prop, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)domain, (String)"domain cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyDomainAxiomImpl(prop, domain, annotations);
    }

    @Nonnull
    public OWLAnnotationPropertyDomainAxiom getOWLAnnotationPropertyDomainAxiom(OWLAnnotationProperty prop, IRI domain) {
        return this.getOWLAnnotationPropertyDomainAxiom(prop, domain, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)prop, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)range, (String)"range cannot be null");
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLAnnotationPropertyRangeAxiomImpl(prop, range, annotations);
    }

    @Nonnull
    public OWLAnnotationPropertyRangeAxiom getOWLAnnotationPropertyRangeAxiom(OWLAnnotationProperty prop, IRI range) {
        return this.getOWLAnnotationPropertyRangeAxiom(prop, range, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public SWRLRule getSWRLRule(@Nonnull Set<? extends SWRLAtom> body, @Nonnull Set<? extends SWRLAtom> head, @Nonnull Set<OWLAnnotation> annotations) {
        OWLDataFactoryImpl.checkNull(body, "body", true);
        OWLDataFactoryImpl.checkNull(head, "head", true);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new SWRLRuleImpl(body, head, annotations);
    }

    @Nonnull
    public SWRLRule getSWRLRule(@Nonnull Set<? extends SWRLAtom> body, @Nonnull Set<? extends SWRLAtom> head) {
        OWLDataFactoryImpl.checkNull(body, "antecedent", true);
        OWLDataFactoryImpl.checkNull(head, "consequent", true);
        return new SWRLRuleImpl(body, head);
    }

    @Nonnull
    public SWRLClassAtom getSWRLClassAtom(OWLClassExpression predicate, SWRLIArgument arg) {
        OWLAPIPreconditions.checkNotNull((Object)predicate, (String)"predicate cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg, (String)"arg cannot be null");
        return new SWRLClassAtomImpl(predicate, arg);
    }

    @Nonnull
    public SWRLDataRangeAtom getSWRLDataRangeAtom(OWLDataRange predicate, SWRLDArgument arg) {
        OWLAPIPreconditions.checkNotNull((Object)predicate, (String)"predicate cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)arg, (String)"arg cannot be null");
        return new SWRLDataRangeAtomImpl(predicate, arg);
    }

    @Nonnull
    public SWRLObjectPropertyAtom getSWRLObjectPropertyAtom(OWLObjectPropertyExpression property, SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)ARG0_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)ARG1_CANNOT_BE_NULL);
        return new SWRLObjectPropertyAtomImpl(property, arg0, arg1);
    }

    @Nonnull
    public SWRLDataPropertyAtom getSWRLDataPropertyAtom(OWLDataPropertyExpression property, SWRLIArgument arg0, SWRLDArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)property, (String)PROPERTY_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)ARG0_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)ARG1_CANNOT_BE_NULL);
        return new SWRLDataPropertyAtomImpl(property, arg0, arg1);
    }

    @Nonnull
    public SWRLBuiltInAtom getSWRLBuiltInAtom(IRI builtInIRI, List<SWRLDArgument> args) {
        OWLAPIPreconditions.checkNotNull((Object)builtInIRI, (String)"builtInIRI cannot be null");
        OWLAPIPreconditions.checkNotNull(args, (String)"args cannot be null");
        return new SWRLBuiltInAtomImpl(builtInIRI, args);
    }

    @Nonnull
    public SWRLVariable getSWRLVariable(IRI var) {
        OWLAPIPreconditions.checkNotNull((Object)var, (String)"var cannot be null");
        return new SWRLVariableImpl(var);
    }

    @Nonnull
    public SWRLIndividualArgument getSWRLIndividualArgument(OWLIndividual individual) {
        OWLAPIPreconditions.checkNotNull((Object)individual, (String)INDIVIDUAL_CANNOT_BE_NULL);
        return new SWRLIndividualArgumentImpl(individual);
    }

    @Nonnull
    public SWRLLiteralArgument getSWRLLiteralArgument(OWLLiteral literal) {
        OWLAPIPreconditions.checkNotNull((Object)literal, (String)"literal");
        return new SWRLLiteralArgumentImpl(literal);
    }

    @Nonnull
    public SWRLDifferentIndividualsAtom getSWRLDifferentIndividualsAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)ARG0_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)ARG1_CANNOT_BE_NULL);
        return new SWRLDifferentIndividualsAtomImpl(this.getOWLObjectProperty(OWLRDFVocabulary.OWL_DIFFERENT_FROM.getIRI()), arg0, arg1);
    }

    @Nonnull
    public SWRLSameIndividualAtom getSWRLSameIndividualAtom(SWRLIArgument arg0, SWRLIArgument arg1) {
        OWLAPIPreconditions.checkNotNull((Object)arg0, (String)ARG0_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)arg1, (String)ARG1_CANNOT_BE_NULL);
        return new SWRLSameIndividualAtomImpl(this.getOWLObjectProperty(OWLRDFVocabulary.OWL_SAME_AS.getIRI()), arg0, arg1);
    }

    @Nonnull
    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange) {
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)DATATYPE_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        return this.getOWLDatatypeDefinitionAxiom(datatype, dataRange, EMPTY_ANNOTATIONS_SET);
    }

    @Nonnull
    public OWLDatatypeDefinitionAxiom getOWLDatatypeDefinitionAxiom(OWLDatatype datatype, OWLDataRange dataRange, @Nonnull Set<? extends OWLAnnotation> annotations) {
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)DATATYPE_CANNOT_BE_NULL);
        OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)DATA_RANGE_CANNOT_BE_NULL);
        OWLDataFactoryImpl.checkAnnotations(annotations);
        return new OWLDatatypeDefinitionAxiomImpl(datatype, dataRange, annotations);
    }

    public OWLLiteral getOWLLiteral(String lexicalValue, OWLDatatype datatype) {
        OWLAPIPreconditions.checkNotNull((Object)lexicalValue, (String)"lexicalValue cannot be null");
        OWLAPIPreconditions.checkNotNull((Object)datatype, (String)DATATYPE_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLLiteral(lexicalValue, datatype);
    }

    public OWLLiteral getOWLLiteral(int value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(double value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(float value) {
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(String value) {
        OWLAPIPreconditions.checkNotNull((Object)value, (String)VALUE_CANNOT_BE_NULL);
        return this.dataFactoryInternals.getOWLLiteral(value);
    }

    public OWLLiteral getOWLLiteral(String literal, String lang) {
        OWLAPIPreconditions.checkNotNull((Object)literal, (String)"literal cannot be null");
        return this.dataFactoryInternals.getOWLLiteral(literal, lang);
    }

    public OWLDatatype getBooleanOWLDatatype() {
        return this.dataFactoryInternals.getBooleanOWLDatatype();
    }

    public OWLDatatype getDoubleOWLDatatype() {
        return this.dataFactoryInternals.getDoubleOWLDatatype();
    }

    public OWLDatatype getFloatOWLDatatype() {
        return this.dataFactoryInternals.getFloatOWLDatatype();
    }

    public OWLDatatype getIntegerOWLDatatype() {
        return this.dataFactoryInternals.getIntegerOWLDatatype();
    }

    public OWLDatatype getTopDatatype() {
        return this.dataFactoryInternals.getTopDatatype();
    }

    public OWLDatatype getRDFPlainLiteral() {
        return this.dataFactoryInternals.getRDFPlainLiteral();
    }
}

