/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLAxiomImplWithoutEntityAndAnonCaching;

public class OWLDatatypeDefinitionAxiomImpl
extends OWLAxiomImplWithoutEntityAndAnonCaching
implements OWLDatatypeDefinitionAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final OWLDatatype datatype;
    @Nonnull
    private final OWLDataRange dataRange;

    public OWLDatatypeDefinitionAxiomImpl(@Nonnull OWLDatatype datatype, @Nonnull OWLDataRange dataRange, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.datatype = (OWLDatatype)OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        this.dataRange = (OWLDataRange)OWLAPIPreconditions.checkNotNull((Object)dataRange, (String)"dataRange cannot be null");
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.datatype);
        this.addSignatureEntitiesToSetForValue(entities, (HasSignature)this.dataRange);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        this.addAnonymousIndividualsToSetForValue(anons, (HasAnonymousIndividuals)this.dataRange);
    }

    public OWLAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLDatatypeDefinitionAxiomImpl(this.getDatatype(), this.getDataRange(), NO_ANNOTATIONS);
    }

    public OWLDatatypeDefinitionAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLDatatypeDefinitionAxiomImpl(this.getDatatype(), this.getDataRange(), this.mergeAnnos(annotations));
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    public OWLDataRange getDataRange() {
        return this.dataRange;
    }

    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit((OWLDatatypeDefinitionAxiom)this);
    }

    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatypeDefinitionAxiom)this);
    }

    public boolean isLogicalAxiom() {
        return true;
    }

    public boolean isAnnotationAxiom() {
        return false;
    }

    public AxiomType<?> getAxiomType() {
        return AxiomType.DATATYPE_DEFINITION;
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLDatatypeDefinitionAxiom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLDatatypeDefinitionAxiom)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLDatatypeDefinitionAxiom other = (OWLDatatypeDefinitionAxiom)object;
        int diff = this.getDatatype().compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.getDataRange().compareTo((Object)other.getDataRange());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLDatatypeDefinitionAxiom)) {
            return false;
        }
        OWLDatatypeDefinitionAxiom other = (OWLDatatypeDefinitionAxiom)obj;
        return this.datatype.equals((Object)other.getDatatype()) && this.dataRange.equals((Object)other.getDataRange());
    }
}

