/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImplInteger
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 40000L;
    private final int literal;
    @Nonnull
    private final OWLDatatype datatype;
    private final int hashcode;

    @Override
    protected int index() {
        return 4008;
    }

    public OWLLiteralImplInteger(int literal, @Nonnull OWLDatatype datatype) {
        this.literal = literal;
        this.datatype = (OWLDatatype)OWLAPIPreconditions.checkNotNull((Object)datatype, (String)"datatype cannot be null");
        this.hashcode = this.getHashCode();
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add((OWLEntity)this.datatype);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    private int getHashCode() {
        int code = 277;
        code = code * 37 + this.getDatatype().hashCode();
        code = code * 37 + this.literal * 65536;
        return code;
    }

    public String getLiteral() {
        return Integer.toString(this.literal);
    }

    public boolean isRDFPlainLiteral() {
        return false;
    }

    public boolean hasLang() {
        return false;
    }

    public boolean isInteger() {
        return true;
    }

    public int parseInteger() {
        return this.literal;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean parseBoolean() {
        throw new NumberFormatException("this literal is not a boolean but a int");
    }

    public boolean isDouble() {
        return false;
    }

    public double parseDouble() {
        throw new NumberFormatException("this literal is not a double but a int");
    }

    public boolean isFloat() {
        return false;
    }

    public float parseFloat() {
        throw new NumberFormatException("this literal is not a float but a int");
    }

    @Nonnull
    public String getLang() {
        return "";
    }

    public boolean hasLang(String lang) {
        return false;
    }

    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof OWLLiteralImplInteger) {
            OWLLiteralImplInteger other = (OWLLiteralImplInteger)obj;
            return this.literal == other.literal;
        }
        if (obj instanceof OWLLiteral) {
            return ((OWLLiteral)obj).isInteger() && ((OWLLiteral)obj).getLiteral().charAt(0) != '0' && this.literal == ((OWLLiteral)obj).parseInteger();
        }
        return false;
    }

    public void accept(OWLDataVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLDataVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public void accept(OWLAnnotationValueVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLAnnotationValueVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.datatype.compareTo((Object)other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        diff = this.getLiteral().compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        return Integer.compare(this.literal, other.parseInteger());
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((OWLLiteral)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((OWLLiteral)this);
    }

    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

