/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPairwiseVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyAxiomImplWithoutEntityAndAnonCaching;

public abstract class OWLNaryPropertyAxiomImpl<P extends OWLPropertyExpression>
extends OWLPropertyAxiomImplWithoutEntityAndAnonCaching
implements OWLNaryPropertyAxiom<P> {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    protected final List<P> properties;

    public OWLNaryPropertyAxiomImpl(@Nonnull Set<? extends P> properties, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        OWLAPIPreconditions.checkNotNull(properties, (String)"properties cannot be null");
        this.properties = CollectionFactory.sortOptionally(properties);
    }

    @SafeVarargs
    OWLNaryPropertyAxiomImpl(@Nonnull Collection<? extends OWLAnnotation> annotations, P ... properties) {
        super(annotations);
        OWLAPIPreconditions.checkNotNull(properties, (String)"properties cannot be null");
        Arrays.sort(properties);
        this.properties = Arrays.asList(properties);
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        for (HasSignature hasSignature : this.getProperties()) {
            this.addSignatureEntitiesToSetForValue(entities, hasSignature);
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        for (HasAnonymousIndividuals hasAnons : this.getProperties()) {
            this.addAnonymousIndividualsToSetForValue(anons, hasAnons);
        }
    }

    public Set<P> getProperties() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.properties);
    }

    public Set<P> getPropertiesMinus(P property) {
        TreeSet<P> props = new TreeSet<P>(this.properties);
        props.remove(property);
        return props;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLNaryPropertyAxiom)) {
            return false;
        }
        if (obj instanceof OWLNaryPropertyAxiomImpl) {
            return this.properties.equals(((OWLNaryPropertyAxiomImpl)obj).properties);
        }
        return this.compareObjectOfSameType((OWLObject)((OWLNaryPropertyAxiom)obj)) == 0;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLNaryPropertyAxiomImpl.compareSets(this.properties, ((OWLNaryPropertyAxiom)object).getProperties());
    }

    public <T> Collection<T> walkPairwise(OWLPairwiseVisitor<T, P> visitor) {
        ArrayList<Object> l = new ArrayList<Object>();
        for (int i = 0; i < this.properties.size() - 1; ++i) {
            for (int j = i + 1; j < this.properties.size(); ++j) {
                Object t = visitor.visit((Object)((OWLPropertyExpression)this.properties.get(i)), (Object)((OWLPropertyExpression)this.properties.get(j)));
                if (t == null) continue;
                l.add(t);
            }
        }
        return l;
    }
}

