/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.HasAnonymousIndividuals;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLObjectVisitor;
import org.semanticweb.owlapi.model.SWRLObjectVisitorEx;
import org.semanticweb.owlapi.model.SWRLPredicate;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.SWRLBuiltInsVocabulary;
import uk.ac.manchester.cs.owl.owlapi.SWRLAtomImpl;

public class SWRLBuiltInAtomImpl
extends SWRLAtomImpl
implements SWRLBuiltInAtom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<SWRLDArgument> args;

    @Override
    protected int index() {
        return 6005;
    }

    public SWRLBuiltInAtomImpl(@Nonnull IRI predicate, @Nonnull List<SWRLDArgument> args) {
        super((SWRLPredicate)predicate);
        this.args = new ArrayList<SWRLDArgument>((Collection)OWLAPIPreconditions.checkNotNull(args, (String)"args cannot be null"));
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        for (SWRLDArgument arg : this.args) {
            this.addSignatureEntitiesToSetForValue(entities, (HasSignature)arg);
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        for (SWRLDArgument arg : this.args) {
            this.addAnonymousIndividualsToSetForValue(anons, (HasAnonymousIndividuals)arg);
        }
    }

    public IRI getPredicate() {
        return (IRI)super.getPredicate();
    }

    public boolean isCoreBuiltIn() {
        return SWRLBuiltInsVocabulary.getBuiltIn((IRI)this.getPredicate()) != null;
    }

    public List<SWRLDArgument> getArguments() {
        return new ArrayList<SWRLDArgument>(this.args);
    }

    public Collection<SWRLArgument> getAllArguments() {
        return new ArrayList<SWRLDArgument>(this.args);
    }

    public void accept(OWLObjectVisitor visitor) {
        visitor.visit((SWRLBuiltInAtom)this);
    }

    public void accept(SWRLObjectVisitor visitor) {
        visitor.visit((SWRLBuiltInAtom)this);
    }

    public <O> O accept(SWRLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((SWRLBuiltInAtom)this);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)visitor.visit((SWRLBuiltInAtom)this);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SWRLBuiltInAtom)) {
            return false;
        }
        SWRLBuiltInAtom other = (SWRLBuiltInAtom)obj;
        return other.getPredicate().equals((Object)this.getPredicate()) && other.getArguments().equals(this.getArguments());
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        SWRLBuiltInAtom other = (SWRLBuiltInAtom)object;
        int diff = this.getPredicate().compareTo((OWLObject)other.getPredicate());
        if (diff != 0) {
            return diff;
        }
        List otherArgs = other.getArguments();
        for (int i = 0; i < this.args.size() && i < otherArgs.size(); ++i) {
            diff = this.args.get(i).compareTo((Object)((OWLObject)otherArgs.get(i)));
            if (diff == 0) continue;
            return diff;
        }
        return this.args.size() - otherArgs.size();
    }
}

