/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi.concurrent;

import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import uk.ac.manchester.cs.owl.owlapi.HasTrimToSize;

public class ConcurrentOWLOntologyImpl
implements OWLMutableOntology,
HasTrimToSize {
    private final OWLOntology delegate;
    private ReadWriteLock lock;

    @Inject
    public ConcurrentOWLOntologyImpl(@Nonnull OWLOntology delegate, @Nonnull ReadWriteLock readWriteLock) {
        this.delegate = (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)delegate);
        this.lock = (ReadWriteLock)OWLAPIPreconditions.verifyNotNull((Object)readWriteLock);
    }

    public void setLock(ReadWriteLock lock) {
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withWriteLock(Supplier<T> t) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            T t2 = t.get();
            return t2;
        }
        finally {
            writeLock.unlock();
        }
    }

    private void callWriteLock(Runnable t) {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            t.run();
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withReadLock(Supplier<T> t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            T t2 = t.get();
            return t2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean withBooleanReadLock(BooleanSupplier t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = t.getAsBoolean();
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int withIntReadLock(IntSupplier t) {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int n = t.getAsInt();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    private void callReadLock(Store t) throws OWLOntologyStorageException {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        try {
            t.store();
        }
        finally {
            readLock.unlock();
        }
    }

    @Override
    public void trimToSize() {
        this.callWriteLock(this::trimToSizeInternal);
    }

    protected void trimToSizeInternal() {
        if (this.delegate instanceof HasTrimToSize) {
            HasTrimToSize trimmableDelegate = (HasTrimToSize)this.delegate;
            trimmableDelegate.trimToSize();
        }
    }

    public void accept(@Nonnull OWLNamedObjectVisitor owlNamedObjectVisitor) {
        this.delegate.accept(owlNamedObjectVisitor);
    }

    @Nonnull
    public <O> O accept(@Nonnull OWLNamedObjectVisitorEx<O> owlNamedObjectVisitorEx) {
        return (O)this.delegate.accept(owlNamedObjectVisitorEx);
    }

    public int hashCode() {
        return this.withIntReadLock(() -> ((OWLOntology)this.delegate).hashCode());
    }

    public boolean equals(Object obj) {
        return this.withBooleanReadLock(() -> this.delegate.equals(obj));
    }

    @Nonnull
    public OWLOntologyManager getOWLOntologyManager() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getOWLOntologyManager());
    }

    public void setOWLOntologyManager(OWLOntologyManager owlOntologyManager) {
        this.callWriteLock(() -> this.delegate.setOWLOntologyManager(owlOntologyManager));
    }

    @Nonnull
    public OWLOntologyID getOntologyID() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getOntologyID());
    }

    public boolean isAnonymous() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isAnonymous());
    }

    @Nonnull
    public Set<OWLAnnotation> getAnnotations() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAnnotations());
    }

    @Nonnull
    public Set<IRI> getDirectImportsDocuments() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDirectImportsDocuments());
    }

    @Nonnull
    public Set<OWLOntology> getDirectImports() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDirectImports());
    }

    @Nonnull
    public Set<OWLOntology> getImports() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getImports());
    }

    @Nonnull
    public Set<OWLOntology> getImportsClosure() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getImportsClosure());
    }

    @Nonnull
    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getImportsDeclarations());
    }

    public boolean isEmpty() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isEmpty());
    }

    @Nonnull
    public Set<OWLAxiom> getTBoxAxioms(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getTBoxAxioms(imports));
    }

    @Nonnull
    public Set<OWLAxiom> getABoxAxioms(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getABoxAxioms(imports));
    }

    @Nonnull
    public Set<OWLAxiom> getRBoxAxioms(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getRBoxAxioms(imports));
    }

    @Nonnull
    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getGeneralClassAxioms());
    }

    @Nonnull
    public Set<OWLEntity> getSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getSignature());
    }

    @Nonnull
    public Set<OWLEntity> getSignature(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getSignature(imports));
    }

    public boolean isDeclared(@Nonnull OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.isDeclared(owlEntity));
    }

    public boolean isDeclared(@Nonnull OWLEntity owlEntity, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.isDeclared(owlEntity, imports));
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology());
    }

    public void saveOntology(@Nonnull IRI iri) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(iri));
    }

    public void saveOntology(@Nonnull OutputStream outputStream) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(outputStream));
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat));
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat, @Nonnull IRI iri) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, iri));
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat, @Nonnull OutputStream outputStream) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, outputStream));
    }

    public void saveOntology(@Nonnull OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlOntologyDocumentTarget));
    }

    public void saveOntology(@Nonnull OWLDocumentFormat owlDocumentFormat, @Nonnull OWLOntologyDocumentTarget owlOntologyDocumentTarget) throws OWLOntologyStorageException {
        this.callReadLock(() -> this.delegate.saveOntology(owlDocumentFormat, owlOntologyDocumentTarget));
    }

    @Nonnull
    public Set<OWLClassExpression> getNestedClassExpressions() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getNestedClassExpressions());
    }

    public void accept(@Nonnull OWLObjectVisitor owlObjectVisitor) {
        this.delegate.accept(owlObjectVisitor);
    }

    @Nonnull
    public <O> O accept(@Nonnull OWLObjectVisitorEx<O> owlObjectVisitorEx) {
        return (O)this.delegate.accept(owlObjectVisitorEx);
    }

    public boolean isTopEntity() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isTopEntity());
    }

    public boolean isBottomEntity() {
        return this.withBooleanReadLock(() -> ((OWLOntology)this.delegate).isBottomEntity());
    }

    @Nonnull
    public String toString() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).toString());
    }

    public int compareTo(OWLObject o) {
        return this.withIntReadLock(() -> this.delegate.compareTo((Object)o));
    }

    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity));
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntitiesOfTypeInSignature(type));
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type, Imports includeImportsClosure) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntitiesOfTypeInSignature(type, includeImportsClosure));
    }

    @Nonnull
    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAnonymousIndividuals());
    }

    @Nonnull
    public Set<OWLClass> getClassesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getClassesInSignature());
    }

    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getObjectPropertiesInSignature());
    }

    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDataPropertiesInSignature());
    }

    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getIndividualsInSignature());
    }

    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getDatatypesInSignature());
    }

    @Nonnull
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAnnotationPropertiesInSignature());
    }

    @Nonnull
    public Set<OWLAxiom> getAxioms(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(imports));
    }

    public int getAxiomCount(@Nonnull Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(imports));
    }

    @Nonnull
    public Set<OWLLogicalAxiom> getLogicalAxioms(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getLogicalAxioms(imports));
    }

    public int getLogicalAxiomCount(@Nonnull Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getLogicalAxiomCount(imports));
    }

    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull AxiomType<T> axiomType, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType, imports));
    }

    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType, @Nonnull Imports imports) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType, imports));
    }

    public boolean containsAxiom(@Nonnull OWLAxiom owlAxiom, @Nonnull Imports imports, @Nonnull AxiomAnnotations axiomAnnotations) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom, imports, axiomAnnotations));
    }

    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, imports));
    }

    @Nonnull
    public Set<OWLAxiom> getReferencingAxioms(@Nonnull OWLPrimitive owlPrimitive, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive, imports));
    }

    @Nonnull
    public Set<OWLClassAxiom> getAxioms(@Nonnull OWLClass owlClass, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass, imports));
    }

    @Nonnull
    public Set<OWLObjectPropertyAxiom> getAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression, imports));
    }

    @Nonnull
    public Set<OWLDataPropertyAxiom> getAxioms(@Nonnull OWLDataProperty owlDataProperty, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty, imports));
    }

    @Nonnull
    public Set<OWLIndividualAxiom> getAxioms(@Nonnull OWLIndividual owlIndividual, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual, imports));
    }

    @Nonnull
    public Set<OWLAnnotationAxiom> getAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty, imports));
    }

    @Nonnull
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(@Nonnull OWLDatatype owlDatatype, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype, imports));
    }

    @Nonnull
    public Set<OWLAxiom> getAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getAxioms());
    }

    @Nonnull
    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return this.withReadLock(() -> ((OWLOntology)this.delegate).getLogicalAxioms());
    }

    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull AxiomType<T> axiomType) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType));
    }

    public boolean containsAxiom(@Nonnull OWLAxiom owlAxiom) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom));
    }

    @Nonnull
    @Deprecated
    public Set<OWLAxiom> getAxioms(boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(b));
    }

    @Deprecated
    public int getAxiomCount(boolean b) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLLogicalAxiom> getLogicalAxioms(boolean b) {
        return this.withReadLock(() -> this.delegate.getLogicalAxioms(b));
    }

    @Deprecated
    public int getLogicalAxiomCount(boolean b) {
        return this.withIntReadLock(() -> this.delegate.getLogicalAxiomCount(b));
    }

    @Deprecated
    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull AxiomType<T> axiomType, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(axiomType, b));
    }

    @Deprecated
    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType, boolean b) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType, b));
    }

    @Deprecated
    public boolean containsAxiom(@Nonnull OWLAxiom owlAxiom, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiom(owlAxiom, b));
    }

    @Deprecated
    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiomIgnoreAnnotations(owlAxiom, b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom, b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLAxiom> getReferencingAxioms(@Nonnull OWLPrimitive owlPrimitive, boolean b) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive, b));
    }

    @Nonnull
    @Deprecated
    public Set<OWLClassAxiom> getAxioms(@Nonnull OWLClass owlClass, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass, b));
    }

    @Nonnull
    @Deprecated
    public Set<OWLObjectPropertyAxiom> getAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression, b));
    }

    @Nonnull
    @Deprecated
    public Set<OWLDataPropertyAxiom> getAxioms(@Nonnull OWLDataProperty owlDataProperty, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty, b));
    }

    @Nonnull
    @Deprecated
    public Set<OWLIndividualAxiom> getAxioms(@Nonnull OWLIndividual owlIndividual, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual, b));
    }

    @Nonnull
    @Deprecated
    public Set<OWLAnnotationAxiom> getAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty, b));
    }

    @Nonnull
    @Deprecated
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(@Nonnull OWLDatatype owlDatatype, boolean b) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype, b));
    }

    public int getAxiomCount() {
        return this.withIntReadLock(() -> ((OWLOntology)this.delegate).getAxiomCount());
    }

    public int getLogicalAxiomCount() {
        return this.withIntReadLock(() -> ((OWLOntology)this.delegate).getLogicalAxiomCount());
    }

    public <T extends OWLAxiom> int getAxiomCount(@Nonnull AxiomType<T> axiomType) {
        return this.withIntReadLock(() -> this.delegate.getAxiomCount(axiomType));
    }

    public boolean containsAxiomIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom) {
        return this.withBooleanReadLock(() -> this.delegate.containsAxiomIgnoreAnnotations(owlAxiom));
    }

    @Nonnull
    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(@Nonnull OWLAxiom owlAxiom) {
        return this.withReadLock(() -> this.delegate.getAxiomsIgnoreAnnotations(owlAxiom));
    }

    @Nonnull
    public Set<OWLAxiom> getReferencingAxioms(@Nonnull OWLPrimitive owlPrimitive) {
        return this.withReadLock(() -> this.delegate.getReferencingAxioms(owlPrimitive));
    }

    @Nonnull
    @Deprecated
    public Set<OWLClassAxiom> getAxioms(@Nonnull OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlClass));
    }

    @Nonnull
    @Deprecated
    public Set<OWLObjectPropertyAxiom> getAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    @Deprecated
    public Set<OWLDataPropertyAxiom> getAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDataProperty));
    }

    @Nonnull
    @Deprecated
    public Set<OWLIndividualAxiom> getAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlIndividual));
    }

    @Nonnull
    @Deprecated
    public Set<OWLAnnotationAxiom> getAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlAnnotationProperty));
    }

    @Nonnull
    @Deprecated
    public Set<OWLDatatypeDefinitionAxiom> getAxioms(@Nonnull OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.getAxioms(owlDatatype));
    }

    @Nonnull
    public Set<OWLClass> getClassesInSignature(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getClassesInSignature(imports));
    }

    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getObjectPropertiesInSignature(imports));
    }

    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getDataPropertiesInSignature(imports));
    }

    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getIndividualsInSignature(imports));
    }

    @Nonnull
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getReferencedAnonymousIndividuals(imports));
    }

    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getDatatypesInSignature(imports));
    }

    @Nonnull
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertiesInSignature(imports));
    }

    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity, imports));
    }

    public boolean containsEntityInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri, imports));
    }

    public boolean containsClassInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri, imports));
    }

    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri, imports));
    }

    public boolean containsDataPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri, imports));
    }

    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri, imports));
    }

    public boolean containsDatatypeInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri, imports));
    }

    public boolean containsIndividualInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri, imports));
    }

    public boolean containsDatatypeInSignature(@Nonnull IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri));
    }

    public boolean containsEntityInSignature(@Nonnull IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri));
    }

    public boolean containsClassInSignature(@Nonnull IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(@Nonnull IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri));
    }

    public boolean containsIndividualInSignature(@Nonnull IRI iri) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri));
    }

    @Nonnull
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI iri, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri, imports));
    }

    public Set<IRI> getPunnedIRIs(@Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.getPunnedIRIs(imports));
    }

    public boolean containsReference(@Nonnull OWLEntity owlEntity, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity, imports));
    }

    public boolean containsReference(@Nonnull OWLEntity owlEntity) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity));
    }

    @Nonnull
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI iri) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri));
    }

    @Deprecated
    @Nonnull
    public Set<OWLClass> getClassesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getClassesInSignature(b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLObjectProperty> getObjectPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getObjectPropertiesInSignature(b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLDataProperty> getDataPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getDataPropertiesInSignature(b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLNamedIndividual> getIndividualsInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getIndividualsInSignature(b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(boolean b) {
        return this.withReadLock(() -> this.delegate.getReferencedAnonymousIndividuals(b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLDatatype> getDatatypesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getDatatypesInSignature(b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(boolean b) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertiesInSignature(b));
    }

    @Deprecated
    public boolean containsEntityInSignature(@Nonnull OWLEntity owlEntity, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(owlEntity, b));
    }

    @Deprecated
    public boolean containsEntityInSignature(@Nonnull IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsEntityInSignature(iri, b));
    }

    @Deprecated
    public boolean containsClassInSignature(@Nonnull IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsClassInSignature(iri, b));
    }

    @Deprecated
    public boolean containsObjectPropertyInSignature(@Nonnull IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsObjectPropertyInSignature(iri, b));
    }

    @Deprecated
    public boolean containsDataPropertyInSignature(@Nonnull IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsDataPropertyInSignature(iri, b));
    }

    @Deprecated
    public boolean containsAnnotationPropertyInSignature(@Nonnull IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsAnnotationPropertyInSignature(iri, b));
    }

    @Deprecated
    public boolean containsDatatypeInSignature(@Nonnull IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsDatatypeInSignature(iri, b));
    }

    @Deprecated
    public boolean containsIndividualInSignature(@Nonnull IRI iri, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsIndividualInSignature(iri, b));
    }

    @Deprecated
    @Nonnull
    public Set<OWLEntity> getEntitiesInSignature(@Nonnull IRI iri, boolean b) {
        return this.withReadLock(() -> this.delegate.getEntitiesInSignature(iri, b));
    }

    @Deprecated
    public boolean containsReference(@Nonnull OWLEntity owlEntity, boolean b) {
        return this.withBooleanReadLock(() -> this.delegate.containsReference(owlEntity, b));
    }

    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull Class<T> aClass, @Nonnull OWLObject owlObject, @Nonnull Imports imports, @Nonnull Navigation navigation) {
        return this.withReadLock(() -> this.delegate.getAxioms(aClass, owlObject, imports, navigation));
    }

    @Nonnull
    public <T extends OWLAxiom> Collection<T> filterAxioms(@Nonnull OWLAxiomSearchFilter owlAxiomSearchFilter, @Nonnull Object o, @Nonnull Imports imports) {
        return this.withReadLock(() -> this.delegate.filterAxioms(owlAxiomSearchFilter, o, imports));
    }

    public boolean contains(@Nonnull OWLAxiomSearchFilter owlAxiomSearchFilter, @Nonnull Object o, @Nonnull Imports imports) {
        return this.withBooleanReadLock(() -> this.delegate.contains(owlAxiomSearchFilter, o, imports));
    }

    @Nonnull
    public <T extends OWLAxiom> Set<T> getAxioms(@Nonnull Class<T> aClass, @Nonnull Class<? extends OWLObject> aClass1, @Nonnull OWLObject owlObject, @Nonnull Imports imports, @Nonnull Navigation navigation) {
        return this.withReadLock(() -> this.delegate.getAxioms(aClass, aClass1, owlObject, imports, navigation));
    }

    @Nonnull
    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getSubAnnotationPropertyOfAxioms(owlAnnotationProperty));
    }

    @Nonnull
    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertyDomainAxioms(owlAnnotationProperty));
    }

    @Nonnull
    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(@Nonnull OWLAnnotationProperty owlAnnotationProperty) {
        return this.withReadLock(() -> this.delegate.getAnnotationPropertyRangeAxioms(owlAnnotationProperty));
    }

    @Nonnull
    public Set<OWLDeclarationAxiom> getDeclarationAxioms(@Nonnull OWLEntity owlEntity) {
        return this.withReadLock(() -> this.delegate.getDeclarationAxioms(owlEntity));
    }

    @Nonnull
    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(@Nonnull OWLAnnotationSubject owlAnnotationSubject) {
        return this.withReadLock(() -> this.delegate.getAnnotationAssertionAxioms(owlAnnotationSubject));
    }

    @Nonnull
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(@Nonnull OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getSubClassAxiomsForSubClass(owlClass));
    }

    @Nonnull
    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(@Nonnull OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getSubClassAxiomsForSuperClass(owlClass));
    }

    @Nonnull
    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(@Nonnull OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getEquivalentClassesAxioms(owlClass));
    }

    @Nonnull
    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(@Nonnull OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getDisjointClassesAxioms(owlClass));
    }

    @Nonnull
    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(@Nonnull OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getDisjointUnionAxioms(owlClass));
    }

    @Nonnull
    public Set<OWLHasKeyAxiom> getHasKeyAxioms(@Nonnull OWLClass owlClass) {
        return this.withReadLock(() -> this.delegate.getHasKeyAxioms(owlClass));
    }

    @Nonnull
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectSubPropertyAxiomsForSubProperty(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectSubPropertyAxiomsForSuperProperty(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyDomainAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyRangeAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getInverseObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getEquivalentObjectPropertiesAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getDisjointObjectPropertiesAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getFunctionalObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getInverseFunctionalObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getSymmetricObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getAsymmetricObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getReflexiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getIrreflexiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(@Nonnull OWLObjectPropertyExpression owlObjectPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getTransitiveObjectPropertyAxioms(owlObjectPropertyExpression));
    }

    @Nonnull
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(@Nonnull OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataSubPropertyAxiomsForSubProperty(owlDataProperty));
    }

    @Nonnull
    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(@Nonnull OWLDataPropertyExpression owlDataPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getDataSubPropertyAxiomsForSuperProperty(owlDataPropertyExpression));
    }

    @Nonnull
    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataPropertyDomainAxioms(owlDataProperty));
    }

    @Nonnull
    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDataPropertyRangeAxioms(owlDataProperty));
    }

    @Nonnull
    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getEquivalentDataPropertiesAxioms(owlDataProperty));
    }

    @Nonnull
    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(@Nonnull OWLDataProperty owlDataProperty) {
        return this.withReadLock(() -> this.delegate.getDisjointDataPropertiesAxioms(owlDataProperty));
    }

    @Nonnull
    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(@Nonnull OWLDataPropertyExpression owlDataPropertyExpression) {
        return this.withReadLock(() -> this.delegate.getFunctionalDataPropertyAxioms(owlDataPropertyExpression));
    }

    @Nonnull
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getClassAssertionAxioms(owlIndividual));
    }

    @Nonnull
    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(@Nonnull OWLClassExpression owlClassExpression) {
        return this.withReadLock(() -> this.delegate.getClassAssertionAxioms(owlClassExpression));
    }

    @Nonnull
    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getDataPropertyAssertionAxioms(owlIndividual));
    }

    @Nonnull
    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getObjectPropertyAssertionAxioms(owlIndividual));
    }

    @Nonnull
    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getNegativeObjectPropertyAssertionAxioms(owlIndividual));
    }

    @Nonnull
    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getNegativeDataPropertyAssertionAxioms(owlIndividual));
    }

    @Nonnull
    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getSameIndividualAxioms(owlIndividual));
    }

    @Nonnull
    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(@Nonnull OWLIndividual owlIndividual) {
        return this.withReadLock(() -> this.delegate.getDifferentIndividualAxioms(owlIndividual));
    }

    @Nonnull
    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(@Nonnull OWLDatatype owlDatatype) {
        return this.withReadLock(() -> this.delegate.getDatatypeDefinitions(owlDatatype));
    }

    @Nonnull
    public ChangeApplied applyChange(@Nonnull OWLOntologyChange owlOntologyChange) {
        return this.withWriteLock(() -> this.getMutableOntology().applyChange(owlOntologyChange));
    }

    @Nonnull
    public ChangeApplied applyChanges(@Nonnull List<? extends OWLOntologyChange> list) {
        return this.withWriteLock(() -> this.getMutableOntology().applyChanges(list));
    }

    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> list) {
        return this.withWriteLock(() -> this.getMutableOntology().applyChangesAndGetDetails(list));
    }

    @Nonnull
    public ChangeApplied addAxiom(@Nonnull OWLAxiom owlAxiom) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxiom(owlAxiom));
    }

    public ChangeApplied addAxioms(@Nonnull Set<? extends OWLAxiom> set) {
        return this.withWriteLock(() -> this.getMutableOntology().addAxioms(set));
    }

    private OWLMutableOntology getMutableOntology() {
        return (OWLMutableOntology)this.delegate;
    }

    private static interface Store {
        public void store() throws OWLOntologyStorageException;
    }
}

