/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss1.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.formats.KRSSDocumentFormat;
import org.semanticweb.owlapi.formats.KRSSDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.krss1.parser.KRSSOWLParserException;
import org.semanticweb.owlapi.krss1.parser.KRSSParser;
import org.semanticweb.owlapi.krss1.parser.ParseException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class KRSSOWLParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;

    @Nonnull
    public String getName() {
        return "KRSSOWLParser";
    }

    public OWLDocumentFormatFactory getSupportedFormat() {
        return new KRSSDocumentFormatFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        try {
            KRSSParser parser;
            if (documentSource.isReaderAvailable()) {
                parser = new KRSSParser(documentSource.getReader());
            } else if (documentSource.isInputStreamAvailable()) {
                parser = new KRSSParser(documentSource.getInputStream());
            } else {
                try (InputStream is = null;){
                    if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:")) {
                        if (documentSource.getDocumentIRI().getNamespace().startsWith("jar:!")) {
                            Object name = documentSource.getDocumentIRI().toString().substring(5);
                            if (!((String)name).startsWith("/")) {
                                name = "/" + (String)name;
                            }
                            is = ((Object)((Object)this)).getClass().getResourceAsStream((String)name);
                        } else {
                            try {
                                is = ((JarURLConnection)new URL(documentSource.getDocumentIRI().toString()).openConnection()).getInputStream();
                            }
                            catch (IOException e) {
                                throw new OWLParserException((Throwable)e);
                            }
                        }
                    } else {
                        Optional headers = documentSource.getAcceptHeaders();
                        is = headers.isPresent() ? this.getInputStream(documentSource.getDocumentIRI(), configuration, (String)headers.get()) : this.getInputStream(documentSource.getDocumentIRI(), configuration, "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09");
                    }
                    parser = new KRSSParser(is);
                }
            }
            parser.setOntology(ontology, ontology.getOWLOntologyManager().getOWLDataFactory());
            parser.parse();
            return new KRSSDocumentFormat();
        }
        catch (ParseException e) {
            throw new KRSSOWLParserException(e);
        }
    }
}

