/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.renderer;

import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.io.OWLRendererException;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxObjectRenderer;
import org.semanticweb.owlapi.manchestersyntax.renderer.ManchesterOWLSyntaxPrefixNameShortFormProvider;
import org.semanticweb.owlapi.manchestersyntax.renderer.RendererEvent;
import org.semanticweb.owlapi.manchestersyntax.renderer.RendererListener;
import org.semanticweb.owlapi.manchestersyntax.renderer.RenderingDirector;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAxiomFilter;
import org.semanticweb.owlapi.util.OWLObjectComparator;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;

public class ManchesterOWLSyntaxFrameRenderer
extends ManchesterOWLSyntaxObjectRenderer
implements OWLEntityVisitor {
    private final Set<OWLOntology> ontologies;
    private OntologyIRIShortFormProvider shortFormProvider = new OntologyIRIShortFormProvider();
    @Nonnull
    private final Set<AxiomType> filteredAxiomTypes = ManchesterOWLSyntaxFrameRenderer.filtered();
    private boolean renderExtensions = false;
    private boolean explicitXsdStrings;
    @Nonnull
    private final List<RendererListener> listeners = new ArrayList<RendererListener>();
    private OWLAxiomFilter axiomFilter = axiom -> true;
    private RenderingDirector renderingDirector = new DefaultRenderingDirector();
    @Nonnull
    private final OWLObjectComparator owlObjectComparator;
    private RendererEvent event;

    private static Set<AxiomType> filtered() {
        return Collections.singleton(AxiomType.SWRL_RULE);
    }

    public ManchesterOWLSyntaxFrameRenderer(@Nonnull OWLOntology ontology, @Nonnull Writer writer, @Nonnull ShortFormProvider entityShortFormProvider) {
        this(ontology, false, writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(@Nonnull OWLOntology ontology, boolean explicitXsdString, @Nonnull Writer writer, @Nonnull ShortFormProvider entityShortFormProvider) {
        this(CollectionFactory.createSet((Object)ontology), explicitXsdString, writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(@Nonnull Set<OWLOntology> ontologies, Writer writer, @Nonnull ShortFormProvider entityShortFormProvider) {
        this(ontologies, false, writer, entityShortFormProvider);
    }

    public ManchesterOWLSyntaxFrameRenderer(@Nonnull Set<OWLOntology> ontologies, boolean explicitXsdString, Writer writer, @Nonnull ShortFormProvider entityShortFormProvider) {
        super(writer, explicitXsdString, entityShortFormProvider);
        this.ontologies = new LinkedHashSet<OWLOntology>(ontologies);
        this.owlObjectComparator = new OWLObjectComparator(entityShortFormProvider);
    }

    public void setRenderingDirector(RenderingDirector renderingDirector) {
        this.renderingDirector = renderingDirector;
    }

    public void setOntologyIRIShortFormProvider(OntologyIRIShortFormProvider shortFormProvider) {
        this.shortFormProvider = shortFormProvider;
    }

    public void addRendererListener(RendererListener listener) {
        this.listeners.add(listener);
    }

    public void removeRendererListener(RendererListener listener) {
        this.listeners.remove(listener);
    }

    public void setAxiomFilter(OWLAxiomFilter axiomFilter) {
        this.axiomFilter = axiomFilter;
    }

    public void clearFilteredAxiomTypes() {
        this.filteredAxiomTypes.clear();
    }

    public void addFilteredAxiomType(AxiomType<?> axiomType) {
        this.filteredAxiomTypes.add(axiomType);
    }

    public void setRenderExtensions(boolean renderExtensions) {
        this.renderExtensions = renderExtensions;
    }

    public void writeOntology() throws OWLRendererException {
        SectionMap<Object, Object> map;
        if (this.ontologies.size() != 1) {
            throw new OWLRuntimeException("Can only render one ontology");
        }
        OWLOntology ontology = this.ontologies.iterator().next();
        assert (ontology != null);
        this.writePrefixMap();
        this.writeNewLine();
        this.writeOntologyHeader(ontology);
        for (OWLAnnotationProperty prop : this.sortedCollection(ontology.getAnnotationPropertiesInSignature())) {
            assert (prop != null);
            this.write(prop);
        }
        for (OWLDatatype datatype : this.sortedCollection(ontology.getDatatypesInSignature())) {
            assert (datatype != null);
            this.write(datatype);
        }
        for (OWLAnnotationProperty prop : this.sortedCollection(ontology.getObjectPropertiesInSignature())) {
            assert (prop != null);
            this.write((OWLObjectPropertyExpression)prop);
            OWLObjectPropertyExpression invProp = prop.getInverseProperty();
            if (ontology.getAxioms(invProp, Imports.EXCLUDED).isEmpty()) continue;
            this.write(invProp);
        }
        for (OWLAnnotationProperty prop : this.sortedCollection(ontology.getDataPropertiesInSignature())) {
            assert (prop != null);
            this.write((OWLDataProperty)prop);
        }
        for (OWLClass cls : this.sortedCollection(ontology.getClassesInSignature())) {
            assert (cls != null);
            this.write(cls);
        }
        for (OWLNamedIndividual ind : this.sortedCollection(ontology.getIndividualsInSignature())) {
            assert (ind != null);
            this.write((OWLIndividual)ind);
        }
        for (OWLNamedIndividual ind : this.sortedCollection(ontology.getReferencedAnonymousIndividuals(Imports.EXCLUDED))) {
            assert (ind != null);
            this.write((OWLIndividual)ind);
        }
        this.event = new RendererEvent(this, (OWLObject)ontology);
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.DISJOINT_CLASSES))) {
            if (ax.getClassExpressions().size() <= 2) continue;
            map = new SectionMap<Object, OWLAxiom>();
            map.put(ax.getClassExpressions(), ax);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES))) {
            if (ax.getClassExpressions().size() <= 2) continue;
            map = new SectionMap();
            map.put(ax.getClassExpressions(), ax);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_CLASSES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.DISJOINT_OBJECT_PROPERTIES))) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.EQUIVALENT_OBJECT_PROPERTIES))) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.DISJOINT_DATA_PROPERTIES))) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.DISJOINT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.EQUIVALENT_DATA_PROPERTIES))) {
            if (ax.getProperties().size() <= 2) continue;
            map = new SectionMap();
            map.put(ax.getProperties(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.DIFFERENT_INDIVIDUALS))) {
            if (ax.getIndividuals().size() <= 2 && (ax.getIndividuals().size() != 2 || ax.getAnnotations().isEmpty())) continue;
            map = new SectionMap();
            map.put(ax.getIndividuals(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, map, ",", false, ontology);
        }
        for (OWLDisjointClassesAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.SAME_INDIVIDUAL))) {
            if (ax.getIndividuals().size() <= 2 && (ax.getIndividuals().size() != 2 || ax.getAnnotations().isEmpty())) continue;
            map = new SectionMap();
            map.put(ax.getIndividuals(), (OWLAxiom)ax);
            this.writeSection(ManchesterOWLSyntax.SAME_INDIVIDUAL, map, ",", false, ontology);
        }
        for (SWRLRule rule : this.sortedCollection(ontology.getAxioms(AxiomType.SWRL_RULE))) {
            Set<SWRLRule> singleton = Collections.singleton(rule);
            this.writeSection(ManchesterOWLSyntax.RULE, singleton, ", ", false, new OWLOntology[0]);
        }
        this.flush();
    }

    public void writeOntologyHeader(@Nonnull OWLOntology ontology) {
        this.event = new RendererEvent(this, (OWLObject)ontology);
        this.fireFrameRenderingPrepared(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.write(":");
        this.writeSpace();
        if (!ontology.isAnonymous()) {
            int indent = this.getIndent();
            this.writeFullURI(((IRI)ontology.getOntologyID().getOntologyIRI().get()).toString());
            this.writeNewLine();
            this.pushTab(indent);
            if (ontology.getOntologyID().getVersionIRI().isPresent()) {
                this.writeFullURI(((IRI)ontology.getOntologyID().getVersionIRI().get()).toString());
            }
            this.popTab();
        }
        this.fireFrameRenderingStarted(ManchesterOWLSyntax.ONTOLOGY.toString());
        this.writeNewLine();
        ontology.getImportsDeclarations().stream().sorted().forEach(decl -> {
            this.fireSectionItemPrepared(ManchesterOWLSyntax.IMPORT.toString());
            this.write(ManchesterOWLSyntax.IMPORT.toString());
            this.write(":");
            this.writeSpace();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.IMPORT.toString());
            this.writeFullURI(decl.getIRI().toString());
            this.writeNewLine();
            this.fireSectionRenderingFinished(ManchesterOWLSyntax.IMPORT.toString());
        });
        this.writeNewLine();
        this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, this.sortedCollection(ontology.getAnnotations()), ",", true, new OWLOntology[0]);
        this.fireFrameRenderingFinished(ManchesterOWLSyntax.ONTOLOGY.toString());
    }

    public void writePrefixMap() {
        ShortFormProvider sfp = this.getShortFormProvider();
        if (!(sfp instanceof ManchesterOWLSyntaxPrefixNameShortFormProvider)) {
            return;
        }
        ManchesterOWLSyntaxPrefixNameShortFormProvider prov = (ManchesterOWLSyntaxPrefixNameShortFormProvider)sfp;
        Map<String, String> prefixMap = prov.getPrefixName2PrefixMap();
        for (Map.Entry<String, String> e : new TreeMap<String, String>(prefixMap).entrySet()) {
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": ");
            this.write(e.getKey());
            this.write(" ");
            this.writeFullURI(e.getValue());
            this.writeNewLine();
        }
        if (!prefixMap.containsKey(":")) {
            this.write(ManchesterOWLSyntax.PREFIX.toString());
            this.write(": : ");
            OWLOntology o = this.ontologies.iterator().next();
            if (o.getOntologyID().getOntologyIRI().isPresent()) {
                this.writeFullURI(((IRI)o.getOntologyID().getOntologyIRI().get()).toString());
            } else if (o.getOntologyID().getDefaultDocumentIRI().isPresent()) {
                this.writeFullURI(((IRI)o.getOntologyID().getDefaultDocumentIRI().get()).toString());
            } else {
                this.writeFullURI("urn:absoluteiri:defaultvalue#");
            }
            this.writeNewLine();
        }
        if (!prefixMap.isEmpty()) {
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeFullURI(String uri) {
        this.write("<");
        this.write(uri);
        this.write(">");
    }

    public boolean isFiltered(AxiomType<?> axiomType) {
        return this.filteredAxiomTypes.contains(axiomType);
    }

    public boolean isDisplayed(@Nullable OWLAxiom axiom) {
        if (axiom == null) {
            return false;
        }
        return this.axiomFilter.passes(axiom);
    }

    public Collection<OWLAxiom> writeFrame(@Nonnull OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.write(entity.asOWLClass());
        }
        if (entity.isOWLObjectProperty()) {
            return this.write((OWLObjectPropertyExpression)entity.asOWLObjectProperty());
        }
        if (entity.isOWLDataProperty()) {
            return this.write(entity.asOWLDataProperty());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.write((OWLIndividual)entity.asOWLNamedIndividual());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.write(entity.asOWLAnnotationProperty());
        }
        if (entity.isOWLDatatype()) {
            return this.write(entity.asOWLDatatype());
        }
        return CollectionFactory.emptySet();
    }

    @Nonnull
    public Collection<OWLAxiom> write(@Nonnull OWLClass cls) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.CLASS, (OWLObject)cls));
        if (!this.isFiltered(AxiomType.EQUIVALENT_CLASSES)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> equivalentClasses = new SectionMap<Object, OWLAxiom>();
                for (OWLEquivalentClassesAxiom ax : this.sortedCollection(ontology.getEquivalentClassesAxioms(cls))) {
                    if (ax.getClassExpressions().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                    for (OWLClassExpression equivCls : this.sortedCollection(ax.getClassExpressionsMinus(new OWLClassExpression[]{cls}))) {
                        equivalentClasses.put(equivCls, (OWLAxiom)ax);
                    }
                    axioms.add((OWLAxiom)ax);
                }
                equivalentClasses.remove(cls);
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, equivalentClasses, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUBCLASS_OF)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> superclasses = new SectionMap<Object, OWLAxiom>();
                for (OWLEquivalentClassesAxiom ax : this.sortedCollection(ontology.getSubClassAxiomsForSubClass(cls))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    superclasses.put(ax.getSuperClass(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.SUBCLASS_OF, superclasses, ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ont : this.ontologies) {
                    SectionMap subClasses = new SectionMap();
                    for (OWLEquivalentClassesAxiom ax : this.sortedCollection(ont.getSubClassAxiomsForSuperClass(cls))) {
                        if (!this.isDisplayed((OWLAxiom)ax)) continue;
                        subClasses.put(ax.getSubClass(), ax);
                        axioms.add((OWLAxiom)ax);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPERCLASS_OF, subClasses, ",", true, ont);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_UNION)) {
            for (OWLOntology ontology : this.ontologies) {
                for (Object ax : this.sortedCollection(ontology.getDisjointUnionAxioms(cls))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    Collection allDisjointClasses = this.sortedCollection(ax.getClassExpressions());
                    axioms.add((OWLAxiom)ax);
                    this.writeSection(ManchesterOWLSyntax.DISJOINT_UNION_OF, allDisjointClasses, ", ", false, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_CLASSES)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap disjointClasses = new SectionMap();
                for (OWLEquivalentClassesAxiom ax : this.sortedCollection(ontology.getDisjointClassesAxioms(cls))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    if (ax.getClassExpressions().size() == 2) {
                        OWLClassExpression disjointWith = (OWLClassExpression)this.sortedCollection(ax.getClassExpressionsMinus(new OWLClassExpression[]{cls})).iterator().next();
                        disjointClasses.put(disjointWith, ax);
                    }
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, disjointClasses, ", ", false, ontology);
                if (!this.renderExtensions) continue;
                for (OWLEquivalentClassesAxiom ax : this.sortedCollection(ontology.getDisjointClassesAxioms(cls))) {
                    if (!this.isDisplayed((OWLAxiom)ax) || ax.getClassExpressions().size() <= 2) continue;
                    Collection allDisjointClasses = this.sortedCollection(ax.getClassExpressions());
                    axioms.add((OWLAxiom)ax);
                    this.writeSection(ManchesterOWLSyntax.DISJOINT_CLASSES, allDisjointClasses, ", ", false, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.HAS_KEY)) {
            for (OWLOntology ontology : this.ontologies) {
                for (Object ax : this.sortedCollection(ontology.getHasKeyAxioms(cls))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    SectionMap<Object, OWLAxiom> map = new SectionMap<Object, OWLAxiom>();
                    map.put(ax.getPropertyExpressions(), (OWLAxiom)ax);
                    this.writeSection(ManchesterOWLSyntax.HAS_KEY, map, ", ", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> individuals = new SectionMap<Object, OWLAxiom>();
                for (OWLEquivalentClassesAxiom ax : this.sortedCollection(ontology.getClassAssertionAxioms((OWLClassExpression)cls))) {
                    if (!this.isDisplayed((OWLAxiom)ax) || !this.renderExtensions) continue;
                    individuals.put(ax.getIndividual(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.INDIVIDUALS, individuals, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.ontologies) {
                Collection rules = this.sortedCollection();
                block17: for (SWRLRule rule : this.sortedCollection(ontology.getAxioms(AxiomType.SWRL_RULE))) {
                    if (!this.isDisplayed((OWLAxiom)rule)) continue;
                    for (SWRLAtom atom : rule.getHead()) {
                        if (!atom.getPredicate().equals((Object)cls)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ", ", true, ontology);
                        continue block17;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.CLASS.toString());
        return axioms;
    }

    protected void writeEntitySectionEnd(String type) {
        this.fireFrameRenderingFinished(type);
        this.popTab();
        this.writeNewLine();
    }

    @Nonnull
    public Collection<OWLAxiom> write(@Nonnull OWLObjectPropertyExpression property) {
        SectionMap<Object, OWLAxiom> expressions;
        Collection props;
        Collection<OWLObjectPropertyExpression> properties;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.OBJECT_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.SUB_OBJECT_PROPERTY)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = new SectionMap<Object, OWLAxiom>();
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getObjectSubPropertyAxiomsForSubProperty(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    ((SectionMap)((Object)properties)).put(ax.getSuperProperty(), ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
            }
            if (this.renderExtensions) {
                for (OWLOntology ontology : this.ontologies) {
                    properties = new SectionMap();
                    for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getObjectSubPropertyAxiomsForSuperProperty(property))) {
                        if (!this.isDisplayed((OWLAxiom)ax)) continue;
                        ((SectionMap)((Object)properties)).put(ax.getSubProperty(), ax);
                        axioms.add((OWLAxiom)ax);
                    }
                    this.writeSection(ManchesterOWLSyntax.SUPER_PROPERTY_OF, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
                }
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getEquivalentObjectPropertiesAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax) || ax.getProperties().size() != 2) continue;
                    props = this.sortedCollection(ax.getPropertiesMinus((OWLPropertyExpression)property));
                    ((SectionMap)((Object)properties)).put(props.iterator().next(), ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getDisjointObjectPropertiesAxioms(property))) {
                    if (ax.getProperties().size() != 2 || !this.isDisplayed((OWLAxiom)ax)) continue;
                    props = this.sortedCollection(ax.getPropertiesMinus((OWLPropertyExpression)property));
                    ((SectionMap)((Object)properties)).put(props.iterator().next(), ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, (SectionMap<Object, OWLAxiom>)((Object)properties), ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_PROPERTY_CHAIN_OF)) {
            for (OWLOntology ontology : this.ontologies) {
                for (OWLSubPropertyChainOfAxiom ax : this.sortedCollection(ontology.getAxioms(AxiomType.SUB_PROPERTY_CHAIN_OF))) {
                    if (!ax.getSuperProperty().equals((Object)property) || !this.isDisplayed((OWLAxiom)ax)) continue;
                    SectionMap<Object, OWLAxiom> map = new SectionMap<Object, OWLAxiom>();
                    map.put(ax.getPropertyChain(), (OWLAxiom)ax);
                    this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_CHAIN, map, " o ", false, ontology);
                    axioms.add((OWLAxiom)ax);
                }
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            SectionMap<Object, OWLAxiom> characteristics = new SectionMap<Object, OWLAxiom>();
            if (!this.isFiltered(AxiomType.FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getFunctionalObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getInverseFunctionalObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.INVERSE_FUNCTIONAL.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.SYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getSymmetricObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.SYMMETRIC.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.TRANSITIVE_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getTransitiveObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.TRANSITIVE.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.REFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getReflexiveObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.REFLEXIVE.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.IRREFLEXIVE_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getIrreflexiveObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.IRREFLEXIVE.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            if (!this.isFiltered(AxiomType.ASYMMETRIC_OBJECT_PROPERTY)) {
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getAsymmetricObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.ASYMMETRIC.toString(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
            }
            this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.ontologies) {
                expressions = new SectionMap<Object, OWLAxiom>();
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getObjectPropertyDomainAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    expressions.put(ax.getDomain(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.OBJECT_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.ontologies) {
                expressions = new SectionMap();
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getObjectPropertyRangeAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    expressions.put(ax.getRange(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, expressions, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.INVERSE_OBJECT_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                properties = this.sortedCollection();
                for (OWLSubObjectPropertyOfAxiom ax : this.sortedCollection(ontology.getInverseObjectPropertyAxioms(property))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    if (ax.getFirstProperty().equals((Object)property)) {
                        properties.add(ax.getSecondProperty());
                    } else {
                        properties.add(ax.getFirstProperty());
                    }
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.INVERSE_OF, properties, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.ontologies) {
                Collection<SWRLRule> rules = this.sortedCollection();
                block25: for (SWRLRule rule : this.sortedCollection(ontology.getAxioms(AxiomType.SWRL_RULE))) {
                    if (!this.isDisplayed((OWLAxiom)rule)) continue;
                    for (SWRLAtom atom : rule.getHead()) {
                        if (!atom.getPredicate().equals((Object)property)) continue;
                        rules.add(rule);
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, ",", true, ontology);
                        continue block25;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.OBJECT_PROPERTY.toString());
        return axioms;
    }

    @Nonnull
    public Collection<OWLAxiom> write(@Nonnull OWLDataProperty property) {
        SectionMap<Object, OWLAxiom> props;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATA_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.FUNCTIONAL_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> characteristics = new SectionMap<Object, OWLAxiom>();
                for (OWLAxiom ax : this.sortedCollection(ontology.getFunctionalDataPropertyAxioms((OWLDataPropertyExpression)property))) {
                    if (!this.isDisplayed(ax)) continue;
                    characteristics.put(ManchesterOWLSyntax.FUNCTIONAL.toString(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.CHARACTERISTICS, characteristics, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_DOMAIN)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> domains = new SectionMap<Object, OWLAxiom>();
                for (OWLAxiom ax : this.sortedCollection(ontology.getDataPropertyDomainAxioms(property))) {
                    if (!this.isDisplayed(ax)) continue;
                    domains.put(ax.getDomain(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, domains, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DATA_PROPERTY_RANGE)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> ranges = new SectionMap<Object, OWLAxiom>();
                for (OWLAxiom ax : this.sortedCollection(ontology.getDataPropertyRangeAxioms(property))) {
                    if (!this.isDisplayed(ax)) continue;
                    ranges.put(ax.getRange(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, ranges, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SUB_DATA_PROPERTY)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> supers = new SectionMap<Object, OWLAxiom>();
                for (OWLAxiom ax : this.sortedCollection(ontology.getDataSubPropertyAxiomsForSubProperty(property))) {
                    if (!this.isDisplayed(ax)) continue;
                    supers.put(ax.getSuperProperty(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, supers, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.EQUIVALENT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                props = new SectionMap<Object, OWLAxiom>();
                for (OWLAxiom ax : this.sortedCollection(ontology.getEquivalentDataPropertiesAxioms(property))) {
                    if (!this.isDisplayed(ax) || ax.getProperties().size() != 2) continue;
                    props.put(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), ax);
                    axioms.add(ax);
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DISJOINT_DATA_PROPERTIES)) {
            for (OWLOntology ontology : this.ontologies) {
                props = new SectionMap();
                for (OWLAxiom ax : this.sortedCollection(ontology.getDisjointDataPropertiesAxioms(property))) {
                    if (ax.getProperties().size() != 2 || !this.isDisplayed(ax)) continue;
                    props.put(ax.getPropertiesMinus((OWLPropertyExpression)property).iterator().next(), ax);
                    axioms.add(ax);
                }
                props.remove(property);
                this.writeSection(ManchesterOWLSyntax.DISJOINT_WITH, props, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.SWRL_RULE)) {
            for (OWLOntology ontology : this.ontologies) {
                ArrayList rules = new ArrayList();
                block13: for (SWRLRule rule : this.sortedCollection(ontology.getAxioms(AxiomType.SWRL_RULE))) {
                    if (!this.isDisplayed((OWLAxiom)rule)) continue;
                    for (SWRLAtom atom : rule.getHead()) {
                        if (!atom.getPredicate().equals((Object)property)) continue;
                        this.writeSection(ManchesterOWLSyntax.RULE, rules, "", true, ontology);
                        continue block13;
                    }
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATA_PROPERTY.toString());
        return axioms;
    }

    @Nonnull
    public Collection<OWLAxiom> write(@Nonnull OWLIndividual individual) {
        Collection inds;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.INDIVIDUAL, (OWLObject)individual));
        if (!this.isFiltered(AxiomType.CLASS_ASSERTION)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> expressions = new SectionMap<Object, OWLAxiom>();
                for (OWLClassAssertionAxiom ax : this.sortedCollection(ontology.getClassAssertionAxioms(individual))) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    expressions.put(ax.getClassExpression(), (OWLAxiom)ax);
                    axioms.add((OWLAxiom)ax);
                }
                this.writeSection(ManchesterOWLSyntax.TYPES, expressions, ",", true, ontology);
            }
        }
        for (OWLOntology ontology : this.ontologies) {
            Collection assertions = this.sortedCollection();
            assertions.addAll(ontology.getObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeObjectPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getDataPropertyAssertionAxioms(individual));
            assertions.addAll(ontology.getNegativeDataPropertyAssertionAxioms(individual));
            if (assertions.isEmpty()) continue;
            this.fireSectionRenderingPrepared(ManchesterOWLSyntax.FACTS.toString());
            this.writeSection(ManchesterOWLSyntax.FACTS);
            this.writeSpace();
            this.writeOntologiesList(ontology);
            this.incrementTab(1);
            this.writeNewLine();
            this.fireSectionRenderingStarted(ManchesterOWLSyntax.FACTS.toString());
            Iterator it = assertions.iterator();
            while (it.hasNext()) {
                OWLClassAssertionAxiom ax;
                ax = (OWLPropertyAssertionAxiom)it.next();
                this.fireSectionItemPrepared(ManchesterOWLSyntax.FACTS.toString());
                Set annos = ax.getAnnotations();
                if (!annos.isEmpty()) {
                    this.writeAnnotations(annos);
                    this.pushTab(this.getIndent() + 1);
                }
                if (ax instanceof OWLNegativeDataPropertyAssertionAxiom || ax instanceof OWLNegativeObjectPropertyAssertionAxiom) {
                    this.write(ManchesterOWLSyntax.NOT);
                    this.writeSpace();
                }
                ax.getProperty().accept((OWLObjectVisitor)this);
                this.writeSpace();
                this.writeSpace();
                ax.getObject().accept((OWLObjectVisitor)this);
                if (!annos.isEmpty()) {
                    this.popTab();
                }
                this.fireSectionItemFinished(ManchesterOWLSyntax.FACTS.toString());
                if (!it.hasNext()) continue;
                this.write(",");
                this.writeNewLine();
            }
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
        if (!this.isFiltered(AxiomType.SAME_INDIVIDUAL)) {
            for (OWLOntology ontology : this.ontologies) {
                inds = this.sortedCollection();
                for (OWLClassAssertionAxiom ax : ontology.getSameIndividualAxioms(individual)) {
                    if (!this.isDisplayed((OWLAxiom)ax) || ax.getIndividuals().size() != 2 || !ax.getAnnotations().isEmpty()) continue;
                    inds.addAll(ax.getIndividuals());
                    axioms.add((OWLAxiom)ax);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.SAME_AS, inds, ",", true, ontology);
            }
        }
        if (!this.isFiltered(AxiomType.DIFFERENT_INDIVIDUALS)) {
            for (OWLOntology ontology : this.ontologies) {
                inds = this.sortedCollection();
                Collection<OWLDifferentIndividualsAxiom> nary = this.sortedCollection();
                for (OWLDifferentIndividualsAxiom ax : ontology.getDifferentIndividualAxioms(individual)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    if (ax.getIndividuals().size() == 2 && ax.getAnnotations().isEmpty()) {
                        inds.addAll(ax.getIndividuals());
                        axioms.add((OWLAxiom)ax);
                        continue;
                    }
                    nary.add(ax);
                }
                inds.remove(individual);
                this.writeSection(ManchesterOWLSyntax.DIFFERENT_FROM, inds, ",", true, ontology);
                if (!this.renderExtensions) continue;
                for (OWLDifferentIndividualsAxiom ax : nary) {
                    this.writeSection(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS, ax.getIndividuals(), ", ", false, ontology);
                }
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.INDIVIDUAL.toString());
        return axioms;
    }

    @Nonnull
    public Collection<OWLAxiom> write(@Nonnull OWLDatatype datatype) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.DATATYPE, (OWLObject)datatype));
        if (!this.isFiltered(AxiomType.DATATYPE_DEFINITION)) {
            for (OWLOntology ontology : this.ontologies) {
                Collection<OWLDataRange> dataRanges = this.sortedCollection();
                for (OWLDatatypeDefinitionAxiom ax : ontology.getDatatypeDefinitions(datatype)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    axioms.add((OWLAxiom)ax);
                    dataRanges.add(ax.getDataRange());
                }
                this.writeSection(ManchesterOWLSyntax.EQUIVALENT_TO, dataRanges, ",", true, ontology);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.DATATYPE.toString());
        return axioms;
    }

    @Nonnull
    public Collection<OWLAxiom> write(@Nonnull SWRLRule rule) {
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>(1);
        for (OWLOntology ontology : this.ontologies) {
            if (!ontology.containsAxiom((OWLAxiom)rule)) continue;
            this.writeSection(ManchesterOWLSyntax.RULE, CollectionFactory.createSet((Object)rule), "", true, ontology);
            axioms.add((OWLAxiom)rule);
        }
        return axioms;
    }

    @Nonnull
    public Collection<OWLAxiom> write(@Nonnull OWLAnnotationProperty property) {
        Collection<IRI> iris;
        ArrayList<OWLAxiom> axioms = new ArrayList<OWLAxiom>();
        axioms.addAll(this.writeEntityStart(ManchesterOWLSyntax.ANNOTATION_PROPERTY, (OWLObject)property));
        if (!this.isFiltered(AxiomType.SUB_ANNOTATION_PROPERTY_OF)) {
            for (OWLOntology ont : this.ontologies) {
                Collection<OWLAnnotationProperty> props = this.sortedCollection();
                for (OWLSubAnnotationPropertyOfAxiom ax : ont.getSubAnnotationPropertyOfAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    props.add(ax.getSuperProperty());
                }
                this.writeSection(ManchesterOWLSyntax.SUB_PROPERTY_OF, props, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_DOMAIN)) {
            for (OWLOntology ont : this.ontologies) {
                iris = this.sortedCollection();
                for (OWLSubAnnotationPropertyOfAxiom ax : ont.getAnnotationPropertyDomainAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    iris.add(ax.getDomain());
                }
                this.writeSection(ManchesterOWLSyntax.DOMAIN, iris, ",", true, ont);
            }
        }
        if (!this.isFiltered(AxiomType.ANNOTATION_PROPERTY_RANGE)) {
            for (OWLOntology ont : this.ontologies) {
                iris = this.sortedCollection();
                for (OWLSubAnnotationPropertyOfAxiom ax : ont.getAnnotationPropertyRangeAxioms(property)) {
                    if (!this.isDisplayed((OWLAxiom)ax)) continue;
                    iris.add(ax.getRange());
                }
                this.writeSection(ManchesterOWLSyntax.RANGE, iris, ",", true, ont);
            }
        }
        this.writeEntitySectionEnd(ManchesterOWLSyntax.ANNOTATION_PROPERTY.toString());
        return axioms;
    }

    private Collection<OWLAnnotationAssertionAxiom> writeEntityStart(@Nonnull ManchesterOWLSyntax keyword, @Nonnull OWLObject entity) {
        this.event = new RendererEvent(this, entity);
        String kw = keyword.toString();
        this.fireFrameRenderingPrepared(kw);
        this.writeSection(keyword);
        entity.accept((OWLObjectVisitor)this);
        this.fireFrameRenderingStarted(kw);
        this.writeNewLine();
        this.incrementTab(4);
        this.writeNewLine();
        if (entity instanceof OWLEntity) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLEntity)entity).getIRI());
        }
        if (entity instanceof OWLAnonymousIndividual) {
            return this.writeAnnotations((OWLAnnotationSubject)((OWLAnonymousIndividual)entity));
        }
        return CollectionFactory.emptySet();
    }

    @Nonnull
    public Collection<OWLAnnotationAssertionAxiom> writeAnnotations(@Nonnull OWLAnnotationSubject subject) {
        Collection<OWLAnnotationAssertionAxiom> axioms = this.sortedCollection();
        if (!this.isFiltered(AxiomType.ANNOTATION_ASSERTION)) {
            for (OWLOntology ontology : this.ontologies) {
                SectionMap<Object, OWLAxiom> sectionMap = new SectionMap<Object, OWLAxiom>();
                ontology.getAnnotationAssertionAxioms(subject).stream().sorted().filter(this::isDisplayed).forEach(ax -> {
                    axioms.add((OWLAnnotationAssertionAxiom)ax);
                    sectionMap.put(ax.getAnnotation(), (OWLAxiom)ax);
                });
                this.writeSection(ManchesterOWLSyntax.ANNOTATIONS, sectionMap, ",", true, ontology);
            }
        }
        return axioms;
    }

    public void writeSection(@Nonnull ManchesterOWLSyntax keyword) {
        this.write("", keyword, "");
        this.write(":");
        this.writeSpace();
    }

    private void writeSection(@Nonnull ManchesterOWLSyntax keyword, @Nonnull SectionMap<Object, OWLAxiom> content, String delimeter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (content.isNotEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<Object> it = content.getSectionObjects().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                Collection<Collection<OWLAnnotation>> annotationSets = content.getAnnotationsForSectionObject(obj);
                Iterator<Collection<OWLAnnotation>> annosSetIt = annotationSets.iterator();
                while (annosSetIt.hasNext()) {
                    Collection<OWLAnnotation> annos = annosSetIt.next();
                    this.fireSectionItemPrepared(sec);
                    if (!annos.isEmpty()) {
                        this.incrementTab(4);
                        this.writeNewLine();
                        this.write(ManchesterOWLSyntax.ANNOTATIONS.toString());
                        this.write(": ");
                        this.pushTab(this.getIndent() + 1);
                        Iterator<OWLAnnotation> annoIt = annos.iterator();
                        while (annoIt.hasNext()) {
                            annoIt.next().accept((OWLObjectVisitor)this);
                            if (!annoIt.hasNext()) continue;
                            this.write(", ");
                            this.writeNewLine();
                        }
                        this.popTab();
                        this.popTab();
                        this.writeNewLine();
                    }
                    if (obj instanceof OWLObject) {
                        ((OWLObject)obj).accept((OWLObjectVisitor)this);
                    } else if (obj instanceof Collection) {
                        Iterator listIt = ((Collection)obj).iterator();
                        while (listIt.hasNext()) {
                            Object o = listIt.next();
                            if (o instanceof OWLObject) {
                                ((OWLObject)o).accept((OWLObjectVisitor)this);
                            } else {
                                this.write(o.toString());
                            }
                            if (!listIt.hasNext()) continue;
                            this.write(delimeter);
                            if (!newline) continue;
                            this.writeNewLine();
                        }
                    } else {
                        this.write(obj.toString());
                    }
                    if (!annosSetIt.hasNext()) continue;
                    this.write(",");
                    this.writeNewLine();
                }
                if (it.hasNext()) {
                    this.write(delimeter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeSection(@Nonnull ManchesterOWLSyntax keyword, @Nonnull Collection<?> content, String delimiter, boolean newline, OWLOntology ... ontologiesList) {
        String sec = keyword.toString();
        if (!content.isEmpty() || this.renderingDirector.renderEmptyFrameSection(keyword, ontologiesList)) {
            this.fireSectionRenderingPrepared(sec);
            this.writeSection(keyword);
            this.writeOntologiesList(ontologiesList);
            this.incrementTab(4);
            this.writeNewLine();
            this.fireSectionRenderingStarted(sec);
            Iterator<?> it = content.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                this.fireSectionItemPrepared(sec);
                if (obj instanceof OWLObject) {
                    ((OWLObject)obj).accept((OWLObjectVisitor)this);
                } else {
                    this.write(obj.toString());
                }
                if (it.hasNext()) {
                    this.write(delimiter);
                    this.fireSectionItemFinished(sec);
                    if (!newline) continue;
                    this.writeNewLine();
                    continue;
                }
                this.fireSectionItemFinished(sec);
            }
            this.fireSectionRenderingFinished(sec);
            this.popTab();
            this.writeNewLine();
            this.writeNewLine();
        }
    }

    public void writeComment(String comment, boolean placeOnNewline) {
        this.writeComment("#", comment, placeOnNewline);
    }

    public void writeComment(String commentDelim, String comment, boolean placeOnNewline) {
        if (placeOnNewline) {
            this.writeNewLine();
        }
        this.write(commentDelim);
        this.write(comment);
        this.writeNewLine();
    }

    private void writeOntologiesList(OWLOntology ... ontologiesList) {
        if (!this.renderExtensions) {
            return;
        }
        if (ontologiesList.length == 0) {
            return;
        }
        this.write("[in ");
        int count = 0;
        for (OWLOntology ont : ontologiesList) {
            this.write(this.shortFormProvider.getShortForm(ont));
            if (++count >= ontologiesList.length) continue;
            this.write(", ");
        }
        this.write("]");
    }

    private void fireFrameRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingPrepared(section, this.event);
        }
    }

    private void fireFrameRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingStarted(section, this.event);
        }
    }

    private void fireFrameRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.frameRenderingFinished(section, this.event);
        }
    }

    private void fireSectionRenderingPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingPrepared(section, this.event);
        }
    }

    private void fireSectionRenderingStarted(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingStarted(section, this.event);
        }
    }

    private void fireSectionRenderingFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionRenderingFinished(section, this.event);
        }
    }

    private void fireSectionItemPrepared(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemPrepared(section, this.event);
        }
    }

    private void fireSectionItemFinished(String section) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RendererListener listener : this.listeners) {
            listener.sectionItemFinished(section, this.event);
        }
    }

    @Nonnull
    <E extends OWLObject> Collection<E> sortedCollection() {
        return new TreeSet(this.owlObjectComparator);
    }

    @Nonnull
    <E> Collection<E> sortedSet() {
        return new TreeSet();
    }

    @Nonnull
    <E extends OWLObject> Collection<E> sortedCollection(@Nonnull Collection<E> fromCollection) {
        Collection<E> set = this.sortedCollection();
        set.addAll(fromCollection);
        return set;
    }

    private static class DefaultRenderingDirector
    implements RenderingDirector {
        DefaultRenderingDirector() {
        }

        @Override
        public boolean renderEmptyFrameSection(ManchesterOWLSyntax frameSectionKeyword, OWLOntology ... ontologies) {
            return false;
        }
    }

    class SectionMap<O, V extends OWLAxiom> {
        @Nonnull
        private final Map<O, Collection<V>> object2Axioms = new LinkedHashMap<O, Collection<V>>();

        SectionMap() {
        }

        public boolean isNotEmpty() {
            return !this.object2Axioms.isEmpty();
        }

        public void put(O o, V forAxiom) {
            Collection<Object> axioms = this.object2Axioms.get(o);
            if (axioms == null) {
                axioms = ManchesterOWLSyntaxFrameRenderer.this.sortedCollection();
                this.object2Axioms.put(o, axioms);
            }
            axioms.add(forAxiom);
        }

        public void remove(O o) {
            this.object2Axioms.remove(o);
        }

        @Nonnull
        public Collection<O> getSectionObjects() {
            return this.object2Axioms.keySet();
        }

        @Nonnull
        public Collection<Collection<OWLAnnotation>> getAnnotationsForSectionObject(Object sectionObject) {
            Collection<V> axioms = this.object2Axioms.get(sectionObject);
            if (axioms == null) {
                return ManchesterOWLSyntaxFrameRenderer.this.sortedSet();
            }
            ArrayList<Collection<OWLAnnotation>> annos = new ArrayList<Collection<OWLAnnotation>>();
            for (OWLAxiom ax : axioms) {
                annos.add(ManchesterOWLSyntaxFrameRenderer.this.sortedCollection(ax.getAnnotations()));
            }
            return annos;
        }
    }
}

