/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf;

import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;

public class AbsoluteIRIHelper {
    public static IRI verifyAbsolute(IRI iri, @Nullable OWLDocumentFormat f, OWLOntology o) {
        if (iri.isAbsolute()) {
            return iri;
        }
        if (f == null || f.supportsRelativeIRIs()) {
            return iri;
        }
        String defaultPrefix = null;
        if (f.isPrefixOWLOntologyFormat()) {
            defaultPrefix = f.asPrefixOWLOntologyFormat().getDefaultPrefix();
        }
        if (defaultPrefix == null && o.getOntologyID().getOntologyIRI().isPresent()) {
            defaultPrefix = ((IRI)o.getOntologyID().getOntologyIRI().get()).toString();
        }
        if (defaultPrefix == null && o.getOntologyID().getDefaultDocumentIRI().isPresent()) {
            defaultPrefix = ((IRI)o.getOntologyID().getDefaultDocumentIRI().get()).toString();
        }
        if (defaultPrefix == null) {
            return IRI.create((String)("urn:absoluteiri:defaultvalue#" + String.valueOf(iri)));
        }
        return IRI.create((String)(defaultPrefix + String.valueOf(iri)));
    }
}

