/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.turtle.parser;

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.rdf.turtle.parser.TripleHandler;

class ConsoleTripleHandler
implements TripleHandler {
    private static final String ARC = " --> ";

    ConsoleTripleHandler() {
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, IRI object) {
        System.out.println(String.valueOf(subject) + ARC + String.valueOf(predicate) + ARC + String.valueOf(object));
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, String object) {
        System.out.println(String.valueOf(subject) + ARC + String.valueOf(predicate) + ARC + object);
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, String object, String lang) {
        System.out.println(String.valueOf(subject) + ARC + String.valueOf(predicate) + ARC + object + "@" + lang);
    }

    @Override
    public void handleTriple(IRI subject, IRI predicate, String object, IRI datatype) {
        System.out.println(String.valueOf(subject) + ARC + String.valueOf(predicate) + ARC + object + "^^" + String.valueOf(datatype));
    }

    @Override
    public void handlePrefixDirective(String prefixName, String prefix) {
        System.out.println("PREFIX: " + prefixName + " -> " + prefix);
    }

    @Override
    public void handleBaseDirective(IRI base) {
        System.out.println("BASE: " + String.valueOf(base));
    }

    @Override
    public void handleComment(String comment) {
        System.out.println("COMMENT: " + comment);
    }

    @Override
    public void handleEnd() {
        System.out.println("END");
    }
}

