/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.alert;

import dev.ikm.tinkar.common.alert.AlertCategory;
import dev.ikm.tinkar.common.alert.AlertResolver;
import dev.ikm.tinkar.common.alert.AlertType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;

public class AlertObject
implements Comparable<AlertObject> {
    final UUID alertId = UUID.randomUUID();
    final int[] affectedComponents;
    final String alertTitle;
    final String alertDescription;
    final AlertType alertType;
    final Throwable throwable;
    final AlertCategory alertCategory;
    final Callable<Boolean> resolutionTester;
    private final List<AlertResolver> alertResolvers = new ArrayList<AlertResolver>();

    public AlertObject(String alertTitle, String alertDescription, AlertType alertType, AlertCategory alertCategory, int ... affectedComponents) {
        this(alertTitle, alertDescription, alertType, null, alertCategory, null, affectedComponents);
    }

    public AlertObject(String alertTitle, String alertDescription, AlertType alertType, Throwable throwable, AlertCategory alertCategory, Callable<Boolean> resolutionTester, int ... affectedComponents) {
        this.affectedComponents = affectedComponents;
        this.alertTitle = alertTitle;
        this.alertDescription = alertDescription;
        this.alertType = alertType;
        this.throwable = throwable;
        this.alertCategory = alertCategory;
        this.resolutionTester = resolutionTester;
    }

    public static AlertObject makeWarning(String alertTitle, String alertDescription) {
        return new AlertObject(alertTitle, alertDescription, AlertType.WARNING, AlertCategory.UNSPECIFIED, new int[0]);
    }

    public static AlertObject makeError(String alertTitle, String alertDescription, Throwable throwable) {
        return new AlertObject(alertTitle, alertDescription, AlertType.ERROR, throwable, AlertCategory.UNSPECIFIED, null, new int[0]);
    }

    public static AlertObject makeError(Throwable throwable) {
        return new AlertObject(throwable.getClass().getSimpleName(), throwable.getLocalizedMessage(), AlertType.ERROR, throwable, AlertCategory.UNSPECIFIED, null, new int[0]);
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public int[] getAffectedComponents() {
        return this.affectedComponents;
    }

    public String getAlertTitle() {
        return this.alertTitle;
    }

    public String getAlertDescription() {
        return this.alertDescription;
    }

    public AlertCategory getAlertCategory() {
        return this.alertCategory;
    }

    public Optional<Callable<Boolean>> getResolutionTester() {
        return Optional.ofNullable(this.resolutionTester);
    }

    public List<AlertResolver> getResolvers() {
        return this.alertResolvers;
    }

    public Boolean failCommit() {
        return this.getAlertType().preventsCheckerPass();
    }

    public AlertType getAlertType() {
        return this.alertType;
    }

    @Override
    public int compareTo(AlertObject o) {
        return this.alertId.compareTo(o.alertId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", alertTitle=" + this.alertTitle + ", alertType=" + String.valueOf((Object)this.alertType) + ", alertDescription=" + this.alertDescription + ", resolvers=" + String.valueOf(this.alertResolvers) + ", resolutionTester=" + String.valueOf(this.resolutionTester) + " " + Arrays.toString(this.affectedComponents);
    }
}

