/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.binary;

import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import io.activej.bytebuf.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.UUID;

public class DecoderInput {
    int encodingFormatVersion;
    ByteBuf buf;

    public DecoderInput(ByteBuf buf) {
        this.buf = buf;
        this.encodingFormatVersion = buf.readInt();
    }

    public DecoderInput(byte[] bytes) {
        this.buf = ByteBuf.wrapForReading((byte[])bytes);
        this.encodingFormatVersion = this.buf.readInt();
    }

    public int encodingFormatVersion() {
        return this.encodingFormatVersion;
    }

    public UUID[] readUuidArray() {
        return UuidUtil.toArray(this.readLongArray());
    }

    public long[] readLongArray() {
        int arraySize = this.readVarInt();
        long[] longArray = new long[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            longArray[i] = this.readLong();
        }
        return longArray;
    }

    public UUID readUuid() {
        return new UUID(this.readLong(), this.readLong());
    }

    public String readString() {
        int byteCount = this.buf.readInt();
        String decoded = new String(this.buf.array(), this.buf.head(), byteCount, StandardCharsets.UTF_8);
        this.buf.moveHead(byteCount);
        return decoded;
    }

    public byte readByte() {
        return this.buf.readByte();
    }

    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    public char readChar() {
        return this.buf.readChar();
    }

    public double readDouble() {
        return this.buf.readDouble();
    }

    public float readFloat() {
        return this.buf.readFloat();
    }

    public int readInt() {
        return this.buf.readInt();
    }

    public int readVarInt() {
        return this.buf.readVarInt();
    }

    public long readLong() {
        return this.buf.readLong();
    }

    public short readShort() {
        return this.buf.readShort();
    }

    public long readVarLong() {
        return this.buf.readVarLong();
    }

    public int readNid() {
        return this.buf.readInt();
    }

    public int[] readNidArray() {
        int arraySize = this.buf.readVarInt();
        int[] nidArray = new int[arraySize];
        for (int i = 0; i < nidArray.length; ++i) {
            nidArray[i] = this.readInt();
        }
        return nidArray;
    }

    public Instant readInstant() {
        return Instant.ofEpochSecond(this.readLong(), this.readInt());
    }
}

