/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.binary;

import dev.ikm.tinkar.common.binary.Decoder;
import dev.ikm.tinkar.common.binary.DecoderInput;
import dev.ikm.tinkar.common.binary.Encoder;
import dev.ikm.tinkar.common.binary.EncoderOutput;
import dev.ikm.tinkar.common.binary.EncodingExceptionUnchecked;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public interface Encodable {
    public static final int FIRST_VERSION = 10;
    public static final int LATEST_VERSION = 11;

    public static int checkVersion(DecoderInput in) {
        if (in.encodingFormatVersion < 10 || in.encodingFormatVersion > 11) {
            EncodingExceptionUnchecked.makeWrongVersionException(10, 11, in);
        }
        return in.encodingFormatVersion;
    }

    public static <T> T decode(byte[] bytes) {
        try {
            DecoderInput input = new DecoderInput(bytes);
            String objectClassString = input.readString();
            return (T)Encodable.decode(Class.forName(objectClassString), Decoder.class, new Object[]{input});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new EncodingExceptionUnchecked(ex);
        }
    }

    public static <T> T decode(Class<T> objectClass, Class<? extends Annotation> annotationClass, Object[] parameters) throws IllegalAccessException, InvocationTargetException {
        ArrayList<Method> unmarshalMethodList = Encodable.getDecodingMethods(objectClass, annotationClass);
        if (unmarshalMethodList.isEmpty()) {
            throw new EncodingExceptionUnchecked("No " + annotationClass.getSimpleName() + " method for class: " + String.valueOf(objectClass));
        }
        if (unmarshalMethodList.size() == 1) {
            Method unmarshalMethod = unmarshalMethodList.get(0);
            return (T)unmarshalMethod.invoke(null, parameters);
        }
        throw new EncodingExceptionUnchecked("More than one unmarshal method for class: " + String.valueOf(objectClass) + " methods: " + String.valueOf(unmarshalMethodList));
    }

    public static <T> ArrayList<Method> getDecodingMethods(Class<T> objectClass, Class<? extends Annotation> annotationClass) {
        ArrayList<Method> unmarshalMethodList = new ArrayList<Method>();
        for (Method method : objectClass.getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                if (!annotation.annotationType().equals(annotationClass)) continue;
                if (Modifier.isStatic(method.getModifiers())) {
                    unmarshalMethodList.add(method);
                    continue;
                }
                throw new EncodingExceptionUnchecked(annotationClass.getSimpleName() + " method for class: " + String.valueOf(objectClass) + " is not static: " + String.valueOf(method));
            }
        }
        return unmarshalMethodList;
    }

    public static <T> T decode(Class<T> objectClass, byte[] bytes) {
        try {
            DecoderInput input = new DecoderInput(bytes);
            return Encodable.decode(objectClass, Decoder.class, new Object[]{input});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new EncodingExceptionUnchecked(ex);
        }
    }

    public static <T> T decode(Class<T> objectClass, DecoderInput input) {
        try {
            return Encodable.decode(objectClass, Decoder.class, new Object[]{input});
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new EncodingExceptionUnchecked(ex);
        }
    }

    default public void addToEncodable(EncoderOutput out) {
        out.writeString(this.getClass().getName());
        this.encode(out);
    }

    @Encoder
    public void encode(EncoderOutput var1);

    default public byte[] toBytes() {
        EncoderOutput out = this.encode();
        return out.buf.asArray();
    }

    default public EncoderOutput encode() {
        EncoderOutput encoderOutput = new EncoderOutput();
        encoderOutput.writeInt(10);
        encoderOutput.writeString(this.getClass().getName());
        this.encode(encoderOutput);
        return encoderOutput;
    }
}

