/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.binary;

import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.bytebuf.ByteBufStrings;
import java.time.Instant;
import java.util.UUID;

public class EncoderOutput {
    private static int defaultCapacity = 10240;
    protected ByteBuf buf;

    public EncoderOutput(ByteBuf buf) {
        this.buf = buf;
    }

    public EncoderOutput(int initialCapacity) {
        this.buf = ByteBufPool.allocate((int)initialCapacity);
    }

    public EncoderOutput() {
        this.buf = ByteBufPool.allocate((int)defaultCapacity);
    }

    private void growIfNeeded(int bytesNeeded) {
        if (this.buf.writeRemaining() < bytesNeeded || this.buf.getClass() != ByteBuf.class) {
            int usedBytes = this.buf.readRemaining();
            int newCapacity = usedBytes + (usedBytes >> 1);
            ByteBuf newBuf = ByteBufPool.allocate((int)newCapacity);
            newBuf.put(this.buf);
            this.buf.recycle();
            this.buf = newBuf;
        }
    }

    public void writeByteArray(byte[] byteArray) {
        this.growIfNeeded(byteArray.length + 4);
        this.buf.writeVarInt(byteArray.length);
        this.buf.write(byteArray);
    }

    public void writeUuidArray(UUID[] uuidArray) {
        this.writeLongArray(UuidUtil.asArray(uuidArray));
    }

    public void writeLongArray(long[] longArray) {
        this.growIfNeeded(longArray.length * 8 + 4);
        this.buf.writeVarInt(longArray.length);
        for (long value : longArray) {
            this.buf.writeLong(value);
        }
    }

    public void writeUuid(UUID uuid) {
        this.growIfNeeded(16);
        this.buf.writeLong(uuid.getMostSignificantBits());
        this.buf.writeLong(uuid.getLeastSignificantBits());
    }

    public void writeString(String string) {
        this.growIfNeeded(string.length() * 3);
        int tailAtStart = this.buf.tail();
        this.buf.writeInt(0);
        int byteCount = ByteBufStrings.encodeUtf8((byte[])this.buf.array(), (int)this.buf.tail(), (String)string);
        this.buf.tail(tailAtStart);
        this.buf.writeInt(byteCount);
        this.buf.moveTail(byteCount);
    }

    public void writeBoolean(boolean v) {
        this.growIfNeeded(1);
        this.buf.writeBoolean(v);
    }

    public void writeByte(byte v) {
        this.growIfNeeded(1);
        this.buf.writeByte(v);
    }

    public void writeChar(char v) {
        this.growIfNeeded(3);
        this.buf.writeChar(v);
    }

    public void writeDouble(double v) {
        this.growIfNeeded(8);
        this.buf.writeDouble(v);
    }

    public void writeFloat(float v) {
        this.growIfNeeded(4);
        this.buf.writeFloat(v);
    }

    public void writeInt(int v) {
        this.growIfNeeded(4);
        this.buf.writeInt(v);
    }

    public void writeLong(long v) {
        this.growIfNeeded(8);
        this.buf.writeLong(v);
    }

    public void writeShort(short v) {
        this.growIfNeeded(2);
        this.buf.writeShort(v);
    }

    public void writeVarInt(int v) {
        this.growIfNeeded(5);
        this.buf.writeVarInt(v);
    }

    public void writeVarLong(long v) {
        this.growIfNeeded(10);
        this.buf.writeVarLong(v);
    }

    public void writeNid(int nid) {
        this.growIfNeeded(4);
        this.buf.writeInt(nid);
    }

    public void writeNidArray(int[] nids) {
        this.growIfNeeded(4 + nids.length * 4);
        this.buf.writeVarInt(nids.length);
        for (int i = 0; i < nids.length; ++i) {
            this.buf.writeInt(nids[i]);
        }
    }

    public void writeInstant(Instant instant) {
        this.growIfNeeded(12);
        this.buf.writeLong(instant.getEpochSecond());
        this.buf.writeInt(instant.getNano());
    }

    public void recycle() {
        this.buf.recycle();
    }
}

