/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id;

import dev.ikm.tinkar.common.id.IntIdSet;
import dev.ikm.tinkar.common.id.IntIdSetFactory;
import dev.ikm.tinkar.common.id.impl.IntId0Set;
import dev.ikm.tinkar.common.id.impl.IntId1Set;
import dev.ikm.tinkar.common.id.impl.IntId2Set;
import dev.ikm.tinkar.common.id.impl.IntIdSetArray;
import dev.ikm.tinkar.common.id.impl.IntIdSetRoaring;
import java.util.Arrays;

enum IntIdSetFactoryEnum implements IntIdSetFactory
{
    INSTANCE;


    @Override
    public IntIdSet of(IntIdSet idSet, int ... elements) {
        int[] combined = new int[idSet.size() + elements.length];
        int[] listArray = idSet.toArray();
        int elementIndex = 0;
        for (int i = 0; i < combined.length; ++i) {
            combined[i] = i < listArray.length ? listArray[i] : elements[elementIndex++];
        }
        combined = Arrays.stream(combined).distinct().toArray();
        return this.of(combined);
    }

    @Override
    public IntIdSet empty() {
        return IntId0Set.INSTANCE;
    }

    @Override
    public IntIdSet of() {
        return this.empty();
    }

    @Override
    public IntIdSet of(int one) {
        return new IntId1Set(one);
    }

    @Override
    public IntIdSet of(int one, int two) {
        if (one != two) {
            return new IntId2Set(one, two);
        }
        return this.of(one);
    }

    @Override
    public IntIdSet of(int ... elements) {
        if (elements == null || elements.length == 0) {
            return this.empty();
        }
        if (elements.length == 1) {
            return this.of(elements[0]);
        }
        if ((elements = Arrays.stream(elements).distinct().toArray()).length == 2) {
            if (elements[0] == elements[1]) {
                return this.of(elements[0]);
            }
            return this.of(elements[0], elements[1]);
        }
        if (elements.length < 1024) {
            return IntIdSetArray.newIntIdSet(elements);
        }
        return IntIdSetRoaring.newIntIdSet(elements);
    }

    @Override
    public IntIdSet ofAlreadySorted(int ... elements) {
        if (elements == null || elements.length == 0) {
            return this.empty();
        }
        if (elements.length == 1) {
            return this.of(elements[0]);
        }
        if (elements.length == 2) {
            if (elements[0] == elements[1]) {
                return this.of(elements[0]);
            }
            return this.of(elements[0], elements[1]);
        }
        if (elements.length < 1024) {
            return IntIdSetArray.newIntIdSetAlreadySorted(elements);
        }
        return IntIdSetRoaring.newIntIdSetAlreadySorted(elements);
    }
}

