/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id;

import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import java.util.Arrays;
import java.util.UUID;
import java.util.function.LongConsumer;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.ImmutableList;

public interface PublicId
extends Comparable<PublicId> {
    public static boolean equals(PublicId one, PublicId two) {
        if (one == two) {
            return true;
        }
        UUID[] oneUuids = one.asUuidArray();
        return Arrays.stream(two.asUuidArray()).anyMatch(twoUuid -> {
            for (UUID oneUuid : oneUuids) {
                if (!twoUuid.equals(oneUuid)) continue;
                return true;
            }
            return false;
        });
    }

    public UUID[] asUuidArray();

    public int uuidCount();

    default public boolean contains(UUID uuid) {
        return this.asUuidList().contains((Object)uuid);
    }

    default public ImmutableList<UUID> asUuidList() {
        return Lists.immutable.of((Object[])this.asUuidArray());
    }

    public void forEach(LongConsumer var1);

    @Override
    default public int compareTo(PublicId o) {
        if (this == o) {
            return 0;
        }
        Object[] thisArray = this.asUuidArray();
        Object[] thatArray = o.asUuidArray();
        Arrays.sort(thisArray);
        Arrays.sort(thatArray);
        return Arrays.compare((Comparable[])thisArray, (Comparable[])thatArray);
    }

    default public int publicIdHash() {
        return Arrays.hashCode(UuidUtil.asArray(this.asUuidArray()));
    }

    default public String idString() {
        return PublicId.idString(this.asUuidArray());
    }

    public static String idString(UUID[] uuids) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < uuids.length && i <= 32; ++i) {
            sb.append("\"");
            sb.append(uuids[i].toString());
            sb.append("\"");
            sb.append(", ");
            if (i != 32) continue;
            sb.append("..., ");
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        sb.deleteCharAt(sb.length() - 1);
        sb.append("]");
        return sb.toString();
    }
}

