/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id;

import dev.ikm.tinkar.common.binary.Decoder;
import dev.ikm.tinkar.common.binary.DecoderInput;
import dev.ikm.tinkar.common.binary.Encodable;
import dev.ikm.tinkar.common.binary.EncoderOutput;
import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.id.PublicIds;
import dev.ikm.tinkar.common.util.text.NaturalOrder;

public class PublicIdStringKey<T>
implements Comparable<PublicIdStringKey>,
Encodable {
    final PublicId publicId;
    String string;

    public PublicIdStringKey(PublicId publicId, String string) {
        this.publicId = publicId;
        this.string = string;
    }

    public static PublicIdStringKey make(String string) {
        return new PublicIdStringKey(PublicIds.newRandom(), string);
    }

    @Decoder
    public static PublicIdStringKey decode(DecoderInput in) {
        switch (Encodable.checkVersion(in)) {
            default: 
        }
        return new PublicIdStringKey(PublicIds.of(in.readUuidArray()), in.readString());
    }

    @Override
    public void encode(EncoderOutput out) {
        out.writeUuidArray(this.publicId.asUuidArray());
        out.writeString(this.string);
    }

    @Override
    public int compareTo(PublicIdStringKey o) {
        int comparison = NaturalOrder.compareStrings(this.string, o.getString());
        if (comparison != 0) {
            return comparison;
        }
        return this.publicId.compareTo(o.getPublicId());
    }

    public String getString() {
        return this.string;
    }

    public PublicId getPublicId() {
        return this.publicId;
    }

    public int hashCode() {
        return this.publicId.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicIdStringKey that = (PublicIdStringKey)o;
        return this.publicId.equals(that.getPublicId());
    }

    public String toString() {
        return this.string;
    }

    public void updateString(String string) {
        this.string = string;
    }
}

