/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id.impl;

import dev.ikm.tinkar.common.id.IntIdList;
import dev.ikm.tinkar.common.service.PrimitiveData;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public final class IntIdListArray
implements IntIdList {
    private final int[] elements;

    public IntIdListArray(int ... newElements) {
        this.elements = newElements;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public IntStream intStream() {
        return IntStream.of(this.elements);
    }

    @Override
    public boolean contains(int value) {
        for (int element : this.elements) {
            if (value != element) continue;
            return true;
        }
        return false;
    }

    @Override
    public int[] toArray() {
        return this.elements;
    }

    @Override
    public void forEach(IntConsumer consumer) {
        for (int element : this.elements) {
            consumer.accept(element);
        }
    }

    @Override
    public int get(int index) {
        return this.elements[index];
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    public boolean equals(Object obj) {
        IntIdList intIdList;
        if (this == obj) {
            return true;
        }
        return obj instanceof IntIdList && (intIdList = (IntIdList)obj).size() == this.elements.length && Arrays.equals(this.toArray(), intIdList.toArray());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IntIdList[");
        for (int i = 0; i < this.elements.length && i <= 32; ++i) {
            sb.append(PrimitiveData.textWithNid(this.elements[i])).append(", ");
            if (i != 32) continue;
            sb.append("..., ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }
}

