/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id.impl;

import dev.ikm.tinkar.common.id.IntIdSet;
import dev.ikm.tinkar.common.service.PrimitiveData;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;

public class IntIdSetArray
implements IntIdSet {
    private final int[] elements;

    private IntIdSetArray(int ... newElements) {
        this.elements = newElements;
    }

    public static IntIdSetArray newIntIdSet(int ... newElements) {
        Arrays.sort(newElements);
        return new IntIdSetArray(newElements);
    }

    public static IntIdSetArray newIntIdSetAlreadySorted(int ... newElements) {
        return new IntIdSetArray(newElements);
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public IntStream intStream() {
        return IntStream.of(this.elements);
    }

    @Override
    public boolean contains(int value) {
        if (this.elements.length < 32) {
            for (int element : this.elements) {
                if (value != element) continue;
                return true;
            }
            return false;
        }
        return Arrays.binarySearch(this.elements, value) >= 0;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.length == 0;
    }

    @Override
    public int[] toArray() {
        return this.elements;
    }

    @Override
    public void forEach(IntConsumer consumer) {
        for (int element : this.elements) {
            consumer.accept(element);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntIdSet) {
            int[] elements2;
            IntIdSet intIdSet = (IntIdSet)obj;
            if (this.elements.length != intIdSet.size()) {
                return false;
            }
            if (intIdSet instanceof IntIdSetArray) {
                IntIdSetArray intIdSetArray = (IntIdSetArray)intIdSet;
                elements2 = intIdSetArray.elements;
            } else {
                elements2 = intIdSet.toArray();
                Arrays.sort(elements2);
            }
            if (intIdSet.size() == this.elements.length && Arrays.equals(this.elements, elements2)) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IntIdSet[");
        for (int i = 0; i < this.elements.length && i <= 32; ++i) {
            sb.append(PrimitiveData.textWithNid(this.elements[i])).append(", ");
            if (i != 32) continue;
            sb.append("..., ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }
}

