/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.common.id.impl;

import dev.ikm.tinkar.common.id.IntIdSet;
import dev.ikm.tinkar.common.service.PrimitiveData;
import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.stream.IntStream;
import org.roaringbitmap.RoaringBitmap;

public class IntIdSetRoaring
extends RoaringBitmap
implements IntIdSet {
    private IntIdSetRoaring() {
    }

    public static IntIdSet newIntIdSet(int ... newElements) {
        Arrays.sort(newElements);
        IntIdSetRoaring roaring = new IntIdSetRoaring();
        roaring.add(newElements);
        return roaring;
    }

    public static IntIdSet newIntIdSetAlreadySorted(int ... newElements) {
        IntIdSetRoaring roaring = new IntIdSetRoaring();
        roaring.add(newElements);
        return roaring;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntIdSet) {
            IntIdSet intIdSet = (IntIdSet)obj;
            if (this.size() != intIdSet.size()) {
                return false;
            }
            if (intIdSet instanceof IntIdSetRoaring) {
                IntIdSetRoaring intIdSetRoaring = (IntIdSetRoaring)intIdSet;
                return this.equals(intIdSetRoaring);
            }
            int[] elements1 = this.toArray();
            Arrays.sort(elements1);
            int[] elements2 = intIdSet.toArray();
            Arrays.sort(elements2);
            return Arrays.equals(elements1, elements2);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("IntIdSet[");
        boolean limited = this.size() > 32;
        this.intStream().limit(32L).forEach(nid -> sb.append(PrimitiveData.textWithNid(nid)).append(", "));
        if (limited) {
            sb.append("..., ");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    @Override
    public int size() {
        return this.getCardinality();
    }

    @Override
    public IntStream intStream() {
        return this.stream();
    }

    @Override
    public void forEach(IntConsumer consumer) {
        this.forEach(new ConsumerAdaptor(consumer));
    }

    private static class ConsumerAdaptor
    implements org.roaringbitmap.IntConsumer {
        IntConsumer adaptee;

        public ConsumerAdaptor(IntConsumer adaptee) {
            this.adaptee = adaptee;
        }

        public void accept(int value) {
            this.adaptee.accept(value);
        }
    }
}

